/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.web;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.adempiere.util.ServerContext;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.br;
import org.apache.ecs.xhtml.font;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.h2;
import org.apache.ecs.xhtml.hr;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.strong;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.tr;
import org.compiere.Adempiere;
import org.compiere.model.AdempiereProcessorLog;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MSession;
import org.compiere.model.MSysConfig;
import org.compiere.model.MSystem;
import org.compiere.model.Query;
import org.compiere.server.AdempiereServerGroup;
import org.compiere.server.AdempiereServerMgr;
import org.compiere.server.IServerManager;
import org.compiere.server.LogFileInfo;
import org.compiere.server.ServerCount;
import org.compiere.server.ServerInstance;
import org.compiere.server.SystemInfo;
import org.compiere.server.TrxInfo;
import org.compiere.util.CLogFile;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CacheInfo;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUtil;
import org.idempiere.distributed.IClusterMember;
import org.idempiere.distributed.IClusterService;
import org.idempiere.server.cluster.ClusterServerMgr;
import org.idempiere.server.cluster.callable.DeleteLogsCallable;
import org.idempiere.server.cluster.callable.GetLogInfoCallable;
import org.idempiere.server.cluster.callable.ReadLogCallable;
import org.idempiere.server.cluster.callable.RotateLogCallable;
import org.idempiere.server.cluster.callable.SetTraceLevelCallable;

public class AdempiereMonitor
extends HttpServlet {
    private static final long serialVersionUID = -7455613826465213838L;
    private static final CLogger log = CLogger.getCLogger(AdempiereMonitor.class);
    private static IServerManager m_serverMgr = null;
    private static volatile ArrayList<File> m_dirAccessList = null;
    private ScheduledFuture<?> serverMgrFuture = null;
    private static final String REQUEST_MESSAGE_ATTRIBUTE = "requestMessage";
    private static final String s_dirAccessFileName = "dirAccess.txt";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean xmlOutput = false;
        String responseType = request.getParameter("responseContentType");
        xmlOutput = "xml".equalsIgnoreCase(responseType);
        if (this.processLogParameter(request, response)) {
            if (xmlOutput) {
                this.createXMLSummaryPage(request, response);
            }
            return;
        }
        if (this.processTraceParameter(request, response)) {
            if (xmlOutput) {
                this.createXMLSummaryPage(request, response);
            }
            return;
        }
        if (this.processEMailParameter(request, response)) {
            if (xmlOutput) {
                this.createXMLSummaryPage(request, response);
            }
            return;
        }
        if (this.processCacheParameter(request, response)) {
            if (xmlOutput) {
                this.createXMLSummaryPage(request, response);
            }
            return;
        }
        if (this.processNodeInfoPage(request, response)) {
            if (xmlOutput) {
                this.createXMLSummaryPage(request, response);
            }
            return;
        }
        if (!this.processRunNowParameter(request)) {
            this.processActionParameter(request, response);
        }
        if (response.isCommitted()) {
            return;
        }
        if (xmlOutput) {
            this.createXMLSummaryPage(request, response);
        } else {
            this.createSummaryPage(request, response, false);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private p getRequestMessage(HttpServletRequest request) {
        p message = (p)request.getAttribute(REQUEST_MESSAGE_ATTRIBUTE);
        if (message == null) {
            message = new p();
            request.setAttribute(REQUEST_MESSAGE_ATTRIBUTE, (Object)message);
        }
        return message;
    }

    private boolean processLogParameter(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServerInstance server;
        String serverID = WebUtil.getParameter((HttpServletRequest)request, (String)"Log");
        if (serverID == null || serverID.length() == 0) {
            return false;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("ServerID=" + serverID);
        }
        if ((server = this.getServerManager().getServerInstance(serverID)) == null) {
            p message = this.getRequestMessage(request);
            message.addElement((Element)new strong("Server not found: "));
            message.addElement(serverID);
            return false;
        }
        WebDoc doc = WebDoc.create((String)"iDempiere Server Monitor Log");
        body b = doc.getBody();
        p para = new p();
        a link = new a("idempiereMonitor#" + serverID, "Return");
        para.addElement((Element)link);
        b.addElement((Element)para);
        b.addElement((Element)new h2(server.getModel().getName()));
        table table2 = new table();
        table2.setBorder(1);
        table2.setCellSpacing(2);
        table2.setCellPadding(2);
        tr line = new tr();
        line.addElement((Element)new th().addElement("Created"));
        line.addElement((Element)new th().addElement("Summary"));
        line.addElement((Element)new th().addElement("Reference"));
        line.addElement((Element)new th().addElement("TextMsg"));
        table2.addElement((Element)line);
        AdempiereProcessorLog[] logs = server.getModel().getLogs();
        int i = 0;
        while (i < logs.length) {
            AdempiereProcessorLog pLog = logs[i];
            line = new tr();
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)pLog.getCreated())));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)pLog.getSummary())));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)pLog.getReference())));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)pLog.getTextMsg())));
            table2.addElement((Element)line);
            ++i;
        }
        b.addElement((Element)table2);
        link = new a("#top", "Top");
        b.addElement((Element)link);
        WebUtil.createResponse((HttpServletRequest)request, (HttpServletResponse)response, (HttpServlet)this, null, (WebDoc)doc, (boolean)false);
        return true;
    }

    private boolean processRunNowParameter(HttpServletRequest request) throws ServletException, IOException {
        ServerInstance server;
        String serverID = WebUtil.getParameter((HttpServletRequest)request, (String)"RunNow");
        if (serverID == null || serverID.length() == 0) {
            return false;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("ServerID=" + serverID);
        }
        if ((server = this.getServerManager().getServerInstance(serverID)) == null) {
            p message = this.getRequestMessage(request);
            message.addElement((Element)new strong("Server not found: "));
            message.addElement(serverID);
            return false;
        }
        String error = this.getServerManager().runNow(serverID);
        if (!Util.isEmpty((String)error, (boolean)true)) {
            p message = this.getRequestMessage(request);
            message.addElement((Element)new strong(error));
            message.addElement(serverID);
        }
        return true;
    }

    private void processActionParameter(HttpServletRequest request, HttpServletResponse response) {
        String action = WebUtil.getParameter((HttpServletRequest)request, (String)"Action");
        if (action == null || action.length() == 0) {
            return;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Action=" + action);
        }
        try {
            boolean start = action.startsWith("Start");
            boolean reload = action.startsWith("Reload");
            p message = this.getRequestMessage(request);
            String msg = (start ? "Started" : "Stopped") + ": ";
            message.addElement((Element)new strong(msg));
            String serverID = action.substring(action.indexOf(95) + 1);
            boolean ok = false;
            if (serverID.equals("All")) {
                ok = start ? this.getServerManager().startAll() == null : this.getServerManager().stopAll() == null;
                message.addElement("All");
            } else if (reload) {
                ok = this.getServerManager().reload() == null;
                this.createSummaryPage(request, response, true);
                m_dirAccessList = this.getDirAcessList();
            } else {
                ServerInstance server = this.getServerManager().getServerInstance(serverID);
                if (server == null) {
                    message = new p();
                    message.addElement((Element)new strong("Server not found: "));
                    message.addElement(serverID);
                    request.setAttribute(REQUEST_MESSAGE_ATTRIBUTE, (Object)message);
                    return;
                }
                ok = start ? this.getServerManager().start(serverID) == null : this.getServerManager().stop(serverID) == null;
                message.addElement(server.getModel().getName());
            }
            message.addElement(ok ? " - OK" : " - Error!");
        }
        catch (Exception e) {
            p message = new p();
            message.addElement((Element)new strong("Error processing parameter: " + action));
            message.addElement((Element)new br());
            message.addElement(e.toString());
            request.setAttribute(REQUEST_MESSAGE_ATTRIBUTE, (Object)message);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean processTraceParameter(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        File file;
        String traceCmd = WebUtil.getParameter((HttpServletRequest)request, (String)"Trace");
        String traceLevel = WebUtil.getParameter((HttpServletRequest)request, (String)"TraceLevel");
        String nodeId = WebUtil.getParameter((HttpServletRequest)request, (String)"nodeId");
        if (traceLevel != null && traceLevel.length() > 0) {
            if (log.isLoggable(Level.INFO)) {
                log.info("New Level: " + traceLevel);
            }
            SetTraceLevelCallable callable = new SetTraceLevelCallable(traceLevel);
            try {
                if (!Util.isEmpty((String)nodeId, (boolean)true)) {
                    ClusterServerMgr.getClusterService().execute((Callable)callable, ClusterServerMgr.getClusterMember(nodeId)).get();
                } else {
                    callable.call();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return false;
        }
        if (traceCmd == null || traceCmd.length() == 0) {
            return false;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Command: " + traceCmd);
        }
        CLogFile fileHandler = CLogFile.get((boolean)false, null, (boolean)false);
        if (traceCmd.equals("ROTATE")) {
            RotateLogCallable callable = new RotateLogCallable();
            try {
                if (!Util.isEmpty((String)nodeId, (boolean)true)) {
                    ClusterServerMgr.getClusterService().execute((Callable)callable, ClusterServerMgr.getClusterMember(nodeId)).get();
                } else {
                    callable.call();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return false;
        }
        if (traceCmd.equals("DELETE")) {
            DeleteLogsCallable callable = new DeleteLogsCallable();
            try {
                if (!Util.isEmpty((String)nodeId, (boolean)true)) {
                    ClusterServerMgr.getClusterService().execute((Callable)callable, ClusterServerMgr.getClusterMember(nodeId)).get();
                } else {
                    callable.call();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return false;
        }
        if (!Util.isEmpty((String)nodeId, (boolean)true)) {
            GetLogInfoCallable.LogInfo logInfo;
            IClusterMember iClusterMember;
            IClusterService service;
            block53: {
                GetLogInfoCallable infoCallable = new GetLogInfoCallable(traceCmd);
                service = ClusterServerMgr.getClusterService();
                iClusterMember = ClusterServerMgr.getClusterMember(nodeId);
                logInfo = (GetLogInfoCallable.LogInfo)service.execute((Callable)infoCallable, iClusterMember).get();
                if (logInfo != null && logInfo.getLength() != 0L) break block53;
                return false;
            }
            try {
                Throwable throwable = null;
                Object var12_33 = null;
                try (ServletOutputStream out = response.getOutputStream();){
                    response.setContentType("text/plain");
                    response.setBufferSize(2048);
                    response.setContentLength((int)logInfo.getLength());
                    int i = 0;
                    while (i < logInfo.getNoOfBlocks()) {
                        ReadLogCallable callable = new ReadLogCallable(logInfo.getFileName(), i);
                        byte[] contents = (byte[])service.execute((Callable)callable, iClusterMember).get();
                        if (contents == null || contents.length == 0) break;
                        out.write(contents);
                        ++i;
                    }
                    out.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                return true;
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getMessage(), (Throwable)e);
                return false;
            }
        }
        if (fileHandler != null && fileHandler.getFileName().equals(traceCmd)) {
            fileHandler.flush();
        }
        if (!(file = new File(traceCmd)).exists() || !file.canRead()) {
            log.warning("Did not find File: " + traceCmd);
            return false;
        }
        if (file.length() == 0L) {
            log.warning("File Length=0: " + traceCmd);
            return false;
        }
        boolean found = false;
        if (m_dirAccessList == null) {
            m_dirAccessList = this.getDirAcessList();
        }
        for (File file2 : m_dirAccessList) {
            if (!file.getCanonicalPath().startsWith(file2.getAbsolutePath())) continue;
            found = true;
            break;
        }
        if (!found) {
            log.warning("Couldn't find file in directories that allowed to access");
            for (File file3 : m_dirAccessList) {
                log.warning(" - " + String.valueOf(file3.getAbsoluteFile()));
            }
            return false;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Streaming: " + traceCmd);
        }
        try {
            Throwable throwable = null;
            Iterator<File> iterator = null;
            try (FileInputStream fis = new FileInputStream(file);){
                long time = System.currentTimeMillis();
                int fileLength = (int)file.length();
                int bufferSize = 2048;
                byte[] buffer = new byte[bufferSize];
                ServletOutputStream out = response.getOutputStream();
                response.setContentType("text/plain");
                response.setBufferSize(bufferSize);
                response.setContentLength(fileLength);
                int read = 0;
                while ((read = fis.read(buffer)) > 0) {
                    out.write(buffer, 0, read);
                }
                out.flush();
                out.close();
                time = System.currentTimeMillis() - time;
                double speed = (double)fileLength / 1024.0 / ((double)time / 1000.0);
                if (log.isLoggable(Level.INFO)) {
                    log.info("length=" + fileLength + " - " + time + " ms - " + speed + " kB/sec");
                }
            }
            catch (Throwable throwable3) {
                void var9_24;
                if (throwable == null) {
                    Throwable throwable4 = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw var9_24;
            }
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "stream" + String.valueOf(exception));
            return false;
        }
        return true;
    }

    private boolean processEMailParameter(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String email = WebUtil.getParameter((HttpServletRequest)request, (String)"EMail");
        if (email == null || email.length() == 0) {
            return false;
        }
        int AD_Client_ID = -1;
        try {
            AD_Client_ID = Integer.parseInt(email);
        }
        catch (Exception e) {
            log.warning("Parsing: " + email + " - " + e.toString());
        }
        if (AD_Client_ID < 0) {
            p message = this.getRequestMessage(request);
            message.addElement("No EMail: " + email);
            return false;
        }
        MClient client = MClient.get((Properties)new Properties(), (int)AD_Client_ID);
        if (log.isLoggable(Level.INFO)) {
            log.info("Test: " + String.valueOf(client));
        }
        p message = this.getRequestMessage(request);
        message.addElement(client.getName() + ": " + client.testEMail());
        return false;
    }

    private boolean processCacheParameter(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String cmd = WebUtil.getParameter((HttpServletRequest)request, (String)"CacheReset");
        if (cmd == null || cmd.length() == 0) {
            return this.createCacheDetailsPage(request, response);
        }
        String tableName = WebUtil.getParameter((HttpServletRequest)request, (String)"CacheTableName");
        String record_ID = WebUtil.getParameter((HttpServletRequest)request, (String)"CacheRecord_ID");
        p message = this.getRequestMessage(request);
        try {
            if (tableName == null || tableName.length() == 0) {
                CacheMgt.get().reset();
                message.addElement("Cache Reset: All");
            } else if (record_ID == null || record_ID.length() == 0) {
                CacheMgt.get().reset(tableName);
                message.addElement("Cache Reset: " + tableName);
            } else {
                CacheMgt.get().reset(tableName, Integer.parseInt(record_ID));
                message.addElement("Cache Reset: " + tableName + ", Record_ID=" + record_ID);
            }
        }
        catch (Exception e) {
            log.severe(e.toString());
            message.addElement("Error: " + e.toString());
        }
        return false;
    }

    private void createSummaryPage(HttpServletRequest request, HttpServletResponse response, boolean refresh) throws ServletException, IOException {
        ServerInstance server;
        p para;
        WebDoc doc = WebDoc.create((String)"iDempiere Server Monitor");
        AdempiereServerGroup.get().dump();
        body bb = new body();
        bb = doc.getBody();
        p message = this.getRequestMessage(request);
        if (message != null && message.elements().hasMoreElements()) {
            bb.addElement((Element)new hr());
            bb.addElement((Element)message);
            bb.addElement((Element)new hr());
        }
        table table2 = new table();
        table2.setBorder(1);
        table2.setCellSpacing(2);
        table2.setCellPadding(2);
        tr line = new tr();
        line.addElement((Element)new th().addElement(Adempiere.getName()));
        line.addElement((Element)new td().addElement(Adempiere.getVersion()));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement(Adempiere.getImplementationVendor()));
        line.addElement((Element)new td().addElement(Adempiere.getImplementationVersion()));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Manager"));
        line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)this.getServerManager().getDescription())));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Start - Elapsed"));
        line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)this.formatTimestampWithTimeZone(0, this.getServerManager().getStartTime())) + " - " + TimeUtil.formatElapsed((Timestamp)this.getServerManager().getStartTime())));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Servers"));
        line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)this.createServerCountMessage(this.getServerManager().getServerCount()))));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Last Updated"));
        line.addElement((Element)new td().addElement(this.formatTimestampWithTimeZone(0, new Timestamp(System.currentTimeMillis()))));
        table2.addElement((Element)line);
        bb.addElement((Element)table2);
        IClusterService service = ClusterServerMgr.getClusterService();
        Collection members = null;
        IClusterMember local = null;
        if (service != null) {
            members = service.getMembers();
            local = service.getLocalMember();
            if (members.size() > 1 && local != null) {
                line = new tr();
                line.addElement((Element)new th().addElement("Cluster Nodes"));
                para = new p();
                StringBuilder nodeBuilder = new StringBuilder(local.getId());
                InetAddress address = local.getAddress();
                if (address != null) {
                    nodeBuilder.append(" (").append(address.getCanonicalHostName()).append(")");
                }
                para.addElement(nodeBuilder.toString());
                for (IClusterMember member : members) {
                    if (member.getId().equals(local.getId())) continue;
                    para.addElement(" - ");
                    nodeBuilder = new StringBuilder(member.getId());
                    address = member.getAddress();
                    if (address != null) {
                        nodeBuilder.append(" (").append(address.getCanonicalHostName()).append(")");
                    }
                    a link = new a("idempiereMonitor?NodeInfo=" + member.getId(), nodeBuilder.toString());
                    para.addElement((Element)link);
                }
                line.addElement((Element)new td().addElement((Element)para));
                table2.addElement((Element)line);
            }
        }
        para = new p();
        a link = new a("idempiereMonitor?Action=Start_All", "Start All");
        para.addElement((Element)link);
        para.addElement(" - ");
        link = new a("idempiereMonitor?Action=Stop_All", "Stop All");
        para.addElement((Element)link);
        para.addElement(" - ");
        link = new a("idempiereMonitor?Action=Reload", "Reload");
        para.addElement((Element)link);
        para.addElement(" - ");
        link = new a("idempiereMonitor", "Refresh");
        para.addElement((Element)link);
        bb.addElement((Element)para);
        bb.addElement((Element)new hr());
        para = new p();
        ServerInstance[] servers = this.getServerManager().getServerInstances();
        Arrays.sort(servers, new Comparator<ServerInstance>(){

            @Override
            public int compare(ServerInstance o1, ServerInstance o2) {
                if (o1 == null || o1.getModel() == null || o1.getModel().getName() == null || o2 == null || o2.getModel() == null || o2.getModel().getName() == null) {
                    return 0;
                }
                return o1.getModel().getName().compareTo(o2.getModel().getName());
            }
        });
        int i = 0;
        while (i < servers.length) {
            if (i > 0) {
                para.addElement((Element)new br());
            }
            server = servers[i];
            link = new a("#" + server.getServerId(), server.getModel().getName());
            para.addElement((Element)link);
            font status = null;
            status = server.isStarted() ? (server.isSleeping() ? new font().setColor("#008000").addElement(" (Started)") : new font().setColor("#008000").addElement(" (Running)")) : new font().setColor("#FF0000").addElement(" (Stopped)");
            para.addElement((Element)status);
            ++i;
        }
        bb.addElement((Element)para);
        try {
            Properties ctx = new Properties();
            ServerContext.setCurrentInstance((Properties)ctx);
            this.createLogMgtPage(bb, members, local);
        }
        finally {
            ServerContext.dispose();
        }
        bb.removeEndEndModifier();
        i = 0;
        while (i < servers.length) {
            server = servers[i];
            bb.addElement((Element)new hr());
            bb.addElement((Element)new a().setName(server.getServerId()));
            bb.addElement((Element)new h2(server.getModel().getName()));
            table2 = new table();
            table2.setBorder(1);
            table2.setCellSpacing(2);
            table2.setCellPadding(2);
            line = new tr();
            if (server.isStarted()) {
                msg = "Stop";
                link = new a("idempiereMonitor?Action=Stop_" + server.getServerId(), msg);
                if (server.isSleeping()) {
                    line.addElement((Element)new th().addElement("Sleeping"));
                    line.addElement((Element)new td().addElement((Element)link));
                } else {
                    line.addElement((Element)new th().addElement("Running"));
                    line.addElement((Element)new td().addElement((Element)link));
                }
                table2.addElement((Element)line);
                line = new tr();
                line.addElement((Element)new th().addElement("Start - Elapsed"));
                line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)this.formatTimestampWithTimeZone(server.getModel().getAD_Client_ID(), server.getStartTime())) + " - " + TimeUtil.formatElapsed((Timestamp)server.getStartTime())));
            } else {
                msg = "Start";
                line.addElement((Element)new th().addElement("Not Started"));
                link = new a("idempiereMonitor?Action=Start_" + server.getServerId(), msg);
                line.addElement((Element)new td().addElement((Element)link));
            }
            table2.addElement((Element)line);
            line = new tr();
            line.addElement((Element)new th().addElement("Description"));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)server.getModel().getDescription())));
            table2.addElement((Element)line);
            line = new tr();
            line.addElement((Element)new th().addElement("Last Run"));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)this.formatTimestampWithTimeZone(server.getModel().getAD_Client_ID(), server.getModel().getDateLastRun()))));
            table2.addElement((Element)line);
            line = new tr();
            line.addElement((Element)new th().addElement("Info"));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)server.getServerInfo())));
            table2.addElement((Element)line);
            line = new tr();
            line.addElement((Element)new th().addElement("Next Run"));
            td td2 = new td();
            td2.addElement(WebEnv.getCellContent((Object)this.formatTimestampWithTimeZone(server.getModel().getAD_Client_ID(), server.getModel().getDateNextRun(false))));
            td2.addElement(" - ");
            link = new a("idempiereMonitor?RunNow=" + server.getServerId(), "(Run Now)");
            td2.addElement((Element)link);
            line.addElement((Element)td2);
            table2.addElement((Element)line);
            line = new tr();
            line.addElement((Element)new th().addElement("Statistics"));
            line.addElement((Element)new td().addElement(server.getStatistics()));
            table2.addElement((Element)line);
            if (server.getClusterMember() != null && members != null && members.size() > 1) {
                String ip;
                InetAddress address = server.getClusterMember().getAddress();
                String string = ip = address != null ? address.getHostAddress() : null;
                if (ip != null && (ip.startsWith("10.") || ip.startsWith("172.16") || ip.startsWith("192.168"))) {
                    line = new tr();
                    line.addElement((Element)new th().addElement("Cluster Node IP"));
                    line.addElement((Element)new td().addElement(ip));
                }
                table2.addElement((Element)line);
                line = new tr();
                line.addElement((Element)new th().addElement("Cluster Node Id"));
                line.addElement((Element)new td().addElement(server.getClusterMember().getId()));
                table2.addElement((Element)line);
            }
            bb.addElement((Element)table2);
            link = new a("#top", "Top");
            bb.addElement((Element)link);
            bb.addElement(" - ");
            link = new a("idempiereMonitor?Log=" + server.getServerId(), "Log");
            bb.addElement((Element)link);
            bb.addElement(" - ");
            link = new a("idempiereMonitor", "Refresh");
            bb.addElement((Element)link);
            ++i;
        }
        WebUtil.createResponse((HttpServletRequest)request, (HttpServletResponse)response, (HttpServlet)this, null, (WebDoc)doc, (boolean)false);
    }

    private String formatTimestampWithTimeZone(int AD_Client_ID, Timestamp ts) {
        return this.formatTimestampWithTimeZone(AD_Client_ID, (Date)ts);
    }

    private String formatTimestampWithTimeZone(int AD_Client_ID, Date date) {
        if (date == null) {
            return "";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ISO_ZONED_DATE_TIME;
        MClientInfo clientInfo = MClientInfo.get((int)AD_Client_ID);
        if (!Util.isEmpty((String)clientInfo.getTimeZone())) {
            try {
                formatter = formatter.withZone(ZoneId.of(clientInfo.getTimeZone()));
            }
            catch (Exception exception) {
                formatter = formatter.withZone(ZoneId.systemDefault());
            }
        } else {
            formatter = formatter.withZone(ZoneId.systemDefault());
        }
        return formatter.format(date.toInstant().truncatedTo(ChronoUnit.SECONDS));
    }

    private String createServerCountMessage(ServerCount serverCount) {
        StringBuilder builder = new StringBuilder();
        if (serverCount != null) {
            builder.append(serverCount.getStarted() + serverCount.getStopped()).append(" - Started=").append(serverCount.getStarted()).append(" - Stopped=").append(serverCount.getStopped());
        }
        return builder.toString();
    }

    private void createXMLSummaryPage(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/xml");
        PrintWriter writer = response.getWriter();
        writer.println("<server-response>");
        writer.println("\t<message>");
        p message = this.getRequestMessage(request);
        if (message != null && message.elements().hasMoreElements()) {
            writer.println(message);
        }
        writer.println("\t</message>");
        writer.print("\t<name>");
        writer.print(Adempiere.getName());
        writer.println("</name>");
        writer.print("\t<version>");
        writer.print(Adempiere.getVersion());
        writer.println("</version>");
        writer.print("\t<implementation-vendor>");
        writer.print(Adempiere.getImplementationVendor());
        writer.println("</implementation-vendor>");
        writer.print("\t<implementation-version>");
        writer.print(Adempiere.getImplementationVersion());
        writer.println("</implementation-version>");
        writer.println("\t<server-manager>");
        writer.print("\t\t<description>");
        writer.print(this.getServerManager().getDescription());
        writer.println("</description>");
        writer.print("\t\t<start-time>");
        writer.print(this.formatTimestampWithTimeZone(0, this.getServerManager().getStartTime()));
        writer.println("</start-time>");
        writer.print("\t\t<server-count>");
        writer.print(this.getServerManager().getServerCount());
        writer.println("</server-count>");
        ServerInstance[] servers = this.getServerManager().getServerInstances();
        int i = 0;
        while (i < servers.length) {
            ServerInstance server = servers[i];
            writer.println("\t\t<server>");
            writer.print("\t\t\t<id>");
            writer.print(server.getServerId());
            writer.println("</id>");
            writer.print("\t\t\t<name>");
            writer.print(server.getModel().getName());
            writer.println("</name>");
            writer.print("\t\t\t<description>");
            writer.print(server.getModel().getDescription());
            writer.println("</description>");
            writer.print("\t\t\t<info>");
            writer.print(server.getServerInfo());
            writer.println("</info>");
            writer.print("\t\t\t<status>");
            if (server.isStarted()) {
                if (server.isInterrupted()) {
                    writer.print("Interrupted");
                } else if (server.isSleeping()) {
                    writer.print("Sleeping");
                } else {
                    writer.print("Running");
                }
            } else {
                writer.print("Stopped");
            }
            writer.println("</status>");
            writer.print("\t\t\t<start-time>");
            writer.print(this.formatTimestampWithTimeZone(server.getModel().getAD_Client_ID(), server.getStartTime()));
            writer.println("</start-time>");
            writer.print("\t\t\t<last-run>");
            writer.print(this.formatTimestampWithTimeZone(server.getModel().getAD_Client_ID(), server.getModel().getDateLastRun()));
            writer.println("</last-run>");
            writer.print("\t\t\t<next-run>");
            writer.print(this.formatTimestampWithTimeZone(server.getModel().getAD_Client_ID(), server.getModel().getDateNextRun(false)));
            writer.println("</next-run>");
            writer.print("\t\t\t<statistics>");
            writer.print(server.getStatistics());
            writer.println("</statistics>");
            writer.println("\t\t</server>");
            ++i;
        }
        writer.println("\t</server-manager>");
        writer.flush();
    }

    private void createLogMgtPage(body bb, Collection<IClusterMember> members, IClusterMember local) {
        LogFileInfo[] logFiles;
        TrxInfo[] trxs;
        bb.addElement((Element)new hr());
        table table2 = new table();
        table2.setBorder(1);
        table2.setCellSpacing(2);
        table2.setCellPadding(2);
        MSystem system = MSystem.get((Properties)Env.getCtx());
        SystemInfo systemInfo = SystemInfo.getLocalSystemInfo();
        tr line = new tr();
        line.addElement((Element)new th().addElement(Adempiere.getURL()));
        line.addElement((Element)new td().addElement(systemInfo.getPropertyFileName()));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement(systemInfo.getOperatingSystem()));
        Object info = system.getName();
        if (system.getCustomPrefix() != null) {
            info = (String)info + " (" + system.getCustomPrefix() + ")";
        }
        line.addElement((Element)new td().addElement((String)info));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement(systemInfo.getJavaVM()));
        line.addElement((Element)new td().addElement("Average GC Time=" + systemInfo.getGarbageCollectionTime() / systemInfo.getGarbageCollectionCount() + " ms"));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement(systemInfo.getDatabaseDescription()));
        line.addElement((Element)new td().addElement(systemInfo.getDatabaseConnectionURL()));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("DB Connection Pool"));
        line.addElement((Element)new td().addElement(systemInfo.getDatabaseStatus()));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Processor"));
        line.addElement((Element)new td().addElement("" + systemInfo.getAvailableProcessors()));
        table2.addElement((Element)line);
        if (systemInfo.getAverageSystemLoad() >= 0.0) {
            line = new tr();
            line.addElement((Element)new th().addElement("System Load"));
            line.addElement((Element)new td().addElement(systemInfo.getAverageSystemLoad() + "%"));
            table2.addElement((Element)line);
        }
        line = new tr();
        line.addElement((Element)new th().addElement("VM Memory"));
        line.addElement((Element)new td().addElement(systemInfo.getMemoryUsage()));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Heap Memory"));
        line.addElement((Element)new td().addElement(systemInfo.getHeapMemoryUsage()));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Runtime " + systemInfo.getRuntimeName()));
        line.addElement((Element)new td().addElement(TimeUtil.formatElapsed((long)systemInfo.getRuntimeUpTime())));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Threads " + systemInfo.getThreadCount()));
        line.addElement((Element)new td().addElement("Peak=" + systemInfo.getPeakThreadCount() + ", Daemons=" + systemInfo.getDaemonThreadCount() + ", Total=" + systemInfo.getTotalStartedThreadCount()));
        table2.addElement((Element)line);
        TrxInfo[] trxInfoArray = trxs = systemInfo.getTrxInfos();
        int n = trxs.length;
        int n2 = 0;
        while (n2 < n) {
            TrxInfo trx = trxInfoArray[n2];
            line = new tr();
            line.addElement((Element)new th().addElement((trx.isActive() ? "Active" : "Inactive") + " Transaction "));
            td td2 = new td();
            if (Util.isEmpty((String)trx.getStackTrace())) {
                td2.addElement("Name=" + trx.getDisplayName() + ", StartTime=" + this.formatTimestampWithTimeZone(0, trx.getStartTime()));
                td2.setTitle(trx.getTrxName());
            } else {
                td2.setOnClick("var newwindow=window.open('','Popup', 'width=800,height=600');newwindow.document.write('<title>" + AdempiereMonitor.escapeEcmaScript(trx.getDisplayName()) + "</title><p><b>Transaction = " + trx.getDisplayName() + "</b></p><p><b>TrxName = " + trx.getTrxName() + "</b></p><pre>" + AdempiereMonitor.escapeEcmaScript(trx.getStackTrace()) + "</pre>')");
                label lbl = new label().addElement(trx.getDisplayName());
                lbl.setStyle("text-decoration: underline; color: blue");
                td2.addElement("Name=").addElement((Element)lbl).addElement(", StartTime=" + this.formatTimestampWithTimeZone(0, trx.getStartTime()));
                td2.setTitle("Click to see stack trace for " + trx.getTrxName());
            }
            line.addElement((Element)td2);
            table2.addElement((Element)line);
            ++n2;
        }
        line = new tr();
        line.addElement((Element)new th().addElement(CacheMgt.get().toStringX()));
        p cachePara = new p();
        cachePara.addElement((Element)new a("idempiereMonitor?CacheReset=Yes", "Reset Cache")).addElement(" - ").addElement((Element)new a("idempiereMonitor?CacheDetails=Yes", "Cache Details"));
        line.addElement((Element)new td().addElement((Element)cachePara));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement((Element)new label("TraceLevel").addElement("Trace Log Level")));
        form myForm = new form("idempiereMonitor", "post", "application/x-www-form-urlencoded");
        option[] options = new option[CLogMgt.LEVELS.length];
        int i = 0;
        while (i < options.length) {
            options[i] = new option(CLogMgt.LEVELS[i].getName());
            options[i].addElement(CLogMgt.LEVELS[i].getName());
            if (CLogMgt.LEVELS[i] == systemInfo.getLogLevel()) {
                options[i].setSelected(true);
            }
            ++i;
        }
        select sel = new select("TraceLevel", options);
        myForm.addElement((Element)sel);
        myForm.addElement((Element)new input("submit", "Set", "Set"));
        line.addElement((Element)new td().addElement((Element)myForm));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Trace File"));
        line.addElement((Element)new td().addElement((Element)new a("idempiereMonitor?Trace=" + systemInfo.getCurrentLogFile(), "Current", "Current", "Current")));
        table2.addElement((Element)line);
        line = new tr();
        p tlp = new p();
        tlp.addElement((Element)new a("idempiereMonitor?Trace=ROTATE", "Rotate Trace Log")).addElement(" - ").addElement((Element)new a("idempiereMonitor?Trace=DELETE", "Delete all Trace Logs"));
        line.addElement((Element)new th());
        line.addElement((Element)new td().addElement((Element)tlp));
        table2.addElement((Element)line);
        bb.addElement((Element)table2);
        p p2 = new p();
        p2.addElement((Element)new b("All Log Files: "));
        p2.addElement((Element)new br());
        LogFileInfo[] logFileInfoArray = logFiles = systemInfo.getLogFileInfos();
        int n3 = logFiles.length;
        int n4 = 0;
        while (n4 < n3) {
            String fileName;
            LogFileInfo logFile = logFileInfoArray[n4];
            if (logFile != logFiles[0]) {
                p2.addElement(" - ");
            }
            String displayName = fileName = logFile.getFileName();
            int index = fileName.lastIndexOf(File.separator);
            if (index > 1) {
                displayName = fileName.substring(index + 1);
            }
            a link = new a("idempiereMonitor?Trace=" + fileName, displayName, displayName, displayName);
            p2.addElement((Element)link);
            int size = (int)(logFile.getFileSize() / 1024L);
            if (size < 1024) {
                p2.addElement(" (" + size + "k)");
            } else {
                p2.addElement(" (" + size / 1024 + "M)");
            }
            ++n4;
        }
        bb.addElement((Element)p2);
        table2 = new table();
        table2.setBorder(1);
        table2.setCellSpacing(2);
        table2.setCellPadding(2);
        line = new tr();
        MClient[] clients = MClient.getAll((Properties)Env.getCtx(), (String)"AD_Client_ID");
        line.addElement((Element)new th().addElement("Tenant #" + clients.length + " - EMail Test:"));
        p2 = new p();
        int i2 = 0;
        while (i2 < clients.length) {
            MClient client = clients[i2];
            if (client.isActive()) {
                if (i2 > 0) {
                    p2.addElement(" - ");
                }
                p2.addElement((Element)new a("idempiereMonitor?EMail=" + client.getAD_Client_ID(), client.getName()));
            }
            ++i2;
        }
        if (clients.length == 0) {
            p2.addElement("&nbsp;");
        }
        line.addElement((Element)new td().addElement((Element)p2));
        table2.addElement((Element)line);
        line = new tr();
        List sessions = new Query(Env.getCtx(), "AD_Session", "Processed = 'N'", null).list();
        line.addElement((Element)new th().addElement("Active sessions #" + sessions.size()));
        p2 = new p();
        int i3 = 0;
        while (i3 < clients.length) {
            MClient client = clients[i3];
            if (client.isActive()) {
                if (i3 > 0) {
                    p2.addElement(" - ");
                }
                int count = 0;
                for (MSession session : sessions) {
                    if (session.getAD_Client_ID() != client.getAD_Client_ID()) continue;
                    ++count;
                }
                p2.addElement(client.getName() + " : " + count);
            }
            ++i3;
        }
        if (clients.length == 0) {
            p2.addElement("&nbsp;");
        }
        line.addElement((Element)new td().addElement((Element)p2));
        table2.addElement((Element)line);
        if (members != null && members.size() > 1) {
            line = new tr();
            line.addElement((Element)new th().addElement(""));
            p2 = null;
            for (IClusterMember member : members) {
                if (p2 == null) {
                    p2 = new p();
                } else {
                    p2.addElement(" - ");
                }
                p2.addElement(member.getId() + " : " + (member.getId().equals(local.getId()) ? systemInfo.getSessionCount() : SystemInfo.getClusterSessionCount(member)));
            }
            line.addElement((Element)new td().addElement((Element)p2));
            table2.addElement((Element)line);
        }
        line = new tr();
        boolean isSystemInMaintenance = MSysConfig.getBooleanValue((String)"SYSTEM_IN_MAINTENANCE_MODE", (boolean)false, (int)0);
        ArrayList<Integer> inMaintenanceClients = new ArrayList<Integer>();
        if (isSystemInMaintenance) {
            line.addElement((Element)new th().addElement("Maintenance Mode"));
        } else {
            int[] possiblyInMaintenanceClients;
            int[] nArray = possiblyInMaintenanceClients = DB.getIDsEx(null, (String)"SELECT AD_Client_ID FROM AD_SysConfig WHERE AD_Client_ID!=0 AND IsActive='Y' AND Name=?", (Object[])new Object[]{"SYSTEM_IN_MAINTENANCE_MODE"});
            int link = possiblyInMaintenanceClients.length;
            int n5 = 0;
            while (n5 < link) {
                int clientId = nArray[n5];
                boolean isTenantInMaintenance = MSysConfig.getBooleanValue((String)"SYSTEM_IN_MAINTENANCE_MODE", (boolean)false, (int)clientId);
                if (isTenantInMaintenance) {
                    inMaintenanceClients.add(clientId);
                }
                ++n5;
            }
            line.addElement((Element)new th().addElement("Maintenance Mode #" + inMaintenanceClients.size()));
        }
        p2 = new p();
        if (isSystemInMaintenance) {
            p2.addElement("All tenants are in maintenance mode");
        } else if (inMaintenanceClients.size() > 0) {
            boolean first = true;
            Iterator iterator = inMaintenanceClients.iterator();
            while (iterator.hasNext()) {
                int clientID = (Integer)iterator.next();
                MClient client = MClient.get((Properties)Env.getCtx(), (int)clientID);
                if (!client.isActive()) continue;
                if (!first) {
                    p2.addElement(" - ");
                }
                p2.addElement(client.getName());
                first = false;
            }
        } else {
            p2.addElement("All tenants are in normal operation mode");
        }
        if (clients.length == 0) {
            p2.addElement("&nbsp;");
        }
        line.addElement((Element)new td().addElement((Element)p2));
        table2.addElement((Element)line);
        bb.addElement((Element)table2);
    }

    public void init(ServletConfig config) throws ServletException {
        WebEnv.initWeb((ServletConfig)config);
        log.info("");
        int initialWaitSeconds = MSysConfig.getIntValue((String)"MONITOR_INITIAL_WAIT_FOR_CLUSTER_IN_SECONDS", (int)10);
        this.serverMgrFuture = Adempiere.getThreadPoolExecutor().schedule(() -> {
            try {
                try {
                    Properties ctx = new Properties();
                    Env.setContext((Properties)ctx, (String)"#AD_Client_ID", (int)0);
                    Env.setContext((Properties)ctx, (String)"#AD_User_ID", (int)10);
                    ServerContext.setCurrentInstance((Properties)ctx);
                    int maxSecondsToWait = MSysConfig.getIntValue((String)"MONITOR_MAX_WAIT_FOR_CLUSTER_IN_SECONDS", (int)180);
                    int totalWaitSeconds = initialWaitSeconds;
                    int waitSeconds = 5;
                    while (ClusterServerMgr.getClusterService() == null) {
                        try {
                            Thread.sleep(waitSeconds * 1000);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                        if (Thread.interrupted()) break;
                        if ((totalWaitSeconds += waitSeconds) < maxSecondsToWait) continue;
                        log.warning("Cluster Service did not start after " + totalWaitSeconds + " seconds");
                        break;
                    }
                    m_serverMgr = AdempiereServerMgr.get();
                    if (ClusterServerMgr.getClusterService() != null) {
                        m_serverMgr = ClusterServerMgr.getInstance();
                    }
                }
                catch (Throwable e) {
                    if (e.getCause() != null) {
                        log.log(Level.SEVERE, e.getCause().getMessage(), e.getCause());
                    } else {
                        log.log(Level.SEVERE, e.getMessage(), e);
                    }
                    ServerContext.dispose();
                }
            }
            finally {
                ServerContext.dispose();
            }
        }, (long)initialWaitSeconds, TimeUnit.SECONDS);
        m_dirAccessList = this.getDirAcessList();
    }

    private synchronized IServerManager getServerManager() {
        if (this.serverMgrFuture != null && !this.serverMgrFuture.isDone() && !this.serverMgrFuture.isCancelled()) {
            try {
                this.serverMgrFuture.get();
            }
            catch (Exception exception) {}
        }
        return m_serverMgr;
    }

    public void destroy() {
        log.info("destroy");
        if (!this.serverMgrFuture.isDone() && !this.serverMgrFuture.isCancelled()) {
            this.serverMgrFuture.cancel(true);
        }
        this.serverMgrFuture = null;
        m_serverMgr = null;
        m_dirAccessList = null;
    }

    public void log(String message, Throwable e) {
        if (e == null) {
            log.warning(message);
        }
        log.log(Level.SEVERE, message, e);
    }

    public void log(String message) {
        log.fine(message);
    }

    public String getServletName() {
        return "AdempiereMonitor";
    }

    public String getServletInfo() {
        return "iDempiere Server Monitor";
    }

    private ArrayList<File> getDirAcessList() {
        ArrayList<File> dirAccessList = new ArrayList<File>();
        CLogFile fileHandler = CLogFile.get((boolean)true, null, (boolean)false);
        File logDir = fileHandler.getLogDirectory();
        dirAccessList.add(logDir);
        String dirAccessPathName = Adempiere.getAdempiereHome() + File.separator + s_dirAccessFileName;
        File dirAccessFile = new File(dirAccessPathName);
        if (dirAccessFile.exists()) {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (BufferedReader br2 = new BufferedReader(new FileReader(dirAccessFile));){
                    String pathName;
                    while ((pathName = br2.readLine()) != null) {
                        File pathDir = new File(pathName);
                        if (!pathDir.exists() || dirAccessList.contains(pathDir)) continue;
                        dirAccessList.add(pathDir);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, dirAccessPathName + " - " + e.toString());
            }
        }
        return dirAccessList;
    }

    private static final String escapeEcmaScript(String input2) {
        input2 = input2.replace("'", "\\'");
        input2 = input2.replace("\"", "\\\"");
        input2 = input2.replace("\\", "\\\\");
        input2 = input2.replace("/", "\\/");
        input2 = input2.replace("\n", "\\n");
        input2 = input2.replace("\t", "\\t");
        return input2;
    }

    private boolean createCacheDetailsPage(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String cmd = WebUtil.getParameter((HttpServletRequest)request, (String)"CacheDetails");
        if (cmd == null || cmd.length() == 0) {
            return false;
        }
        WebDoc doc = WebDoc.create((String)"iDempiere Server Cache Details");
        body b2 = doc.getBody();
        p para = new p();
        a link = new a("idempiereMonitor", "Return");
        para.addElement((Element)link);
        b2.addElement((Element)para);
        table table2 = new table();
        table2.setBorder(1);
        table2.setCellSpacing(2);
        table2.setCellPadding(2);
        tr line = new tr();
        line.addElement((Element)new th().addElement("Name"));
        line.addElement((Element)new th().addElement("Table Name"));
        line.addElement((Element)new th().addElement("Size"));
        line.addElement((Element)new th().addElement("Expire (Minutes)"));
        line.addElement((Element)new th().addElement("Max Size"));
        line.addElement((Element)new th().addElement("Hit"));
        line.addElement((Element)new th().addElement("Miss"));
        line.addElement((Element)new th().addElement("Distributed"));
        table2.addElement((Element)line);
        List instances = CacheInfo.getCacheInfos((boolean)true);
        if (instances.size() > 0 && ((CacheInfo)instances.get(0)).getNodeId() != null) {
            line.addElement((Element)new th().addElement("Node Id"));
        }
        for (CacheInfo ccache : instances) {
            if (ccache.getName().endsWith("|CCacheListener") || ccache.getSize() <= 0) continue;
            line = new tr();
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)ccache.getName())));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)ccache.getTableName())));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((int)ccache.getSize())));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((int)ccache.getExpireMinutes())));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((int)ccache.getMaxSize())));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)ccache.getHit())));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)ccache.getMiss())));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)ccache.isDistributed())));
            if (ccache.getNodeId() != null) {
                line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)ccache.getNodeId())));
            }
            table2.addElement((Element)line);
        }
        for (CacheInfo ccache : instances) {
            if (ccache.getName().endsWith("|CCacheListener") || ccache.getSize() != 0) continue;
            line = new tr();
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)ccache.getName())));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)ccache.getTableName())));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((int)ccache.getSize())));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((int)ccache.getExpireMinutes())));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((int)ccache.getMaxSize())));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)ccache.getHit())));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)ccache.getMiss())));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)ccache.isDistributed())));
            if (ccache.getNodeId() != null) {
                line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)ccache.getNodeId())));
            }
            table2.addElement((Element)line);
        }
        b2.addElement((Element)table2);
        link = new a("#top", "Top");
        b2.addElement((Element)link);
        WebUtil.createResponse((HttpServletRequest)request, (HttpServletResponse)response, (HttpServlet)this, null, (WebDoc)doc, (boolean)false);
        return true;
    }

    public boolean processNodeInfoPage(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String nodeId = WebUtil.getParameter((HttpServletRequest)request, (String)"NodeInfo");
        if (nodeId == null || nodeId.length() == 0) {
            return false;
        }
        WebDoc doc = WebDoc.create((String)("Details for node " + nodeId));
        body b2 = doc.getBody();
        p para = new p();
        a link = new a("idempiereMonitor", "Return");
        para.addElement((Element)link);
        b2.addElement((Element)para);
        this.createNodeInfoPage(b2, nodeId);
        WebUtil.createResponse((HttpServletRequest)request, (HttpServletResponse)response, (HttpServlet)this, null, (WebDoc)doc, (boolean)false);
        return true;
    }

    private void createNodeInfoPage(body bb, String nodeId) {
        LogFileInfo[] logFiles;
        TrxInfo[] trxs;
        SystemInfo systemInfo = SystemInfo.getClusterNodeInfo(nodeId);
        if (systemInfo == null) {
            return;
        }
        bb.addElement((Element)new hr());
        table table2 = new table();
        table2.setBorder(1);
        table2.setCellSpacing(2);
        table2.setCellPadding(2);
        tr line = new tr();
        line.addElement((Element)new th().addElement("Property File"));
        line.addElement((Element)new td().addElement(systemInfo.getPropertyFileName()));
        table2.addElement((Element)line);
        line = new tr();
        InetAddress address = systemInfo.getAddress();
        line.addElement((Element)new th().addElement("Host Name"));
        line.addElement((Element)new td().addElement(address.getCanonicalHostName()));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Operating System"));
        line.addElement((Element)new td().addElement(systemInfo.getOperatingSystem()));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement(systemInfo.getJavaVM()));
        line.addElement((Element)new td().addElement("Average GC Time=" + systemInfo.getGarbageCollectionTime() / systemInfo.getGarbageCollectionCount() + " ms"));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement(systemInfo.getDatabaseDescription()));
        line.addElement((Element)new td().addElement(systemInfo.getDatabaseConnectionURL()));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("DB Connection Pool"));
        line.addElement((Element)new td().addElement(systemInfo.getDatabaseStatus()));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Processor (Average System Load)"));
        line.addElement((Element)new td().addElement(systemInfo.getAvailableProcessors() + " (" + systemInfo.getAverageSystemLoad() + ") "));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("VM Memory"));
        line.addElement((Element)new td().addElement(systemInfo.getMemoryUsage()));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Heap Memory"));
        line.addElement((Element)new td().addElement(systemInfo.getHeapMemoryUsage()));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Runtime " + systemInfo.getRuntimeName()));
        line.addElement((Element)new td().addElement(TimeUtil.formatElapsed((long)systemInfo.getRuntimeUpTime())));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Threads " + systemInfo.getThreadCount()));
        line.addElement((Element)new td().addElement("Peak=" + systemInfo.getPeakThreadCount() + ", Daemons=" + systemInfo.getDaemonThreadCount() + ", Total=" + systemInfo.getTotalStartedThreadCount()));
        table2.addElement((Element)line);
        TrxInfo[] trxInfoArray = trxs = systemInfo.getTrxInfos();
        int n = trxs.length;
        int n2 = 0;
        while (n2 < n) {
            TrxInfo trx = trxInfoArray[n2];
            line = new tr();
            line.addElement((Element)new th().addElement((trx.isActive() ? "Active" : "Inactive") + " Transaction "));
            td td2 = new td();
            if (Util.isEmpty((String)trx.getStackTrace())) {
                td2.addElement("Name=" + trx.getDisplayName() + ", StartTime=" + this.formatTimestampWithTimeZone(0, trx.getStartTime()));
                td2.setTitle(trx.getTrxName());
            } else {
                td2.setOnClick("var newwindow=window.open('','Popup', 'width=800,height=600');newwindow.document.write('<title>" + AdempiereMonitor.escapeEcmaScript(trx.getDisplayName()) + "</title><p><b>Transaction = " + trx.getDisplayName() + "</b></p><p><b>TrxName = " + trx.getTrxName() + "</b></p><pre>" + AdempiereMonitor.escapeEcmaScript(trx.getStackTrace()) + "</pre>')");
                label lbl = new label().addElement(trx.getDisplayName());
                lbl.setStyle("text-decoration: underline; color: blue");
                td2.addElement("Name=").addElement((Element)lbl).addElement(", StartTime=" + this.formatTimestampWithTimeZone(0, trx.getStartTime()));
                td2.setTitle("Click to see stack trace for " + trx.getTrxName());
            }
            line.addElement((Element)td2);
            table2.addElement((Element)line);
            ++n2;
        }
        line = new tr();
        line.addElement((Element)new th().addElement((Element)new label("TraceLevel").addElement("Trace Log Level")));
        form myForm = new form("idempiereMonitor", "post", "application/x-www-form-urlencoded");
        option[] options = new option[CLogMgt.LEVELS.length];
        int i = 0;
        while (i < options.length) {
            options[i] = new option(CLogMgt.LEVELS[i].getName());
            options[i].addElement(CLogMgt.LEVELS[i].getName());
            if (CLogMgt.LEVELS[i] == systemInfo.getLogLevel()) {
                options[i].setSelected(true);
            }
            ++i;
        }
        select sel = new select("TraceLevel", options);
        myForm.addElement((Element)sel);
        myForm.addElement((Element)new input("hidden", "nodeId", nodeId));
        myForm.addElement((Element)new input("submit", "Set", "Set"));
        line.addElement((Element)new td().addElement((Element)myForm));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Trace File"));
        line.addElement((Element)new td().addElement((Element)new a("idempiereMonitor?Trace=" + systemInfo.getCurrentLogFile() + "&nodeId=" + nodeId, "Current")));
        table2.addElement((Element)line);
        line = new tr();
        p tlp = new p();
        tlp.addElement((Element)new a("idempiereMonitor?Trace=ROTATE&nodeId=" + nodeId, "Rotate Trace Log")).addElement(" - ").addElement((Element)new a("idempiereMonitor?Trace=DELETE&nodeId=" + nodeId, "Delete all Trace Logs"));
        line.addElement((Element)new th());
        line.addElement((Element)new td().addElement((Element)tlp));
        table2.addElement((Element)line);
        bb.addElement((Element)table2);
        p p2 = new p();
        p2.addElement((Element)new b("All Log Files: "));
        LogFileInfo[] logFileInfoArray = logFiles = systemInfo.getLogFileInfos();
        int n3 = logFiles.length;
        int n4 = 0;
        while (n4 < n3) {
            LogFileInfo logFile = logFileInfoArray[n4];
            if (logFile != logFiles[0]) {
                p2.addElement(" - ");
            }
            String fileName = logFile.getFileName();
            a link = new a("idempiereMonitor?Trace=" + fileName + "&nodeId=" + nodeId, fileName);
            p2.addElement((Element)link);
            int size = (int)(logFile.getFileSize() / 1024L);
            if (size < 1024) {
                p2.addElement(" (" + size + "k)");
            } else {
                p2.addElement(" (" + size / 1024 + "M)");
            }
            ++n4;
        }
        bb.addElement((Element)p2);
        line = new tr();
        line.addElement((Element)new th().addElement("Active sessions for node"));
        line.addElement((Element)new td().addElement("" + systemInfo.getSessionCount()));
        table2.addElement((Element)line);
        bb.addElement((Element)table2);
    }
}

