/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Parameter;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MLocator;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MRole;
import org.compiere.model.MRoleOrgAccess;
import org.compiere.model.MWarehouse;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.Msg;

@Process
public class BPartnerOrgLink
extends SvrProcess {
    @Parameter
    private int p_AD_Org_ID;
    @Parameter
    private int p_AD_OrgType_ID;
    @Parameter
    private int p_AD_Role_ID;
    private int p_C_BPartner_ID;

    protected void prepare() {
        this.p_C_BPartner_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MWarehouse[] whs;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_BPartner_ID=" + this.p_C_BPartner_ID + ", AD_Org_ID=" + this.p_AD_Org_ID + ", AD_OrgType_ID=" + this.p_AD_OrgType_ID + ", AD_Role_ID=" + this.p_AD_Role_ID);
        }
        if (this.p_C_BPartner_ID == 0) {
            throw new AdempiereUserError("No Business Partner ID");
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.p_C_BPartner_ID, this.get_TrxName());
        if (bp.get_ID() == 0) {
            throw new AdempiereUserError(Msg.getMsg((Properties)this.getCtx(), (String)"BPartnerNotFound") + " - C_BPartner_ID=" + this.p_C_BPartner_ID);
        }
        MBPartnerLocation[] locs = bp.getLocations(false);
        if (locs == null || locs.length == 0) {
            throw new IllegalArgumentException(Msg.getMsg((Properties)this.getCtx(), (String)"BPartnerHasNoLocation"));
        }
        int C_Location_ID = locs[0].getC_Location_ID();
        if (C_Location_ID == 0) {
            throw new IllegalArgumentException(Msg.getMsg((Properties)this.getCtx(), (String)"BPartnerLocationHasNoAddress"));
        }
        boolean newOrg = this.p_AD_Org_ID == 0;
        MOrg org = new MOrg(this.getCtx(), this.p_AD_Org_ID, this.get_TrxName());
        if (newOrg) {
            org.setValue(bp.getValue());
            org.setName(bp.getName());
            org.setDescription(bp.getDescription());
            if (!org.save()) {
                throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"OrganizationNotSaved"));
            }
        } else {
            int C_BPartner_ID = org.getLinkedC_BPartner_ID(this.get_TrxName());
            if (C_BPartner_ID > 0) {
                MBPartner partner = new MBPartner(this.getCtx(), C_BPartner_ID, this.get_TrxName());
                throw new IllegalArgumentException(Msg.getMsg((Properties)this.getCtx(), (String)"OrganizationAlreadyLinkedBusinessPartner", (Object[])new Object[]{org.getName(), partner.getName()}));
            }
        }
        this.p_AD_Org_ID = org.getAD_Org_ID();
        MOrgInfo oInfo = org.getInfo();
        oInfo.setAD_OrgType_ID(this.p_AD_OrgType_ID);
        if (newOrg) {
            oInfo.setC_Location_ID(C_Location_ID);
        }
        MWarehouse wh = null;
        if (!newOrg && (whs = MWarehouse.getForOrg((Properties)this.getCtx(), (int)this.p_AD_Org_ID)) != null && whs.length > 0) {
            wh = whs[0];
        }
        if (wh == null && !(wh = new MWarehouse(org)).save(this.get_TrxName())) {
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"WarehouseNotSaved"));
        }
        MLocator mLoc = wh.getDefaultLocator();
        if (mLoc == null) {
            mLoc = new MLocator(wh, "Standard");
            mLoc.setIsDefault(true);
            mLoc.saveEx(this.get_TrxName());
        }
        oInfo.setM_Warehouse_ID(wh.getM_Warehouse_ID());
        if (!oInfo.save(this.get_TrxName())) {
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"OrganizationInfoNotSaved"));
        }
        bp.setAD_OrgBP_ID(this.p_AD_Org_ID);
        if (bp.getAD_Org_ID() != 0) {
            bp.setClientOrg(bp.getAD_Client_ID(), 0);
        }
        if (!bp.save()) {
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"BPartnerNotUpdated"));
        }
        if (this.p_AD_Role_ID != 0) {
            boolean found = false;
            MRoleOrgAccess[] orgAccesses = MRoleOrgAccess.getOfOrg((Properties)this.getCtx(), (int)this.p_AD_Org_ID);
            int i = 0;
            while (i < orgAccesses.length) {
                if (orgAccesses[i].getAD_Role_ID() == this.p_AD_Role_ID) {
                    found = true;
                } else {
                    orgAccesses[i].delete(true);
                }
                ++i;
            }
            if (!found) {
                MRoleOrgAccess orgAccess = new MRoleOrgAccess(org, this.p_AD_Role_ID);
                orgAccess.saveEx(this.get_TrxName());
            }
        }
        MRole.getDefault((Properties)this.getCtx(), (boolean)true);
        return Msg.getMsg((Properties)this.getCtx(), (String)"BPartnerOrganizationLinkCreated");
    }
}

