/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.webui.ISupportMask;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.DocumentLink;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.SimplePDFViewer;
import org.compiere.model.MRole;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoLog;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.tools.FileUtil;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zhtml.Text;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Image;
import org.zkoss.zul.Separator;

public class ProcessInfoDialog
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = -1712025652050086903L;
    private static final String MESSAGE_PANEL_STYLE = "text-align:left; word-break: break-all; overflow: auto; max-height: 250pt; min-width: 230pt; max-width: 450pt;";
    private Text lblMsg = new Text();
    private Button btnOk = ButtonFactory.createNamedButton("Ok");
    private Button btnPrint = ButtonFactory.createNamedButton("Print");
    private Image img = new Image();
    private ProcessInfoLog[] m_logs;
    public static final String INFORMATION = "~./zul/img/msgbox/info-btn.png";
    public static final String ERROR = "~./zul/img/msgbox/info-btn.png";
    private boolean isAutoCloseAfterZoom = false;

    @Deprecated
    public ProcessInfoDialog(String title, String header, ProcessInfoLog[] m_logs) {
        this.init(title, header, null, m_logs);
    }

    @Deprecated
    public ProcessInfoDialog(String title, String header, ProcessInfo pi, boolean needFillLogFromDb) {
        this(pi, needFillLogFromDb);
    }

    public ProcessInfoDialog(ProcessInfo pi, boolean needFillLogFromDb) {
        if (needFillLogFromDb) {
            ProcessInfoUtil.setLogFromDB((ProcessInfo)pi);
        }
        this.init(pi.getTitle(), null, pi, null);
    }

    private void init(String title, String header, ProcessInfo pi, ProcessInfoLog[] m_logs) {
        this.setTitle(title);
        this.setClosable(true);
        this.setSizable(true);
        this.setBorder("normal");
        this.setContentStyle("background-color:#ffffff;");
        this.lblMsg.setEncode(false);
        this.lblMsg.setValue(header);
        this.btnOk.addEventListener("onClick", this);
        this.btnPrint.addEventListener("onClick", this);
        Panel pnlMessage = new Panel();
        pnlMessage.setStyle(MESSAGE_PANEL_STYLE);
        pnlMessage.appendChild((Component)this.lblMsg);
        Separator sep = new Separator("horizontal");
        pnlMessage.appendChild((Component)sep);
        Hbox pnlImage = new Hbox();
        this.img.setSrc(pi != null && pi.isError() ? "~./zul/img/msgbox/info-btn.png" : "~./zul/img/msgbox/info-btn.png");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)pnlImage, "72px");
        pnlImage.setAlign("center");
        pnlImage.setPack("center");
        pnlImage.appendChild((Component)this.img);
        Hbox north = new Hbox();
        north.setAlign("center");
        north.setStyle("margin: 20pt 10pt 20pt 10pt;");
        this.appendChild((Component)north);
        north.appendChild((Component)pnlImage);
        pnlMessage.appendChild((Component)new Text(Msg.getMsg((Properties)Env.getCtx(), (String)(pi.isError() ? "Error" : "Success"))));
        pnlMessage.appendChild((Component)new Separator("horizontal"));
        north.appendChild((Component)pnlMessage);
        Hbox pnlButtons = new Hbox();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)pnlButtons, "52px");
        pnlButtons.setAlign("center");
        pnlButtons.setPack("end");
        this.btnPrint.setVisible(false);
        pnlButtons.appendChild((Component)this.btnPrint);
        pnlButtons.appendChild((Component)this.btnOk);
        Separator separator = new Separator();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)separator, "100%");
        separator.setBar(true);
        this.appendChild((Component)separator);
        Hbox south = new Hbox();
        south.setPack("end");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)south, "100%");
        this.appendChild((Component)south);
        south.appendChild((Component)pnlButtons);
        if (pi != null) {
            m_logs = pi.getLogs();
            String summary = pi.getSummary();
            if (summary != null && summary.indexOf(64) != -1) {
                summary = Msg.parseTranslation((Properties)Env.getCtx(), (String)summary);
            }
            if (summary != null && summary.trim().length() > 0 && !summary.trim().equalsIgnoreCase("Report")) {
                pnlMessage.appendChild((Component)new Text(summary));
            }
        }
        this.m_logs = m_logs;
        if (this.isPrintable()) {
            this.btnPrint.setVisible(true);
        }
        if (m_logs != null && m_logs.length > 0) {
            separator = new Separator();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)separator, "100%");
            separator.setBar(true);
            pnlMessage.appendChild((Component)separator);
            int loopCtr = 0;
            while (loopCtr < m_logs.length) {
                ProcessInfoLog log = m_logs[loopCtr];
                if (log.getP_Msg() != null || log.getP_Date() != null || log.getP_Number() != null) {
                    SimpleDateFormat dateFormat = DisplayType.getDateFormat((int)16);
                    StringBuffer sb = new StringBuffer();
                    if (log.getP_Date() != null) {
                        sb.append(dateFormat.format(log.getP_Date())).append(" \t");
                    }
                    if (log.getP_Number() != null) {
                        sb.append(log.getP_Number()).append(" \t");
                    }
                    if (log.getP_Msg() != null) {
                        sb.append(Msg.parseTranslation((Properties)Env.getCtx(), (String)log.getP_Msg()));
                    }
                    if (log.getAD_Table_ID() > 0 && log.getRecord_ID() > 0) {
                        DocumentLink recordLink = new DocumentLink(sb.toString(), log.getAD_Table_ID(), log.getRecord_ID());
                        recordLink.addEventListener("onClick", e -> {
                            if (this.isAutoCloseAfterZoom()) {
                                this.detach();
                            }
                        });
                        pnlMessage.appendChild((Component)recordLink);
                    } else {
                        Text recordText = new Text(sb.toString());
                        pnlMessage.appendChild((Component)recordText);
                    }
                    pnlMessage.appendChild((Component)new Separator("horizontal"));
                }
                ++loopCtr;
            }
        }
    }

    public void onEvent(Event event) throws Exception {
        if (event == null) {
            return;
        }
        if (event.getTarget() == this.btnOk) {
            this.detach();
        }
        if (event.getTarget() == this.btnPrint) {
            Clients.showBusy((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Processing"));
            Executions.schedule((Desktop)this.getDesktop(), e -> this.onPrint(), (Event)new Event("onPrint"));
        }
    }

    private void onPrint() {
        Clients.clearBusy();
        ArrayList<File> pdfList = new ArrayList<File>();
        int i = 0;
        while (i < this.m_logs.length) {
            int recordID = this.m_logs[i].getRecord_ID();
            int reportEngineType = ReportEngine.getReportEngineType((int)this.m_logs[i].getAD_Table_ID());
            ReportEngine re = null;
            if (reportEngineType >= 0 && recordID > 0) {
                re = ReportEngine.get((Properties)Env.getCtx(), (int)reportEngineType, (int)recordID);
                pdfList.add(re.getPDF());
            }
            ++i;
        }
        if (pdfList.size() > 1) {
            try {
                File outFile = FileUtil.createTempFile((String)this.getTitle(), (String)".pdf");
                AEnv.mergePdf(pdfList, outFile);
                SimplePDFViewer win = new SimplePDFViewer(this.getTitle(), new FileInputStream(outFile));
                SessionManager.getAppDesktop().showWindow(win, "center");
            }
            catch (Exception e) {
                throw new RuntimeException(e.getLocalizedMessage(), e);
            }
        }
        if (pdfList.size() > 0) {
            try {
                SimplePDFViewer win = new SimplePDFViewer(this.getTitle(), new FileInputStream((File)pdfList.get(0)));
                SessionManager.getAppDesktop().showWindow(win, "center");
            }
            catch (Exception e) {
                throw new RuntimeException(e.getLocalizedMessage(), e);
            }
        }
        this.detach();
    }

    public boolean isPrintable() {
        if (this.m_logs == null) {
            return false;
        }
        ProcessInfoLog[] processInfoLogArray = this.m_logs;
        int n = this.m_logs.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoLog log = processInfoLogArray[n2];
            if (log.getAD_Table_ID() > 0 && log.getRecord_ID() > 0 && ReportEngine.getReportEngineType((int)log.getAD_Table_ID()) >= 0 && MRole.getDefault().isCanReport(log.getAD_Table_ID())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void focus() {
        this.btnOk.focus();
    }

    public void setAutoCloseAfterZoom(boolean autoClose) {
        this.isAutoCloseAfterZoom = autoClose;
    }

    public boolean isAutoCloseAfterZoom() {
        return this.isAutoCloseAfterZoom;
    }

    public static ProcessInfoDialog showProcessInfo(ProcessInfo pi, int windowNo, Component comp, boolean needFillLogFromDb) {
        ProcessInfoDialog dialog = new ProcessInfoDialog(pi, needFillLogFromDb);
        final ISupportMask supportMask = LayoutUtils.showWindowWithMask((org.zkoss.zul.Window)dialog, comp, 3);
        dialog.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                supportMask.hideMask();
            }
        });
        Executions.schedule((Desktop)comp.getDesktop(), e -> processInfoDialog.btnOk.focus(), (Event)new Event("onPostShowProcessInfoDialog"));
        return dialog;
    }
}

