/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MSysConfig;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.impl.Utils;

public class SimplePDFViewer
extends Window {
    private static final long serialVersionUID = -6417954023873414350L;
    private AMedia media;
    private int mediaVersion = 0;

    public SimplePDFViewer(String title, InputStream pdfInput) {
        Iframe iframe = new Iframe();
        iframe.setId("reportFrame");
        int height = 0;
        height = ClientInfo.maxHeight(430) ? ClientInfo.get().desktopHeight : Double.valueOf((double)ClientInfo.get().desktopHeight * 0.85).intValue();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this, height + "px");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)iframe, (height -= 30) + "px");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)iframe, "100%");
        if (title != null && title.trim().length() > 0) {
            this.setTitle(title);
        } else {
            this.setTitle(Msg.translate((Properties)Env.getCtx(), (String)"PDF"));
        }
        this.media = new AMedia(this.getTitle(), "pdf", "application/pdf", pdfInput);
        if (ClientInfo.isMobile() || MSysConfig.getBooleanValue((String)"ZK_USE_PDF_JS_VIEWER", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()))) {
            if (this.getPage() != null) {
                this.showMobileViewer(iframe);
            } else {
                this.addCallback("afterPageAttached", (Callback & Serializable)t -> this.showMobileViewer(iframe));
            }
        } else {
            iframe.setContent((Media)this.media);
        }
        this.setBorder("normal");
        this.appendChild((Component)iframe);
        this.setClosable(true);
        this.setMaximizable(true);
        int width = 0;
        width = ClientInfo.maxWidth(699) ? ClientInfo.get().desktopWidth : Double.valueOf((double)ClientInfo.get().desktopWidth * 0.8).intValue();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this, width + "px");
    }

    protected void showMobileViewer(Iframe iframe) {
        ++this.mediaVersion;
        String url = Utils.getDynamicMediaURI((AbstractComponent)this, (int)this.mediaVersion, (String)this.media.getName(), (String)this.media.getFormat());
        String pdfJsUrl = AEnv.toPdfJsUrl(url);
        iframe.setSrc(pdfJsUrl);
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)SimplePDFViewer.this);
        }

        public Media getMedia(String pathInfo) {
            return SimplePDFViewer.this.media;
        }
    }
}

