/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.ElementHandler;
import org.adempiere.pipo2.IHandlerRegistry;
import org.adempiere.pipo2.OSGiHandlerRegistry;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackIn;
import org.adempiere.pipo2.exception.DatabaseAccessException;
import org.compiere.model.MColumn;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Package_Imp;
import org.compiere.model.X_AD_Package_Imp_Inst;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class PackInHandler
extends DefaultHandler {
    private boolean m_updateDictionary = false;
    private String packageDirectory = null;
    private int AD_Package_Imp_ID = 0;
    private int AD_Package_Imp_Inst_ID = 0;
    private static final CLogger log = CLogger.getCLogger(PackInHandler.class);
    private boolean isInit = false;
    private String packageStatus = "Installing";
    private PIPOContext m_ctx = null;
    private IHandlerRegistry handlerRegistry = null;
    private List<DeferEntry> defer = new ArrayList<DeferEntry>();
    private List<Integer> deferFK = new ArrayList<Integer>();
    private Stack<Element> stack = new Stack();
    private PackIn packIn;
    private int elementProcessed = 0;
    private boolean isUpdateRoleAccess = false;

    public PackInHandler() {
        this.setupHandlers();
    }

    private void init() throws SAXException {
        this.packageDirectory = this.packIn.getPackageDirectory();
        this.m_updateDictionary = this.packIn.isUpdateDictionary();
        if (this.m_ctx == null) {
            this.m_ctx = new PIPOContext();
        }
        if (this.m_ctx.trx == null) {
            this.m_ctx.trx = Trx.get((String)"PackIn", (boolean)true);
        }
        this.isInit = true;
    }

    private void setupHandlers() {
        this.handlerRegistry = new OSGiHandlerRegistry();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (!this.isInit) {
            this.init();
        }
        if (qName.equals("idempiere")) {
            String packageVersion;
            String clientAttribute;
            String[] clientComponent;
            int clientId;
            String updateDictionary = atts.getValue("UpdateDictionary");
            if (updateDictionary != null && updateDictionary.equalsIgnoreCase("true")) {
                this.m_updateDictionary = true;
            }
            if (log.isLoggable(Level.INFO)) {
                log.info("idempiere updateMode=" + this.m_updateDictionary);
            }
            if ((clientId = Integer.parseInt((clientComponent = (clientAttribute = atts.getValue("Client")).split("[-]"))[0])) == 0 && Env.getAD_Client_ID((Properties)this.m_ctx.ctx) > 0) {
                throw new RuntimeException("Package is created for System, not Tenant");
            }
            if (clientId > 0 && Env.getAD_Client_ID((Properties)this.m_ctx.ctx) == 0) {
                throw new RuntimeException("Package is created for Tenant, not System");
            }
            int PK_preInstalled = 0;
            String packageName = this.packIn.getPackageName();
            if (packageName == null || packageName.trim().length() == 0) {
                packageName = atts.getValue("Name");
            }
            if ((packageVersion = this.packIn.getPackageVersion()) == null || packageVersion.trim().length() == 0) {
                packageVersion = atts.getValue("Version");
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)"SELECT AD_PACKAGE_IMP_INST_ID FROM AD_PACKAGE_IMP_INST WHERE NAME =? AND PK_VERSION =?", null);
                    pstmt.setString(1, packageName);
                    pstmt.setString(2, packageVersion);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        PK_preInstalled = rs.getInt(1);
                    }
                }
                catch (Exception e) {
                    throw new DatabaseAccessException(e);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            X_AD_Package_Imp packageImp = new X_AD_Package_Imp(this.m_ctx.ctx, 0, null);
            packageImp.setAD_Org_ID(Env.getAD_Org_ID((Properties)this.m_ctx.ctx));
            packageImp.setReleaseNo(atts.getValue("CompVer"));
            packageImp.setPK_Version(packageVersion);
            packageImp.setVersion(atts.getValue("DataBase"));
            packageImp.setDescription(atts.getValue("Description").replace("'", "''"));
            packageImp.setName(packageName);
            packageImp.setCreator(atts.getValue("Creator"));
            packageImp.setCreatorContact(atts.getValue("CreatorContact"));
            packageImp.setPK_Status(this.packageStatus);
            packageImp.setAD_Package_Imp_Proc_ID(this.packIn.getAD_Package_Imp_Proc().getAD_Package_Imp_Proc_ID());
            packageImp.saveEx();
            this.AD_Package_Imp_ID = packageImp.getAD_Package_Imp_ID();
            if (PK_preInstalled <= 0) {
                X_AD_Package_Imp_Inst packageInst = new X_AD_Package_Imp_Inst(this.m_ctx.ctx, 0, null);
                packageInst.setAD_Org_ID(Env.getAD_Org_ID((Properties)this.m_ctx.ctx));
                packageInst.setReleaseNo(atts.getValue("CompVer"));
                packageInst.setPK_Version(atts.getValue("Version"));
                packageInst.setVersion(atts.getValue("DataBase"));
                packageInst.setDescription(atts.getValue("Description").replace("'", "''"));
                packageInst.setName(atts.getValue("Name"));
                packageInst.setCreator(atts.getValue("Creator"));
                packageInst.setCreatorContact(atts.getValue("CreatorContact"));
                packageInst.setPK_Status(this.packageStatus);
                packageInst.saveEx();
                this.AD_Package_Imp_Inst_ID = packageInst.get_ID();
            } else {
                this.AD_Package_Imp_Inst_ID = PK_preInstalled;
                X_AD_Package_Imp_Inst packageInst = new X_AD_Package_Imp_Inst(this.m_ctx.ctx, this.AD_Package_Imp_Inst_ID, null);
                packageInst.setPK_Status(this.packageStatus);
                packageInst.saveEx();
            }
            Env.setContext((Properties)this.m_ctx.ctx, (String)"AD_Package_Imp_ID", (String)String.valueOf(this.AD_Package_Imp_ID));
            Env.setContext((Properties)this.m_ctx.ctx, (String)"UpdateMode", (boolean)this.m_updateDictionary);
            Env.setContext((Properties)this.m_ctx.ctx, (String)"PackageDirectory", (String)this.packageDirectory);
            this.m_ctx.packIn = this.packIn;
        } else {
            Element e = new Element(uri, localName, qName, new AttributesImpl(atts));
            if (this.stack.size() > 0) {
                e.parent = this.stack.peek();
                String reference = atts.getValue("type");
                if (reference == null || reference.equals("properties")) {
                    e.parent.properties.put(qName, e);
                } else {
                    e.parent.childrens.add(e);
                }
            }
            this.stack.push(e);
        }
    }

    private void processElement(Element element) throws SAXException {
        ElementHandler handler = this.handlerRegistry.getHandler(element);
        if (handler != null) {
            handler.startElement(this.m_ctx, element);
        }
        if (element.defer) {
            this.defer.add(new DeferEntry(element, true));
        }
        if (element.deferFKColumnID > 0 && !this.deferFK.contains(element.deferFKColumnID)) {
            this.deferFK.add(element.deferFKColumnID);
        }
        if (element.requireRoleAccessUpdate) {
            this.isUpdateRoleAccess = true;
        }
        for (Element childElement : element.childrens) {
            this.processElement(childElement);
        }
        if (element.defer) {
            this.defer.add(new DeferEntry(element, false));
        } else {
            if (handler != null) {
                handler.endElement(this.m_ctx, element);
            }
            if (element.defer || element.deferEnd) {
                this.defer.add(new DeferEntry(element, false));
            } else if (!element.skip) {
                if (log.isLoggable(Level.INFO)) {
                    log.info("Processed: " + element.getElementValue() + " - " + element.attributes.getValue(0));
                }
                ++this.elementProcessed;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.stack.size() > 0 && length > 0) {
            Element e = this.stack.peek();
            e.contents.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Object elementValue = null;
        elementValue = "".equals(uri) ? qName : uri + localName;
        if (((String)elementValue).equals("idempiere")) {
            this.processDeferElements();
            this.processDeferFKElements();
            this.updateRoleAccess();
            if (this.getUnresolvedCount() > 0) {
                this.packageStatus = "Completed - unresolved";
            } else {
                this.packageStatus = "Completed successfully";
                this.packIn.setSuccess(true);
            }
            this.packIn.getNotifier().addStatusLine(this.packageStatus);
            this.updPackageImp(this.m_ctx.trx.getTrxName());
            this.updPackageImpInst(this.m_ctx.trx.getTrxName());
            this.setupHandlers();
        } else {
            Element e = this.stack.pop();
            if (this.stack.isEmpty()) {
                try {
                    this.processElement(e);
                }
                catch (RuntimeException re) {
                    this.packageStatus = "Import Failed";
                    this.packIn.getNotifier().addStatusLine(this.packageStatus);
                    this.updPackageImp(null);
                    throw re;
                }
                catch (SAXException se) {
                    this.packageStatus = "Import Failed";
                    this.packIn.getNotifier().addStatusLine(this.packageStatus);
                    this.updPackageImp(null);
                    throw se;
                }
            }
        }
    }

    private void updPackageImp(String trxName) {
        DB.executeUpdateEx((String)"UPDATE AD_Package_Imp SET Processed=?, PK_Status=?, UpdatedBy=?, Updated=getDate() WHERE AD_Package_Imp_ID=?", (Object[])new Object[]{"Y", this.packageStatus, Env.getAD_User_ID((Properties)this.m_ctx.ctx), this.AD_Package_Imp_ID}, (String)trxName);
    }

    private void updPackageImpInst(String trxName) {
        DB.executeUpdateEx((String)"UPDATE AD_Package_Imp_Inst SET PK_Status=?, UpdatedBy=?, Updated=getDate() WHERE AD_Package_Imp_Inst_ID=?", (Object[])new Object[]{this.packageStatus, Env.getAD_User_ID((Properties)this.m_ctx.ctx), this.AD_Package_Imp_Inst_ID}, (String)trxName);
    }

    private void processDeferElements() throws SAXException {
        int endSize;
        int startSize;
        if (this.defer.isEmpty()) {
            return;
        }
        do {
            startSize = this.defer.size();
            ArrayList<DeferEntry> tmp = new ArrayList<DeferEntry>(this.defer);
            this.defer.clear();
            for (DeferEntry d : tmp) {
                ElementHandler handler;
                if (d.startElement) {
                    d.element.defer = false;
                    d.element.unresolved = "";
                    ++d.element.pass;
                } else if (d.element.deferEnd) {
                    d.element.deferEnd = false;
                    d.element.unresolved = "";
                }
                if (log.isLoggable(Level.INFO)) {
                    log.info("Processing Element: " + d.element.getElementValue() + " - " + d.element.attributes.getValue(0));
                }
                if ((handler = this.handlerRegistry.getHandler(d.element)) != null) {
                    if (d.startElement) {
                        handler.startElement(this.m_ctx, d.element);
                    } else {
                        handler.endElement(this.m_ctx, d.element);
                    }
                }
                if (d.element.defer) {
                    this.defer.add(d);
                    continue;
                }
                if (d.startElement) continue;
                if (d.element.deferEnd) {
                    this.defer.add(d);
                    continue;
                }
                if (log.isLoggable(Level.INFO)) {
                    log.info("Imported Defer Element: " + d.element.getElementValue() + " - " + d.element.attributes.getValue(0));
                }
                ++this.elementProcessed;
            }
        } while (startSize != (endSize = this.defer.size()) && this.defer.size() > 0);
    }

    private void processDeferFKElements() throws SAXException {
        if (this.deferFK.isEmpty()) {
            return;
        }
        for (int columnID : this.deferFK) {
            MColumn column = new MColumn(this.m_ctx.ctx, columnID, this.m_ctx.trx.getTrxName());
            try {
                String tableName;
                Object fkConstraintSql;
                Connection conn = this.m_ctx.trx.getConnection();
                DatabaseMetaData md = conn.getMetaData();
                String catalog = DB.getDatabase().getCatalog();
                String schema = DB.getDatabase().getSchema();
                MTable table = MTable.get((Properties)this.m_ctx.ctx, (int)column.getAD_Table_ID(), (String)this.m_ctx.trx.getTrxName());
                if (table.get_ID() != column.getAD_Table_ID()) {
                    log.warning("Table " + column.getAD_Table_ID() + " not found");
                    continue;
                }
                if (table.isView() || Util.isEmpty((String)(fkConstraintSql = MColumn.getForeignKeyConstraintSql((DatabaseMetaData)md, (String)catalog, (String)schema, (String)(tableName = table.getTableName()), (MTable)table, (MColumn)column, (boolean)false)))) continue;
                if (((String)fkConstraintSql).toLowerCase().contains(" ad_sequence(ad_sequence_id)")) {
                    fkConstraintSql = (String)fkConstraintSql + "; COMMIT";
                }
                if (((String)fkConstraintSql).indexOf("; ") == -1) {
                    DB.executeUpdate((String)fkConstraintSql, (boolean)false, (String)this.m_ctx.trx.getTrxName());
                    continue;
                }
                String[] statements = ((String)fkConstraintSql).split("; ");
                int i = 0;
                while (i < statements.length) {
                    if (!Util.isEmpty((String)statements[i], (boolean)true)) {
                        DB.executeUpdateEx((String)statements[i], (String)this.m_ctx.trx.getTrxName());
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new AdempiereException((Throwable)e);
            }
        }
    }

    public void setCtx(PIPOContext ctx) {
        this.m_ctx = ctx;
    }

    public void setProcess(PackIn packIn) {
        this.packIn = packIn;
    }

    public int getElementsProcessed() {
        return this.elementProcessed;
    }

    public int getUnresolvedCount() {
        int count = 0;
        if (this.defer != null && !this.defer.isEmpty()) {
            for (DeferEntry entry : this.defer) {
                if (entry.startElement) continue;
                ++count;
            }
        }
        return count;
    }

    public void dumpUnresolvedElements() {
        if (this.defer != null && !this.defer.isEmpty()) {
            for (DeferEntry entry : this.defer) {
                if (entry.startElement) continue;
                Element e = entry.element;
                if (e.unresolved == null || e.unresolved.length() == 0) continue;
                StringBuilder s = new StringBuilder(e.qName);
                s.append(" [");
                Set<String> keys = e.properties.keySet();
                int i = 0;
                for (String key : keys) {
                    Element value = e.properties.get(key);
                    if (i > 0) {
                        s.append(", ");
                    }
                    s.append(key).append("=");
                    if (value.contents != null) {
                        s.append(value.contents);
                    }
                    ++i;
                }
                s.append("]");
                s.append(" unresolved ").append(e.unresolved);
                log.warning(s.toString());
                this.packIn.getNotifier().addFailureLine(s.toString());
            }
        }
    }

    private void updateRoleAccess() {
        if (!this.isUpdateRoleAccess) {
            return;
        }
        int AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
        List roles = new Query(this.m_ctx.ctx, "AD_Role", "IsManual='N' AND (?=0 OR AD_Client_ID=?)", this.m_ctx.trx.getTrxName()).setOnlyActiveRecords(true).setOrderBy("AD_Client_ID, Name").setParameters(new Object[]{AD_Client_ID, AD_Client_ID}).list();
        for (MRole role : roles) {
            role.updateAccessRecords(false);
        }
    }

    static class DeferEntry {
        Element element;
        boolean startElement = false;

        DeferEntry(Element e, boolean b) {
            this.element = e;
            this.startElement = b;
        }
    }
}

