/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.sql.Timestamp;
import org.compiere.util.DB;

public class FinReportPeriod {
    private int m_C_Period_ID;
    private String m_Name;
    private Timestamp m_StartDate;
    private Timestamp m_EndDate;
    private Timestamp m_YearStartDate;

    public FinReportPeriod(int C_Period_ID, String Name2, Timestamp StartDate, Timestamp EndDate, Timestamp YearStartDate) {
        this.m_C_Period_ID = C_Period_ID;
        this.m_Name = Name2;
        this.m_StartDate = StartDate;
        this.m_EndDate = EndDate;
        this.m_YearStartDate = YearStartDate;
    }

    public String getPeriodWhere() {
        StringBuilder sql = new StringBuilder("BETWEEN ");
        sql.append(DB.TO_DATE(this.m_StartDate)).append(" AND ").append(DB.TO_DATE(this.m_EndDate));
        return sql.toString();
    }

    public String getYearWhere() {
        StringBuilder sql = new StringBuilder("BETWEEN ");
        sql.append(DB.TO_DATE(this.m_YearStartDate)).append(" AND ").append(DB.TO_DATE(this.m_EndDate));
        return sql.toString();
    }

    public String getTotalWhere() {
        StringBuilder sql = new StringBuilder("<= ");
        sql.append(DB.TO_DATE(this.m_EndDate));
        return sql.toString();
    }

    public boolean inPeriod(Timestamp date) {
        if (date == null) {
            return false;
        }
        if (date.before(this.m_StartDate)) {
            return false;
        }
        return !date.after(this.m_EndDate);
    }

    public String getName() {
        return this.m_Name;
    }

    public int getC_Period_ID() {
        return this.m_C_Period_ID;
    }

    public Timestamp getEndDate() {
        return this.m_EndDate;
    }

    public Timestamp getStartDate() {
        return this.m_StartDate;
    }

    public Timestamp getYearStartDate() {
        return this.m_YearStartDate;
    }

    public String getNaturalWhere(String alias) {
        String yearWhere = this.getYearWhere();
        String totalWhere = this.getTotalWhere();
        String bs = " EXISTS (SELECT C_ElementValue_ID FROM C_ElementValue WHERE C_ElementValue_ID = " + alias + ".Account_ID AND AccountType NOT IN ('R', 'E'))";
        String full = totalWhere + " AND ( " + bs + " OR TRUNC(" + alias + ".DateAcct) " + yearWhere + " ) ";
        return full;
    }
}

