/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.ds;

import org.adempiere.base.BaseActivator;
import org.adempiere.base.IServiceHolder;
import org.adempiere.base.IServiceLocator;
import org.adempiere.base.IServicesHolder;
import org.adempiere.base.ServiceQuery;
import org.adempiere.base.ds.DynamicServiceHolder;
import org.adempiere.exceptions.AdempiereException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class DynamicServiceLocator
implements IServiceLocator {
    @Override
    public <T> IServiceHolder<T> locate(Class<T> type) {
        Filter filter = this.filter(type, null, null);
        ServiceTracker<T, T> tracker = BaseActivator.getServiceTracker(type, filter);
        return new DynamicServiceHolder<T>(tracker);
    }

    @Override
    public <T> IServiceHolder<T> locate(Class<T> type, ServiceQuery query) {
        if (query == null || query.isEmpty()) {
            return this.locate(type);
        }
        Filter filter = this.filter(type, null, query);
        ServiceTracker<T, T> tracker = BaseActivator.getServiceTracker(type, filter);
        return new DynamicServiceHolder<T>(tracker);
    }

    @Override
    public <T> IServiceHolder<T> locate(Class<T> type, String serviceId, ServiceQuery query) {
        if (!(query != null && !query.isEmpty() || serviceId != null && serviceId.trim().length() != 0)) {
            return this.locate(type);
        }
        Filter filter = this.filter(type, serviceId, query);
        ServiceTracker<T, T> tracker = BaseActivator.getServiceTracker(type, filter);
        return new DynamicServiceHolder<T>(tracker);
    }

    @Override
    public <T> IServicesHolder<T> list(Class<T> type) {
        Filter filter = this.filter(type, null, null);
        ServiceTracker<T, T> tracker = BaseActivator.getServiceTracker(type, filter);
        return new DynamicServiceHolder<T>(tracker);
    }

    @Override
    public <T> IServicesHolder<T> list(Class<T> type, ServiceQuery query) {
        if (query == null || query.isEmpty()) {
            return this.list(type);
        }
        Filter filter = this.filter(type, null, query);
        ServiceTracker<T, T> tracker = BaseActivator.getServiceTracker(type, filter);
        return new DynamicServiceHolder<T>(tracker);
    }

    @Override
    public <T> IServicesHolder<T> list(Class<T> type, String serviceId, ServiceQuery query) {
        if (!(query != null && !query.isEmpty() || serviceId != null && serviceId.trim().length() != 0)) {
            return this.list(type);
        }
        Filter filter = this.filter(type, serviceId, query);
        ServiceTracker<T, T> tracker = BaseActivator.getServiceTracker(type, filter);
        return new DynamicServiceHolder<T>(tracker);
    }

    private Filter filter(Class<?> type, String serviceId, ServiceQuery query) {
        StringBuilder builder = new StringBuilder("(&(objectclass=");
        builder.append(type.getName()).append(")");
        if (query != null) {
            for (String key : query.keySet()) {
                String value = (String)query.get(key);
                builder.append("(").append(key).append("=").append(value).append(")");
            }
        }
        if (serviceId != null && serviceId.trim().length() > 0) {
            builder.append("(").append("component.name").append("=").append(serviceId.trim()).append(")");
        }
        builder.append(")");
        try {
            return BaseActivator.getBundleContext().createFilter(builder.toString());
        }
        catch (InvalidSyntaxException e) {
            throw new AdempiereException(e.getMessage(), e);
        }
    }
}

