/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import org.adempiere.base.ICreditManager;
import org.adempiere.base.ICreditManagerFactory;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.PO;
import org.compiere.model.credit.CreditManagerInOut;
import org.compiere.model.credit.CreditManagerInvoice;
import org.compiere.model.credit.CreditManagerOrder;
import org.compiere.model.credit.CreditManagerPayment;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={ICreditManagerFactory.class})
public class DefaultCreditManagerFactory
implements ICreditManagerFactory {
    @Override
    public ICreditManager getCreditManager(PO po) {
        if (po instanceof MOrder) {
            return new CreditManagerOrder((MOrder)po);
        }
        if (po instanceof MInvoice) {
            return new CreditManagerInvoice((MInvoice)po);
        }
        if (po instanceof MPayment) {
            return new CreditManagerPayment((MPayment)po);
        }
        if (po instanceof MInOut) {
            return new CreditManagerInOut((MInOut)po);
        }
        return null;
    }
}

