/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.compiere.model.MAccount;

public record FactAcct(MAccount account, BigDecimal accountedAmount, BigDecimal sourceAmount, int rounding, boolean debit, int lineId, BigDecimal qty) {
    public FactAcct(MAccount account, BigDecimal accountedAmount, BigDecimal sourceAmount, int rounding, boolean debit, int lineId) {
        this(account, accountedAmount, sourceAmount, rounding, debit, lineId, null);
    }

    public FactAcct(MAccount account, BigDecimal accountedAmount, BigDecimal sourceAmount, int rounding, boolean debit, BigDecimal qty) {
        this(account, accountedAmount, sourceAmount, rounding, debit, 0, qty);
    }

    public FactAcct(MAccount account, BigDecimal accountedAmount, int rounding, boolean debit, BigDecimal qty) {
        this(account, accountedAmount, null, rounding, debit, 0, qty);
    }

    public FactAcct(MAccount account, BigDecimal accountedAmount, int rounding, boolean debit) {
        this(account, accountedAmount, null, rounding, debit, 0);
    }

    public FactAcct(MAccount account, BigDecimal accountedAmount, BigDecimal sourceAmount, int rounding, boolean debit) {
        this(account, accountedAmount, sourceAmount, rounding, debit, 0);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("Account=").append(this.account.getAccount_ID()).append(" | ").append(this.account.getAccount());
        builder.append(", ").append(this.debit ? "Dr" : "Cr").append("[");
        if (this.accountedAmount != null) {
            builder.append("Accounted=").append(this.accountedAmount.setScale(this.rounding, RoundingMode.HALF_UP).toPlainString());
        }
        if (this.sourceAmount != null) {
            if (this.accountedAmount != null) {
                builder.append(", ");
            }
            builder.append("Source=").append(this.sourceAmount.setScale(this.rounding, RoundingMode.HALF_UP).toPlainString());
        }
        builder.append("]");
        if (this.lineId > 0) {
            builder.append(", LineId=").append(this.lineId);
        }
        if (this.qty != null) {
            builder.append(", Qty=").append(this.qty.setScale(this.rounding, RoundingMode.HALF_UP).toPlainString());
        }
        return builder.toString();
    }
}

