/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.adempiere.base.IServiceReferenceHolder;
import org.adempiere.base.Service;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.factory.IEditorFactory;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.util.CCache;
import org.osgi.framework.ServiceReference;

public class WebEditorFactory {
    private static final CCache<Integer, ConcurrentHashMap<Long, IServiceReferenceHolder<IEditorFactory>>> s_editorFactoryCache = new CCache(null, "IEditorFactory", 10, 0, false, 0);
    private static final Set<Integer> s_rankings = new ConcurrentSkipListSet(Comparator.reverseOrder());

    public static WEditor getEditor(GridField gridField, boolean tableEditor) {
        return WebEditorFactory.getEditor(gridField, tableEditor, null);
    }

    public static WEditor getEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        return WebEditorFactory.getEditor(gridField.getGridTab(), gridField, tableEditor, editorConfiguration);
    }

    public static WEditor getEditor(GridTab gridTab, GridField gridField, boolean tableEditor) {
        return WebEditorFactory.getEditor(gridTab, gridField, tableEditor, null);
    }

    public static WEditor getEditor(GridTab gridTab, GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        ArrayList<Long> visitedIds = new ArrayList<Long>();
        if (!s_editorFactoryCache.isEmpty()) {
            for (Integer ranking : s_rankings) {
                Long[] keys;
                ConcurrentHashMap serviceIdMap = (ConcurrentHashMap)s_editorFactoryCache.get((Object)ranking);
                if (serviceIdMap == null) continue;
                Long[] longArray = keys = ((ConcurrentHashMap.CollectionView)((Object)serviceIdMap.keySet())).toArray(new Long[0]);
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    Long key = longArray[n2];
                    IServiceReferenceHolder serviceReference = (IServiceReferenceHolder)serviceIdMap.get(key);
                    if (serviceReference != null) {
                        IEditorFactory service = (IEditorFactory)serviceReference.getService();
                        if (service != null) {
                            visitedIds.add(key);
                            WEditor editor = service.getEditor(gridTab, gridField, tableEditor, editorConfiguration);
                            if (editor != null) {
                                return editor;
                            }
                        } else {
                            serviceIdMap.remove(key);
                        }
                    }
                    ++n2;
                }
            }
        }
        WEditor editor = null;
        List serviceReferences = Service.locator().list(IEditorFactory.class).getServiceReferences();
        for (IServiceReferenceHolder serviceReference : serviceReferences) {
            ConcurrentHashMap<Long, IServiceReferenceHolder> serviceIdMap;
            IEditorFactory service;
            ServiceReference reference = serviceReference.getServiceReference();
            Long serviceId = (Long)reference.getProperty("service.id");
            if (visitedIds.contains(serviceId) || (service = (IEditorFactory)serviceReference.getService()) == null) continue;
            Integer ranking = (Integer)reference.getProperty("service.ranking");
            if (ranking == null) {
                ranking = 0;
            }
            if (!s_rankings.contains(ranking)) {
                s_rankings.add(ranking);
            }
            if ((serviceIdMap = (ConcurrentHashMap<Long, IServiceReferenceHolder>)s_editorFactoryCache.get((Object)ranking)) == null) {
                serviceIdMap = new ConcurrentHashMap<Long, IServiceReferenceHolder>();
                s_editorFactoryCache.put((Object)ranking, serviceIdMap);
            }
            serviceIdMap.put(serviceId, serviceReference);
            editor = service.getEditor(gridTab, gridField, tableEditor, editorConfiguration);
            if (editor != null) break;
        }
        return editor;
    }
}

