/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.compiere.util.CLogger;

public final class MultiMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = -947723044316916542L;
    private ArrayList<K> m_keys = null;
    private ArrayList<V> m_values = null;

    public MultiMap() {
        this(10);
    }

    public MultiMap(int initialCapacity) {
        this.m_keys = new ArrayList(initialCapacity);
        this.m_values = new ArrayList(initialCapacity);
    }

    @Override
    public int size() {
        return this.m_keys.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_keys.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m_keys.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.m_values.contains(value);
    }

    @Override
    public V get(Object key) {
        return (V)this.getValues(key);
    }

    public ArrayList<V> getValues(Object key) {
        ArrayList<V> list = new ArrayList<V>();
        if (!this.m_keys.contains(key)) {
            return list;
        }
        int size = this.m_keys.size();
        int i = 0;
        while (i < size) {
            if (this.m_keys.get(i).equals(key) && !list.contains(this.m_values.get(i))) {
                list.add(this.m_values.get(i));
            }
            ++i;
        }
        return list;
    }

    public ArrayList<K> getKeys(Object value) {
        ArrayList<K> list = new ArrayList<K>();
        if (!this.m_values.contains(value)) {
            return list;
        }
        int size = this.m_values.size();
        int i = 0;
        while (i < size) {
            if (this.m_values.get(i).equals(value) && !list.contains(this.m_keys.get(i))) {
                list.add(this.m_keys.get(i));
            }
            ++i;
        }
        return list;
    }

    @Override
    public V put(K key, V value) {
        this.m_keys.add(key);
        this.m_values.add(value);
        return null;
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("Method remove() not implemented.");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        throw new UnsupportedOperationException("Method putAll() not implemented.");
    }

    @Override
    public void clear() {
        this.m_keys.clear();
        this.m_values.clear();
    }

    @Override
    public Set<K> keySet() {
        HashSet<K> keys = new HashSet<K>(this.m_keys);
        return keys;
    }

    @Override
    public Collection<V> values() {
        return this.m_values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException("Method entrySet() not implemented.");
    }

    @Override
    public boolean equals(Object o) {
        throw new UnsupportedOperationException("Method equals() not implemented.");
    }

    @Override
    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public String toString() {
        return "MultiMap #" + this.m_keys.size();
    }

    public void printToLog() {
        CLogger log = CLogger.getCLogger(this.getClass());
        log.fine("MultiMap.printToLog");
        int size = this.m_keys.size();
        int i = 0;
        while (i < size) {
            K k = this.m_keys.get(i);
            V v = this.m_values.get(i);
            if (log.isLoggable(Level.FINEST)) {
                log.finest(k == null ? "null" : (k.toString() + "=" + String.valueOf(v) == null ? "null" : v.toString()));
            }
            ++i;
        }
    }
}

