/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.tablepartition.callout;

import java.util.Properties;
import org.adempiere.base.IColumnCallout;
import org.adempiere.base.annotation.Callout;
import org.compiere.db.partition.RangePartitionInterval;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MColumn;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

@Callout(tableName={"AD_Column"}, columnName={"IsPartitionKey", "RangePartitionInterval"})
public class ColumnCallout
implements IColumnCallout {
    public String start(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        if ("IsPartitionKey".equals(mField.getColumnName())) {
            if (Boolean.TRUE.equals(value)) {
                Object seqNo = mTab.getValue("SeqNoPartition");
                if (seqNo == null || ((Number)seqNo).intValue() == 0) {
                    String sql = "SELECT COALESCE(MAX(SeqNoPartition),0)+10 AS DefaultValue FROM AD_Column WHERE AD_Table_ID=? AND IsActive='Y' AND IsPartitionKey='Y'";
                    int ii = DB.getSQLValue(null, (String)sql, (Object[])new Object[]{mTab.getValue("AD_Table_ID")});
                    mTab.setValue("SeqNoPartition", (Object)ii);
                }
            } else {
                Object seqNo = mTab.getValue("SeqNoPartition");
                if (seqNo != null) {
                    mTab.setValue("SeqNoPartition", null);
                }
            }
        } else if ("RangePartitionInterval".equals(mField.getColumnName()) && value != null) {
            MColumn column = MColumn.getCopy((Properties)Env.getCtx(), (int)mTab.getRecord_ID(), null);
            column.setRangePartitionInterval(value.toString());
            String error = RangePartitionInterval.validateIntervalPattern((MColumn)column);
            if (!Util.isEmpty((String)error, (boolean)true)) {
                return error;
            }
        }
        return null;
    }
}

