/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.io.Serializables;
import org.zkoss.zul.ChartModel;
import org.zkoss.zul.event.ChartDataEvent;
import org.zkoss.zul.event.ChartDataListener;

public abstract class AbstractChartModel
implements ChartModel,
Serializable {
    private static final long serialVersionUID = 20091007120455L;
    protected List<ChartDataListener> _listeners = new LinkedList<ChartDataListener>();

    protected void fireEvent(int type, Comparable<?> series, Object data) {
        this.fireEvent(type, series, null, -1, -1, data);
    }

    protected void fireEvent(int type, Comparable<?> series, Comparable<?> category, int seriesIndex, int categoryIndex, Object data) {
        ChartDataEvent evt = new ChartDataEvent(this, type, series, category, seriesIndex, categoryIndex, data);
        for (ChartDataListener l : this._listeners) {
            l.onChange(evt);
        }
    }

    @Override
    public void addChartDataListener(ChartDataListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this._listeners.add(l);
    }

    @Override
    public void removeChartDataListener(ChartDataListener l) {
        this._listeners.remove(l);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Serializables.smartWrite((ObjectOutputStream)s, this._listeners);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._listeners = new LinkedList<ChartDataListener>();
        Serializables.smartRead((ObjectInputStream)s, this._listeners);
    }

    public Object clone() {
        AbstractChartModel clone;
        try {
            clone = (AbstractChartModel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone._listeners = new LinkedList<ChartDataListener>();
        return clone;
    }
}

