/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Objects;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.ListModelMap;
import org.zkoss.zul.ListSubModel;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.ext.SelectionControl;

public class ListModels {
    public static final Comparator STRING_COMPARATOR = new Comparator(){

        public int compare(Object key, Object value) {
            String idx = Objects.toString((Object)key);
            return idx != null && value != null && idx.length() > 0 && Objects.toString((Object)value).startsWith(idx) ? 0 : 1;
        }
    };
    public static final Comparator MAP_COMPARATOR = new Comparator(){

        public int compare(Object key, Object value) {
            String idx = Objects.toString((Object)key);
            return idx != null && value != null && idx.length() > 0 && Objects.toString(((Map.Entry)value).getValue()).startsWith(idx) ? 0 : 1;
        }
    };

    private ListModels() {
    }

    public static <T> ListModel<T> toListSubModel(ListModel<T> model, Comparator<T> comparator, int nRows) {
        return new SubModel(model, comparator, nRows);
    }

    public static <T> ListModel<T> toListSubModel(ListModel<T> model) {
        return new SubModel(model, model instanceof ListModelMap ? MAP_COMPARATOR : STRING_COMPARATOR, 15);
    }

    private static class SubModel<E>
    implements ListModel<E>,
    ListSubModel<E>,
    Selectable<E>,
    Serializable {
        private final ListModel<E> _model;
        private final Comparator<E> _comparator;
        private final int _nRows;

        @Override
        public void setSelectionControl(SelectionControl ctrl) {
            if (this._model instanceof Selectable) {
                ((Selectable)((Object)this._model)).setSelectionControl(ctrl);
            }
        }

        @Override
        public SelectionControl getSelectionControl() {
            if (this._model instanceof Selectable) {
                return ((Selectable)((Object)this._model)).getSelectionControl();
            }
            return null;
        }

        private SubModel(ListModel<E> model, Comparator<E> comparator, int nRows) {
            this._model = model;
            this._comparator = comparator;
            this._nRows = nRows;
        }

        @Override
        public ListModel<E> getSubModel(Object value, int nRows) {
            LinkedList<E> data = new LinkedList<E>();
            LinkedHashSet<E> selection = new LinkedHashSet<E>();
            nRows = nRows < 0 ? this._nRows : nRows;
            int j = this._model.getSize();
            for (int i = 0; i < j; ++i) {
                E o = this._model.getElementAt(i);
                if (this._comparator.compare(value, o) != 0) continue;
                data.add(o);
                if (this._model instanceof Selectable && ((Selectable)((Object)this._model)).isSelected(o)) {
                    selection.add(o);
                }
                if (--nRows <= 0) break;
            }
            ListModelList<E> subm = new ListModelList<E>(data, true);
            subm.setMultiple(((Selectable)((Object)this._model)).isMultiple());
            subm.setSelection(selection);
            return subm;
        }

        @Override
        public E getElementAt(int index) {
            return this._model.getElementAt(index);
        }

        @Override
        public int getSize() {
            return this._model.getSize();
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this._model.addListDataListener(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this._model.removeListDataListener(l);
        }

        private Selectable<E> getSelectModel() {
            return (Selectable)((Object)this._model);
        }

        @Override
        public Set<E> getSelection() {
            return this.getSelectModel().getSelection();
        }

        @Override
        public void setSelection(Collection<? extends E> selection) {
            this.getSelectModel().setSelection(selection);
        }

        @Override
        public boolean isSelected(Object obj) {
            return this.getSelectModel().isSelected(obj);
        }

        @Override
        public boolean isSelectionEmpty() {
            return this.getSelectModel().isSelectionEmpty();
        }

        @Override
        public boolean addToSelection(E obj) {
            return this.getSelectModel().addToSelection(obj);
        }

        @Override
        public boolean removeFromSelection(Object obj) {
            return this.getSelectModel().removeFromSelection(obj);
        }

        @Override
        public void clearSelection() {
            this.getSelectModel().clearSelection();
        }

        @Override
        public void setMultiple(boolean multiple) {
            this.getSelectModel().setMultiple(multiple);
        }

        @Override
        public boolean isMultiple() {
            return this.getSelectModel().isMultiple();
        }
    }
}

