/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.sys;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.json.JSONAware;
import org.zkoss.json.JSONs;
import org.zkoss.lang.Generics;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.ContentRenderer;

public class JSCumulativeContentRenderer
implements ContentRenderer {
    private Map<String, List<Object>> _stack = new LinkedHashMap<String, List<Object>>();

    private List<Object> fetch(String name) {
        List<Object> list = this._stack.get(name);
        if (list == null) {
            list = new LinkedList<Object>();
            this._stack.put(name, list);
        }
        return list;
    }

    @Override
    public void render(String name, String value) throws IOException {
        this.fetch(name).add(this.renderValue(value));
    }

    @Override
    public void render(String name, Date value) throws IOException {
        this.fetch(name).add(this.renderValue(value));
    }

    @Override
    public void render(String name, Object value) throws IOException {
        this.fetch(name).add(this.renderValue(value));
    }

    @Override
    public void render(String name, int value) throws IOException {
        this.fetch(name).add(this.renderValue(value));
    }

    @Override
    public void render(String name, short value) throws IOException {
        this.fetch(name).add(this.renderValue(value));
    }

    @Override
    public void render(String name, long value) throws IOException {
        this.fetch(name).add(this.renderValue(value));
    }

    @Override
    public void render(String name, byte value) throws IOException {
        this.fetch(name).add(this.renderValue(value));
    }

    @Override
    public void render(String name, boolean value) throws IOException {
        this.fetch(name).add(this.renderValue(value));
    }

    @Override
    public void render(String name, double value) throws IOException {
        this.fetch(name).add(this.renderValue(value));
    }

    @Override
    public void render(String name, float value) throws IOException {
        this.fetch(name).add(this.renderValue(Float.valueOf(value)));
    }

    @Override
    public void render(String name, char value) throws IOException {
        this.fetch(name).add(this.renderValue(value));
    }

    private String renderValue(String value) {
        if (value == null) {
            return null;
        }
        return Strings.escapeJavaScript((String)value);
    }

    private String renderValue(Date value) {
        if (value == null) {
            return null;
        }
        return "jq.j2d('" + JSONs.d2j((Date)value) + "')";
    }

    private String renderValue(Component value) {
        if (value == null || value.getPage() == null) {
            return null;
        }
        return "{$u:'" + value.getUuid() + "'}";
    }

    private String renderValue(Object value) {
        if (value == null || value instanceof String) {
            return this.renderValue((String)value);
        }
        if (value instanceof Date) {
            return this.renderValue((Date)value);
        }
        if (value instanceof Component) {
            return this.renderValue((Component)value);
        }
        if (value instanceof Character) {
            return this.renderValue(((Character)value).charValue());
        }
        StringBuilder buf = new StringBuilder();
        if (value instanceof Map) {
            buf.append('{');
            boolean first = true;
            for (Map.Entry me : ((Map)value).entrySet()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append('\'').append(me.getKey()).append("':");
                this.renderValue(me.getValue());
            }
            buf.append('}');
            return buf.toString();
        }
        if (value instanceof List) {
            buf.append('[');
            int j = 0;
            Iterator it = ((List)value).iterator();
            while (it.hasNext()) {
                if (j > 0) {
                    buf.append(',');
                }
                this.renderValue(it.next());
                ++j;
            }
            buf.append(']');
            return buf.toString();
        }
        if (value instanceof Object[]) {
            buf.append('[');
            Object[] ary = (Object[])value;
            for (int j = 0; j < ary.length; ++j) {
                if (j > 0) {
                    buf.append(',');
                }
                this.renderValue(ary[j]);
            }
            buf.append(']');
            return buf.toString();
        }
        if (value instanceof int[]) {
            buf.append('[');
            int[] ary = (int[])value;
            for (int j = 0; j < ary.length; ++j) {
                if (j > 0) {
                    buf.append(',');
                }
                this.renderValue(ary[j]);
            }
            buf.append(']');
            return buf.toString();
        }
        if (value instanceof long[]) {
            buf.append('[');
            long[] ary = (long[])value;
            for (int j = 0; j < ary.length; ++j) {
                if (j > 0) {
                    buf.append(',');
                }
                this.renderValue(ary[j]);
            }
            buf.append(']');
            return buf.toString();
        }
        if (value instanceof short[]) {
            buf.append('[');
            short[] ary = (short[])value;
            for (int j = 0; j < ary.length; ++j) {
                if (j > 0) {
                    buf.append(',');
                }
                this.renderValue(ary[j]);
            }
            buf.append(']');
            return buf.toString();
        }
        if (value instanceof float[]) {
            buf.append('[');
            float[] ary = (float[])value;
            for (int j = 0; j < ary.length; ++j) {
                if (j > 0) {
                    buf.append(',');
                }
                this.renderValue(Float.valueOf(ary[j]));
            }
            buf.append(']');
            return buf.toString();
        }
        if (value instanceof double[]) {
            buf.append('[');
            double[] ary = (double[])value;
            for (int j = 0; j < ary.length; ++j) {
                if (j > 0) {
                    buf.append(',');
                }
                this.renderValue(ary[j]);
            }
            buf.append(']');
            return buf.toString();
        }
        if (value instanceof byte[]) {
            buf.append('[');
            byte[] ary = (byte[])value;
            for (int j = 0; j < ary.length; ++j) {
                if (j > 0) {
                    buf.append(',');
                }
                this.renderValue(ary[j]);
            }
            buf.append(']');
            return buf.toString();
        }
        if (value instanceof char[]) {
            buf.append('[');
            char[] ary = (char[])value;
            for (int j = 0; j < ary.length; ++j) {
                if (j > 0) {
                    buf.append(',');
                }
                this.renderValue(ary[j]);
            }
            buf.append(']');
            return buf.toString();
        }
        if (value instanceof JSONAware) {
            return ((JSONAware)value).toJSONString();
        }
        return this.renderValue(value.toString());
    }

    private String renderValue(char value) {
        StringBuilder buf = new StringBuilder();
        buf.append('\'');
        switch (value) {
            case '\'': 
            case '\\': {
                buf.append('\\');
                break;
            }
            case '\n': {
                buf.append('\\');
                value = (char)110;
                break;
            }
            case '\t': {
                buf.append('\\');
                value = (char)116;
                break;
            }
            case '\r': {
                buf.append('\\');
                value = (char)114;
                break;
            }
            case '\f': {
                buf.append('\\');
                value = (char)102;
            }
        }
        buf.append(value).append('\'');
        return buf.toString();
    }

    @Override
    public void renderDirectly(String name, Object value) {
        this.fetch(name).add(this.renderValue(value));
    }

    @Override
    public void renderWidgetListeners(Map<String, String> listeners) {
        this.fetch("listeners0").add(listeners);
    }

    @Override
    public void renderWidgetOverrides(Map<String, String> overrides) {
        this.fetch("overrides").add(overrides);
    }

    @Override
    public void renderWidgetAttributes(Map<String, String> attrs) {
        this.renderClientAttributes(attrs);
    }

    @Override
    public void renderClientAttributes(Map<String, String> attrs) {
        this.fetch("domExtraAttrs").add(attrs);
    }

    public String toString() {
        Iterator it;
        StringBuilder sb = new StringBuilder(64);
        LinkedHashMap<String, List<Object>> result = new LinkedHashMap<String, List<Object>>(this._stack);
        List listeners = Generics.cast((List)((List)result.remove("listeners0")));
        List overrides = Generics.cast((List)((List)result.remove("overrides")));
        List attrs = Generics.cast((List)((List)result.remove("domExtraAttrs")));
        for (Map.Entry me : result.entrySet()) {
            this.renderName(sb, (String)me.getKey());
            sb.append('[');
            List value = (List)me.getValue();
            int j = 0;
            Iterator it2 = value.iterator();
            while (it2.hasNext()) {
                if (j > 0) {
                    sb.append(',');
                }
                sb.append(it2.next());
                ++j;
            }
            sb.append(']');
        }
        if (listeners != null) {
            this.renderName(sb, "listeners0");
            sb.append('[');
            int j = 0;
            it = listeners.iterator();
            while (it.hasNext()) {
                if (j > 0) {
                    sb.append(',');
                }
                sb.append('{');
                for (Map.Entry me : ((Map)it.next()).entrySet()) {
                    sb.append(me.getKey()).append(":function(event){\n").append(me.getValue()).append("\n},");
                }
                sb.setCharAt(sb.length() - 1, '}');
                ++j;
            }
            sb.append(']');
        }
        if (overrides != null) {
            this.renderName(sb, "overrides");
            sb.append('[');
            int j = 0;
            it = overrides.iterator();
            while (it.hasNext()) {
                if (j > 0) {
                    sb.append(',');
                }
                sb.append('{');
                for (Map.Entry me : ((Map)it.next()).entrySet()) {
                    char cc;
                    String v;
                    String name = (String)me.getKey();
                    String value = (String)me.getValue();
                    if (value != null && (v = value.trim()).length() != 0 && ((cc = v.charAt(v.length() - 1)) == ';' || cc == ',' || v.indexOf("function") < 0 && v.indexOf(59) >= 0)) {
                        throw new UiException("Illegal client override: " + v + (name.startsWith("on") ? "\nTo listen an event, remember to captalize the third letter, such as onClick" : "\nIt must be a legal JavaScript expression (not statement)"));
                    }
                    sb.append(name).append(":\n").append(value.length() == 0 ? "''" : value).append("\n,");
                }
                sb.setCharAt(sb.length() - 1, '}');
                ++j;
            }
            sb.append(']');
        }
        if (attrs != null) {
            this.renderName(sb, "domExtraAttrs");
            sb.append('[');
            int j = 0;
            it = listeners.iterator();
            while (it.hasNext()) {
                if (j > 0) {
                    sb.append(',');
                }
                sb.append('{');
                for (Map.Entry me : ((Map)it.next()).entrySet()) {
                    this.renderValue(me.getKey());
                    sb.append(':');
                    this.renderValue(me.getValue());
                    sb.append("\n,");
                }
                sb.setCharAt(sb.length() - 1, '}');
                ++j;
            }
            sb.append(']');
        }
        return sb.toString();
    }

    private void renderName(StringBuilder sb, String name) {
        if (sb.length() > 0) {
            sb.append(',');
        }
        sb.append(name).append(':');
    }
}

