/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import net.sf.jasperreports.engine.DatasetRunHolder;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.XmlLoaderReportContext;
import org.apache.commons.digester.Rule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public class DatasetRunReportContextRule<T extends DatasetRunHolder>
extends Rule {
    private static final Log log = LogFactory.getLog(DatasetRunReportContextRule.class);
    public static final String EXCEPTION_MESSAGE_KEY_CANNOT_LOCATE_STACK_OBJECT = "xml.digester.stack.cannot.locate.object";
    private Class<T> type;

    public DatasetRunReportContextRule(Class<T> type) {
        this.type = type;
    }

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        String datasetName;
        JRXmlLoader xmlLoader = this.getXmlLoader();
        T datasetRunHolder = this.findOnDigesterStack();
        JRDatasetRun datasetRun = datasetRunHolder.getDatasetRun();
        String string = datasetName = datasetRun == null ? null : datasetRun.getDatasetName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Pushing report context for dataset name " + datasetName));
        }
        XmlLoaderReportContext reportContext = new XmlLoaderReportContext(datasetName);
        xmlLoader.pushReportContext(reportContext);
    }

    public void end(String namespace, String name) throws Exception {
        JRXmlLoader xmlLoader = this.getXmlLoader();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Popping report context");
        }
        xmlLoader.popReportContext();
    }

    protected JRXmlLoader getXmlLoader() {
        return (JRXmlLoader)this.digester.peek(this.digester.getCount() - 1);
    }

    protected T findOnDigesterStack() {
        DatasetRunHolder element = null;
        int stackCount = this.digester.getCount();
        for (int idx = 0; idx < stackCount; ++idx) {
            Object stackObject = this.digester.peek(idx);
            if (!this.type.isInstance(stackObject)) continue;
            element = (DatasetRunHolder)stackObject;
            break;
        }
        if (element == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CANNOT_LOCATE_STACK_OBJECT, this.type.getName());
        }
        return (T)element;
    }
}

