/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel;

import java.util.Arrays;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STDataValidationOperator;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STDataValidationType;
import org.zkoss.poi.ss.usermodel.DataValidationConstraint;
import org.zkoss.poi.xssf.usermodel.XSSFDataValidation;

public class XSSFDataValidationConstraint
implements DataValidationConstraint {
    private String formula1;
    private String formula2;
    private int validationType = -1;
    private int operator = -1;
    private String[] explicitListOfValues;

    public XSSFDataValidationConstraint(String[] explicitListOfValues) {
        if (explicitListOfValues == null || explicitListOfValues.length == 0) {
            throw new IllegalArgumentException("List validation with explicit values must specify at least one value");
        }
        this.validationType = 3;
        this.setExplicitListValues(explicitListOfValues);
        this.validate();
    }

    public XSSFDataValidationConstraint(int validationType, String formula1) {
        this.setFormula1(formula1);
        this.validationType = validationType;
        this.validate();
    }

    public XSSFDataValidationConstraint(int validationType, int operator, String formula1) {
        this.setFormula1(formula1);
        this.validationType = validationType;
        this.operator = operator;
        this.validate();
    }

    public XSSFDataValidationConstraint(int validationType, int operator, String formula1, String formula2) {
        this.setFormula1(formula1);
        this.setFormula2(formula2);
        this.validationType = validationType;
        this.operator = operator;
        this.validate();
        if (3 == validationType && formula1.startsWith("\"")) {
            this.explicitListOfValues = formula1.substring(1, formula1.length() - 1).split(",");
        }
    }

    @Override
    public String[] getExplicitListValues() {
        return this.explicitListOfValues;
    }

    @Override
    public String getFormula1() {
        return this.formula1;
    }

    @Override
    public String getFormula2() {
        return this.formula2;
    }

    @Override
    public int getOperator() {
        return this.operator;
    }

    @Override
    public int getValidationType() {
        return this.validationType;
    }

    @Override
    public void setExplicitListValues(String[] explicitListValues) {
        this.explicitListOfValues = explicitListValues;
        if (this.explicitListOfValues != null && this.explicitListOfValues.length > 0) {
            StringBuilder builder = new StringBuilder("\"");
            for (int i = 0; i < explicitListValues.length; ++i) {
                String string = explicitListValues[i];
                if (builder.length() > 1) {
                    builder.append(",");
                }
                builder.append(string);
            }
            builder.append("\"");
            this.setFormula1(builder.toString());
        }
    }

    @Override
    public void setFormula1(String formula1) {
        this.formula1 = this.removeLeadingEquals(formula1);
    }

    protected String removeLeadingEquals(String formula1) {
        return this.isFormulaEmpty(formula1) ? formula1 : (formula1.charAt(0) == '=' ? formula1.substring(1) : formula1);
    }

    @Override
    public void setFormula2(String formula2) {
        this.formula2 = this.removeLeadingEquals(formula2);
    }

    @Override
    public void setOperator(int operator) {
        this.operator = operator;
    }

    public void validate() {
        if (this.validationType == 0) {
            return;
        }
        if (this.validationType == 3) {
            if (this.isFormulaEmpty(this.formula1)) {
                throw new IllegalArgumentException("A valid formula or a list of values must be specified for list validation.");
            }
        } else {
            if (this.isFormulaEmpty(this.formula1)) {
                throw new IllegalArgumentException("Formula is not specified. Formula is required for all validation types except explicit list validation.");
            }
            if (this.validationType != 7) {
                if (this.operator == -1) {
                    throw new IllegalArgumentException("This validation type requires an operator to be specified.");
                }
                if ((this.operator == 0 || this.operator == 1) && this.isFormulaEmpty(this.formula2)) {
                    throw new IllegalArgumentException("Between and not between comparisons require two formulae to be specified.");
                }
            }
        }
    }

    protected boolean isFormulaEmpty(String formula1) {
        return formula1 == null || formula1.trim().length() == 0;
    }

    public String prettyPrint() {
        StringBuilder builder = new StringBuilder();
        STDataValidationType.Enum vt = XSSFDataValidation.validationTypeMappings.get(this.validationType);
        STDataValidationOperator.Enum ot = XSSFDataValidation.operatorTypeMappings.get(this.operator);
        builder.append(vt);
        builder.append(' ');
        if (this.validationType != 0) {
            if (this.validationType != 3 && this.validationType != 0 && this.validationType != 7) {
                builder.append(",").append(ot).append(", ");
            }
            String QUOTE = "";
            if (this.validationType == 3 && this.explicitListOfValues != null) {
                builder.append("").append(Arrays.asList(this.explicitListOfValues)).append("").append(' ');
            } else {
                builder.append("").append(this.formula1).append("").append(' ');
            }
            if (this.formula2 != null) {
                builder.append("").append(this.formula2).append("").append(' ');
            }
        }
        return builder.toString();
    }

    public int hashCode() {
        return (this.formula1 == null ? 0 : this.formula1.hashCode()) ^ (this.formula2 == null ? 0 : this.formula2.hashCode()) ^ this.validationType ^ this.operator ^ (this.explicitListOfValues == null ? 0 : this.explicitListOfValues.hashCode());
    }

    public boolean equals(Object other) {
        if (!(other instanceof XSSFDataValidationConstraint)) {
            return false;
        }
        XSSFDataValidationConstraint o = (XSSFDataValidationConstraint)other;
        return this.objEquals(this.formula1, o.formula1) && this.objEquals(this.formula2, o.formula2) && this.validationType == o.validationType && this.operator == o.operator && this.objEquals(this.explicitListOfValues, o.explicitListOfValues);
    }

    private boolean objEquals(Object s1, Object s2) {
        return s1 == s2 || s1 != null && s1.equals(s2) || s2 != null && s2.equals(s1);
    }

    public boolean isExplicitList() {
        return this.validationType == 3 && this.formula1.startsWith("\"");
    }

    public boolean isRefRange() {
        return this.validationType == 3 && this.formula1.startsWith("$");
    }

    public String getRefRange() {
        if (this.isRefRange()) {
            return this.formula1;
        }
        return null;
    }
}

