/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.ua;

import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.SheetOperationUtil;
import io.keikai.api.model.Book;
import io.keikai.api.model.Sheet;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.impl.ua.AbstractSheetHandler;
import org.zkoss.lang.Strings;
import org.zkoss.util.resource.Labels;

public class RenameSheetHandler
extends AbstractSheetHandler {
    private static final long serialVersionUID = -8419691290554319060L;

    @Override
    protected boolean processAction(UserActionContext ctx) {
        Book book = ctx.getBook();
        Sheet sheet = ctx.getSheet();
        String newname = (String)ctx.getData("name");
        if (sheet.getSheetName().equals(newname)) {
            return true;
        }
        if (!this.isLeaglSheetName(newname)) {
            this.showWarnMessage(Labels.getLabel((String)"zss.actionhandler.msg.illegal_sheet_name", (Object[])new Object[]{newname}));
            return true;
        }
        if (book.getSheet(newname) != null) {
            this.showWarnMessage(Labels.getLabel((String)"zss.actionhandler.msg.duplicated_sheet_name"));
            return true;
        }
        Range range = Ranges.range(sheet);
        SheetOperationUtil.renameSheet(range, newname);
        return true;
    }

    protected boolean isLeaglSheetName(String newname) {
        if (Strings.isEmpty((String)newname)) {
            return false;
        }
        if (newname.length() > 31) {
            return false;
        }
        String regx = ".*[\\\\\\/\\?\\*\\[\\]]+.*";
        return !newname.matches(regx);
    }
}

