/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record.chart;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.StandardRecord;
import org.zkoss.poi.util.BitField;
import org.zkoss.poi.util.BitFieldFactory;
import org.zkoss.poi.util.HexDump;
import org.zkoss.poi.util.LittleEndianOutput;

public final class LineRecord
extends StandardRecord {
    public static final short sid = 4120;
    private short field_1_formatFlags;
    private static final BitField stacked = BitFieldFactory.getInstance(1);
    private static final BitField percent = BitFieldFactory.getInstance(2);
    private static final BitField shadow = BitFieldFactory.getInstance(4);

    public LineRecord() {
    }

    public LineRecord(RecordInputStream in) {
        this.field_1_formatFlags = in.readShort();
    }

    @Override
    protected int getDataSize() {
        return 2;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[LINE]\n");
        buffer.append("    .formatFlags    = ").append("0x").append(HexDump.toHex(this.field_1_formatFlags)).append(" (").append(this.field_1_formatFlags).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .stacked                  = ").append(this.isStacked()).append('\n');
        buffer.append("         .percent                  = ").append(this.isPercent()).append('\n');
        buffer.append("         .shadow                   = ").append(this.isShadow()).append('\n');
        buffer.append("[/LINE]\n");
        return buffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.field_1_formatFlags);
    }

    @Override
    public short getSid() {
        return 4120;
    }

    @Override
    public Object clone() {
        LineRecord rec = new LineRecord();
        rec.field_1_formatFlags = this.field_1_formatFlags;
        return rec;
    }

    public short getFormatFlags() {
        return this.field_1_formatFlags;
    }

    public void setFormatFlags(short field_3_formatFlags) {
        this.field_1_formatFlags = field_3_formatFlags;
    }

    public void setPercent(boolean value) {
        this.field_1_formatFlags = percent.setShortBoolean(this.field_1_formatFlags, value);
    }

    public boolean isPercent() {
        return percent.isSet(this.field_1_formatFlags);
    }

    public void setStacked(boolean value) {
        this.field_1_formatFlags = stacked.setShortBoolean(this.field_1_formatFlags, value);
    }

    public boolean isStacked() {
        return stacked.isSet(this.field_1_formatFlags);
    }

    public void setShadow(boolean value) {
        this.field_1_formatFlags = shadow.setShortBoolean(this.field_1_formatFlags, value);
    }

    public boolean isShadow() {
        return shadow.isSet(this.field_1_formatFlags);
    }
}

