/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.nio;

import com.hazelcast.internal.tpcengine.iobuffer.IOBuffer;
import java.nio.ByteBuffer;
import java.util.Queue;

public final class IOVector {
    private static final int IOV_MAX = 1024;
    private final ByteBuffer[] array = new ByteBuffer[1024];
    private final IOBuffer[] bufs = new IOBuffer[1024];
    private int length;
    private long pending;

    public boolean isEmpty() {
        return this.length == 0;
    }

    public int length() {
        return this.length;
    }

    public ByteBuffer[] array() {
        return this.array;
    }

    public void populate(Queue<IOBuffer> queue) {
        IOBuffer buf;
        int count = 1024 - this.length;
        for (int k = 0; k < count && (buf = queue.poll()) != null; ++k) {
            ByteBuffer buffer;
            this.array[this.length] = buffer = buf.byteBuffer();
            this.bufs[this.length] = buf;
            ++this.length;
            this.pending += (long)buffer.remaining();
        }
    }

    public boolean offer(IOBuffer buf) {
        ByteBuffer buffer;
        if (this.length == 1024) {
            return false;
        }
        this.array[this.length] = buffer = buf.byteBuffer();
        this.bufs[this.length] = buf;
        ++this.length;
        this.pending += (long)buffer.remaining();
        return true;
    }

    public void compact(long written) {
        if (written == this.pending) {
            for (int k = 0; k < this.length; ++k) {
                this.array[k] = null;
                this.bufs[k].release();
                this.bufs[k] = null;
            }
            this.length = 0;
            this.pending = 0L;
        } else {
            int toIndex = 0;
            int length0 = this.length;
            for (int k = 0; k < length0; ++k) {
                if (this.array[k].hasRemaining()) {
                    if (k == 0) break;
                    this.array[toIndex] = this.array[k];
                    this.array[k] = null;
                    this.bufs[toIndex] = this.bufs[k];
                    this.bufs[k] = null;
                    ++toIndex;
                    continue;
                }
                --this.length;
                this.array[k] = null;
                this.bufs[k].release();
                this.bufs[k] = null;
            }
            this.pending -= written;
        }
    }
}

