/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class MapCodec {
    private MapCodec() {
    }

    public static <K, V> void encode(ClientMessage clientMessage, Map<K, V> map, BiConsumer<ClientMessage, K> encodeKeyFunc, BiConsumer<ClientMessage, V> encodeValueFunc) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            encodeKeyFunc.accept(clientMessage, entry.getKey());
            encodeValueFunc.accept(clientMessage, entry.getValue());
        }
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static <K, V> void encodeNullable(ClientMessage clientMessage, Map<K, V> map, BiConsumer<ClientMessage, K> encodeKeyFunc, BiConsumer<ClientMessage, V> encodeValueFunc) {
        if (map == null) {
            clientMessage.add(ClientMessage.NULL_FRAME.copy());
        } else {
            MapCodec.encode(clientMessage, map, encodeKeyFunc, encodeValueFunc);
        }
    }

    public static <K, V> Map<K, V> decode(ClientMessage.ForwardFrameIterator iterator, Function<ClientMessage.ForwardFrameIterator, K> decodeKeyFunc, Function<ClientMessage.ForwardFrameIterator, V> decodeValueFunc) {
        HashMap<K, V> result = new HashMap<K, V>();
        iterator.next();
        while (!CodecUtil.nextFrameIsDataStructureEndFrame(iterator)) {
            K key = decodeKeyFunc.apply(iterator);
            V value = decodeValueFunc.apply(iterator);
            result.put(key, value);
        }
        iterator.next();
        return result;
    }

    public static <K, V> Map<K, V> decodeNullable(ClientMessage.ForwardFrameIterator iterator, Function<ClientMessage.ForwardFrameIterator, K> decodeKeyFunc, Function<ClientMessage.ForwardFrameIterator, V> decodeValueFunc) {
        return CodecUtil.nextFrameIsNullEndFrame(iterator) ? null : MapCodec.decode(iterator, decodeKeyFunc, decodeValueFunc);
    }
}

