/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.config.CompactSerializationConfig;
import com.hazelcast.config.CompactSerializationConfigAccessor;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.nio.BufferObjectDataOutput;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.serialization.impl.AbstractSerializationService;
import com.hazelcast.internal.serialization.impl.FieldOperations;
import com.hazelcast.internal.serialization.impl.InternalGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.CompactGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.CompactInternalGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.CompactSerializableRegistration;
import com.hazelcast.internal.serialization.impl.compact.CompactStreamSerializerAdapter;
import com.hazelcast.internal.serialization.impl.compact.DefaultCompactReader;
import com.hazelcast.internal.serialization.impl.compact.DefaultCompactWriter;
import com.hazelcast.internal.serialization.impl.compact.DeserializedSchemaBoundGenericRecordBuilder;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.ReflectiveCompactSerializer;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.serialization.impl.compact.SchemaService;
import com.hazelcast.internal.serialization.impl.compact.SchemaWriter;
import com.hazelcast.internal.serialization.impl.compact.record.JavaRecordSerializer;
import com.hazelcast.internal.util.TriTuple;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.StreamSerializer;
import com.hazelcast.nio.serialization.compact.CompactSerializer;
import com.hazelcast.nio.serialization.genericrecord.GenericRecord;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public class CompactStreamSerializer
implements StreamSerializer<Object> {
    private final Map<Class, CompactSerializableRegistration> classToRegistrationMap = new ConcurrentHashMap<Class, CompactSerializableRegistration>();
    private final Map<String, CompactSerializableRegistration> typeNameToRegistrationMap = new ConcurrentHashMap<String, CompactSerializableRegistration>();
    private final Map<Class, Schema> classToSchemaMap = new ConcurrentHashMap<Class, Schema>();
    private final ReflectiveCompactSerializer reflectiveSerializer = new ReflectiveCompactSerializer(this);
    private final JavaRecordSerializer javaRecordSerializer = new JavaRecordSerializer(this);
    private final SchemaService schemaService;
    private final ManagedContext managedContext;
    private final ClassLoader classLoader;
    private final AbstractSerializationService serializationService;

    public CompactStreamSerializer(AbstractSerializationService serializationService, CompactSerializationConfig compactSerializationConfig, ManagedContext managedContext, SchemaService schemaService, ClassLoader classLoader) {
        this.serializationService = serializationService;
        this.managedContext = managedContext;
        this.schemaService = schemaService;
        this.classLoader = classLoader;
        this.registerSerializers(compactSerializationConfig);
        this.registerDeclarativeConfigSerializers(compactSerializationConfig);
        this.registerDeclarativeConfigClasses(compactSerializationConfig);
    }

    public boolean isRegisteredAsCompact(Class clazz) {
        return this.classToRegistrationMap.containsKey(clazz);
    }

    public Collection<Class> getCompactSerializableClasses() {
        return this.classToRegistrationMap.keySet();
    }

    public boolean canBeSerializedAsCompact(Class<?> clazz) {
        return this.serializationService.serializerForClass(clazz, false) instanceof CompactStreamSerializerAdapter;
    }

    @Override
    public int getTypeId() {
        return -55;
    }

    @Override
    public void write(ObjectDataOutput out, Object o) throws IOException {
        assert (out instanceof BufferObjectDataOutput);
        BufferObjectDataOutput bufferObjectDataOutput = (BufferObjectDataOutput)out;
        this.write(bufferObjectDataOutput, o, false);
    }

    void write(BufferObjectDataOutput out, Object o, boolean includeSchemaOnBinary) throws IOException {
        if (o instanceof CompactGenericRecord) {
            this.writeGenericRecord(out, (CompactGenericRecord)o, includeSchemaOnBinary);
        } else {
            this.writeObject(out, o, includeSchemaOnBinary);
        }
    }

    void writeGenericRecord(BufferObjectDataOutput output, CompactGenericRecord record, boolean includeSchemaOnBinary) throws IOException {
        Schema schema = record.getSchema();
        this.putToSchemaService(includeSchemaOnBinary, schema);
        this.writeSchema(output, includeSchemaOnBinary, schema);
        DefaultCompactWriter writer = new DefaultCompactWriter(this, output, schema, includeSchemaOnBinary);
        Collection<FieldDescriptor> fields = schema.getFields();
        for (FieldDescriptor fieldDescriptor : fields) {
            String fieldName = fieldDescriptor.getFieldName();
            FieldKind fieldKind = fieldDescriptor.getKind();
            FieldOperations.fieldOperations(fieldKind).writeFieldFromRecordToWriter(writer, record, fieldName);
        }
        writer.end();
    }

    private void putToSchemaService(boolean includeSchemaOnBinary, Schema schema) {
        if (!includeSchemaOnBinary) {
            this.schemaService.put(schema);
        }
    }

    public void writeObject(BufferObjectDataOutput out, Object o, boolean includeSchemaOnBinary) throws IOException {
        Class<?> aClass = o.getClass();
        CompactSerializableRegistration registration = this.getOrCreateRegistration(aClass);
        Schema schema = this.classToSchemaMap.get(aClass);
        if (schema == null) {
            schema = CompactStreamSerializer.buildSchema(registration, o);
            this.putToSchemaService(includeSchemaOnBinary, schema);
            this.classToSchemaMap.put(aClass, schema);
        }
        this.writeSchema(out, includeSchemaOnBinary, schema);
        DefaultCompactWriter writer = new DefaultCompactWriter(this, out, schema, includeSchemaOnBinary);
        registration.getSerializer().write(writer, o);
        writer.end();
    }

    private void writeSchema(BufferObjectDataOutput out, boolean includeSchemaOnBinary, Schema schema) throws IOException {
        out.writeLong(schema.getSchemaId());
        if (includeSchemaOnBinary) {
            int sizeOfSchemaPosition = out.position();
            out.writeInt(0);
            int schemaBeginPos = out.position();
            out.writeObject(schema);
            int schemaEndPosition = out.position();
            out.writeInt(sizeOfSchemaPosition, schemaEndPosition - schemaBeginPos);
        }
    }

    @Override
    public Object read(@Nonnull ObjectDataInput in) throws IOException {
        BufferObjectDataInput input = (BufferObjectDataInput)in;
        return this.read(input, false);
    }

    Object read(BufferObjectDataInput input, boolean schemaIncludedInBinary) throws IOException {
        Schema schema = this.getOrReadSchema(input, schemaIncludedInBinary);
        CompactSerializableRegistration registration = this.getOrCreateRegistration(schema.getTypeName());
        if (registration == null) {
            return this.readGenericRecord(input, schema, schemaIncludedInBinary);
        }
        DefaultCompactReader reader = new DefaultCompactReader(this, input, schema, registration.getClazz(), schemaIncludedInBinary);
        Object object = registration.getSerializer().read(reader);
        return this.managedContext != null ? this.managedContext.initialize(object) : object;
    }

    private Schema getOrReadSchema(ObjectDataInput input, boolean schemaIncludedInBinary) throws IOException {
        long schemaId = input.readLong();
        Schema schema = this.schemaService.get(schemaId);
        if (schema != null) {
            if (schemaIncludedInBinary) {
                int sizeOfSchema = input.readInt();
                input.skipBytes(sizeOfSchema);
            }
            return schema;
        }
        if (schemaIncludedInBinary) {
            input.readInt();
            schema = (Schema)input.readObject();
            long incomingSchemaId = schema.getSchemaId();
            if (schemaId != incomingSchemaId) {
                throw new HazelcastSerializationException("Invalid schema id found. Expected " + schemaId + ", actual " + incomingSchemaId + " for schema " + schema);
            }
            return schema;
        }
        throw new HazelcastSerializationException("The schema can not be found with id " + schemaId);
    }

    private CompactSerializableRegistration getOrCreateRegistration(Class clazz) {
        return this.classToRegistrationMap.computeIfAbsent(clazz, aClass -> {
            CompactSerializer<Object> serializer = this.javaRecordSerializer.isRecord((Class<?>)aClass) ? this.javaRecordSerializer : this.reflectiveSerializer;
            return new CompactSerializableRegistration((Class)aClass, aClass.getName(), serializer);
        });
    }

    private CompactSerializableRegistration getOrCreateRegistration(String typeName) {
        return this.typeNameToRegistrationMap.computeIfAbsent(typeName, s -> {
            Class<?> clazz;
            try {
                clazz = ClassLoaderUtil.loadClass(this.classLoader, typeName);
            }
            catch (Exception e) {
                return null;
            }
            try {
                return this.getOrCreateRegistration(clazz);
            }
            catch (Exception e) {
                throw new HazelcastSerializationException("Class " + clazz + " must have an empty constructor", e);
            }
        });
    }

    private GenericRecord readGenericRecord(BufferObjectDataInput input, Schema schema, boolean schemaIncludedInBinary) {
        CompactInternalGenericRecord record = new CompactInternalGenericRecord(this, input, schema, null, schemaIncludedInBinary);
        Collection<FieldDescriptor> fields = schema.getFields();
        DeserializedSchemaBoundGenericRecordBuilder builder = new DeserializedSchemaBoundGenericRecordBuilder(schema);
        for (FieldDescriptor fieldDescriptor : fields) {
            String fieldName = fieldDescriptor.getFieldName();
            FieldKind fieldKind = fieldDescriptor.getKind();
            builder.write(fieldName, record.readAny(fieldName), fieldKind);
        }
        return builder.build();
    }

    public GenericRecord readGenericRecord(ObjectDataInput in, boolean schemaIncludedInBinary) throws IOException {
        Schema schema = this.getOrReadSchema(in, schemaIncludedInBinary);
        BufferObjectDataInput input = (BufferObjectDataInput)in;
        return this.readGenericRecord(input, schema, schemaIncludedInBinary);
    }

    public InternalGenericRecord readAsInternalGenericRecord(ObjectDataInput in) throws IOException {
        Schema schema = this.getOrReadSchema(in, false);
        BufferObjectDataInput input = (BufferObjectDataInput)in;
        return new CompactInternalGenericRecord(this, input, schema, null, false);
    }

    private void registerSerializers(CompactSerializationConfig compactSerializationConfig) {
        Map<String, TriTuple<Class, String, CompactSerializer>> registrations = CompactSerializationConfigAccessor.getRegistrations(compactSerializationConfig);
        for (TriTuple<Class, String, CompactSerializer> registration : registrations.values()) {
            Class clazz = (Class)registration.element1;
            String typeName = (String)registration.element2;
            CompactSerializer<Object> serializer = (CompactSerializer<Object>)registration.element3;
            if (serializer == null) {
                serializer = this.javaRecordSerializer.isRecord(clazz) ? this.javaRecordSerializer : this.reflectiveSerializer;
            }
            CompactSerializableRegistration serializableRegistration = new CompactSerializableRegistration(clazz, typeName, serializer);
            this.saveRegistration(serializableRegistration);
        }
    }

    private void saveRegistration(CompactSerializableRegistration registration) {
        Class clazz = registration.getClazz();
        CompactSerializableRegistration existing = this.classToRegistrationMap.putIfAbsent(clazz, registration);
        if (existing != null) {
            throw new InvalidConfigurationException("Duplicate serializer registrations are found for the class '" + clazz + "'. Make sure only one Compact serializer is registered for the same class. Existing serializer: " + existing.getSerializer() + ", new serializer: " + registration.getSerializer());
        }
        String typeName = registration.getTypeName();
        existing = this.typeNameToRegistrationMap.putIfAbsent(typeName, registration);
        if (existing != null) {
            throw new InvalidConfigurationException("Duplicate serializer registrations are found for the type name '" + typeName + "'. Make sure only one Compact serializer is registered for the same type name. Existing serializer: " + existing.getSerializer() + ", new serializer: " + registration.getSerializer());
        }
    }

    private void registerDeclarativeConfigSerializers(CompactSerializationConfig config) {
        List<String> serializerClassNames = CompactSerializationConfigAccessor.getSerializerClassNames(config);
        for (String className : serializerClassNames) {
            CompactSerializer serializer;
            try {
                serializer = (CompactSerializer)ClassLoaderUtil.newInstance(this.classLoader, className);
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("Cannot create an instance of the Compact serializer '" + className + "'.");
            }
            CompactSerializableRegistration registration = new CompactSerializableRegistration(serializer.getCompactClass(), serializer.getTypeName(), serializer);
            this.saveRegistration(registration);
        }
    }

    private void registerDeclarativeConfigClasses(CompactSerializationConfig config) {
        List<String> compactSerializableClassNames = CompactSerializationConfigAccessor.getCompactSerializableClassNames(config);
        for (String className : compactSerializableClassNames) {
            Class<?> clazz;
            try {
                clazz = ClassLoaderUtil.loadClass(this.classLoader, className);
            }
            catch (ClassNotFoundException e) {
                throw new InvalidConfigurationException("Cannot load the Compact serializable class '" + className + "'.");
            }
            CompactSerializer<Object> serializer = this.javaRecordSerializer.isRecord(clazz) ? this.javaRecordSerializer : this.reflectiveSerializer;
            CompactSerializableRegistration registration = new CompactSerializableRegistration(clazz, className, serializer);
            this.saveRegistration(registration);
        }
    }

    public Schema extractSchema(BufferObjectDataInput objectDataInput) throws IOException {
        return this.getOrReadSchema(objectDataInput, false);
    }

    public Schema extractSchema(Object o) {
        Class<?> aClass = o.getClass();
        Schema schema = this.classToSchemaMap.get(aClass);
        if (schema == null) {
            CompactSerializableRegistration registration = this.getOrCreateRegistration(aClass);
            schema = CompactStreamSerializer.buildSchema(registration, o);
            this.schemaService.putLocal(schema);
            this.classToSchemaMap.put(aClass, schema);
            return schema;
        }
        return schema;
    }

    private static Schema buildSchema(CompactSerializableRegistration registration, Object o) {
        SchemaWriter writer = new SchemaWriter(registration.getTypeName());
        registration.getSerializer().write(writer, o);
        return writer.build();
    }
}

