/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl.executejar;

import com.hazelcast.instance.impl.BootstrappedInstanceProxy;
import com.hazelcast.instance.impl.executejar.ExecuteJarHelper;
import com.hazelcast.instance.impl.executejar.ExecuteJobParameters;
import com.hazelcast.instance.impl.executejar.ResettableSingleton;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.util.Util;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommandLineExecuteJar {
    private static final Logger LOGGER = Logger.getLogger(CommandLineExecuteJar.class.getName());
    private static final int JOB_START_CHECK_ATTEMPTS = 10;
    private static final int JOB_START_CHECK_INTERVAL_MILLIS = 1000;
    private static final EnumSet<JobStatus> STARTUP_STATUSES = EnumSet.of(JobStatus.NOT_RUNNING, JobStatus.STARTING);

    public void executeJar(@Nonnull ResettableSingleton<BootstrappedInstanceProxy> singleton, ExecuteJobParameters executeJobParameters, @Nullable String mainClassName, @Nonnull List<String> args) throws IOException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        BootstrappedInstanceProxy instanceProxy = singleton.remembered();
        boolean exit = false;
        try {
            String jarPath = executeJobParameters.getJarPath();
            mainClassName = ExecuteJarHelper.findMainClassNameForJar(jarPath, mainClassName);
            URL jarUrl = new File(jarPath).toURI().toURL();
            try (URLClassLoader classLoader = URLClassLoader.newInstance(new URL[]{jarUrl}, CommandLineExecuteJar.class.getClassLoader());){
                Method mainMethod = ExecuteJarHelper.findMainMethodForJar(classLoader, mainClassName);
                LOGGER.info("Found mainClassName :\"" + mainClassName + "\" and main method");
                this.invokeMain(instanceProxy, executeJobParameters, mainMethod, args);
            }
            this.awaitJobsStartedByJar(instanceProxy);
        }
        catch (JetException exception) {
            LOGGER.log(Level.SEVERE, "JetException caught while executing the jar ", exception);
            exit = true;
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Exception caught while executing the jar ", exception);
            throw exception;
        }
        finally {
            try {
                instanceProxy.shutdown();
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Shutdown failed with:", exception);
            }
            singleton.resetRemembered();
            if (exit) {
                System.exit(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeMain(BootstrappedInstanceProxy instanceProxy, ExecuteJobParameters executeJobParameters, Method mainMethod, List<String> args) throws IllegalAccessException, InvocationTargetException {
        try {
            instanceProxy.setExecuteJobParameters(executeJobParameters);
            String[] jobArgs = args.toArray(new String[0]);
            mainMethod.invoke(null, new Object[]{jobArgs});
        }
        finally {
            instanceProxy.removeExecuteJobParameters();
        }
    }

    private void awaitJobsStartedByJar(BootstrappedInstanceProxy instanceProxy) {
        List<Job> submittedJobs = instanceProxy.getSubmittedJobs();
        if (submittedJobs.isEmpty()) {
            LOGGER.severe("The JAR didn't submit any jobs.");
            return;
        }
        int previousStartingJobCount = -1;
        for (int index = 0; index < 10; ++index) {
            Util.uncheckRun(() -> Thread.sleep(1000L));
            List startedJobs = submittedJobs.stream().filter(job -> !STARTUP_STATUSES.contains((Object)job.getStatus())).collect(Collectors.toList());
            List<Job> startingJobs = submittedJobs.stream().filter(job -> !startedJobs.contains(job)).collect(Collectors.toList());
            int startingJobCount = startingJobs.size();
            if (startingJobs.isEmpty() && this.noChangeInStartingJobCount(previousStartingJobCount, startingJobCount)) break;
            if (this.changeInStartingJobCount(previousStartingJobCount, startingJobCount)) {
                this.logJobs(startingJobs);
                this.logRemainingCount(startingJobCount);
            }
            previousStartingJobCount = startingJobCount;
        }
    }

    private boolean noChangeInStartingJobCount(int previousStartingJobCount, int startingJobCount) {
        return startingJobCount == previousStartingJobCount;
    }

    private boolean changeInStartingJobCount(int previousStartingJobCount, int startingJobCount) {
        return startingJobCount != previousStartingJobCount;
    }

    private void logJobs(List<Job> startingJobs) {
        for (Job job : startingJobs) {
            String nameOrId = Objects.toString(job.getName(), job.getIdString());
            String message = String.format("Job '%s' submitted at %s changed status to %s at %s.", new Object[]{nameOrId, Util.toLocalDateTime(job.getSubmissionTime()), job.getStatus(), Util.toLocalDateTime(System.currentTimeMillis())});
            LOGGER.warning(message);
        }
    }

    private void logRemainingCount(int startingJobCount) {
        if (startingJobCount == 1) {
            LOGGER.warning("A job is still starting...");
        } else if (startingJobCount > 1) {
            String message = String.format("%,d jobs are still starting...%n", startingJobCount);
            LOGGER.warning(message);
        }
    }
}

