/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.callout;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.adempiere.base.IColumnCallout;
import org.adempiere.base.annotation.Callout;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MBankAccount;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.util.DB;
import org.compiere.util.Env;

@Callout(tableName={"C_BankTransfer"}, columnName={"PayDate", "From_Amt", "From_C_BankAccount_ID", "From_C_Charge_ID", "From_TenderType", "From_C_Currency_ID", "Rate", "To_C_BankAccount_ID", "To_C_Currency_ID", "C_ConversionType_ID", "To_Amt"})
public class CalloutBankTransfer
implements IColumnCallout {
    private static final Map<String, IColumnCallout> calloutMap = new HashMap<String, IColumnCallout>();

    static {
        calloutMap.put("From_C_BankAccount_ID", (ctx, windowNo, mTab, mField, value, oldValue) -> CalloutBankTransfer.fromBankAccount(ctx, windowNo, mTab, mField, value));
        calloutMap.put("To_C_BankAccount_ID", (ctx, windowNo, mTab, mField, value, oldValue) -> CalloutBankTransfer.toBankAccount(ctx, windowNo, mTab, mField, value));
        calloutMap.put("From_Amt", (ctx, windowNo, mTab, mField, value, oldValue) -> CalloutBankTransfer.fromAmt(ctx, windowNo, mTab, mField));
        calloutMap.put("PayDate", (ctx, windowNo, mTab, mField, value, oldValue) -> CalloutBankTransfer.payDate(ctx, windowNo, mTab, mField));
        calloutMap.put("From_C_Charge_ID", (ctx, windowNo, mTab, mField, value, oldValue) -> CalloutBankTransfer.fromCharge(ctx, windowNo, mTab, mField));
        calloutMap.put("From_TenderType", (ctx, windowNo, mTab, mField, value, oldValue) -> CalloutBankTransfer.fromTenderType(ctx, windowNo, mTab, mField));
        calloutMap.put("From_C_Currency_ID", (ctx, windowNo, mTab, mField, value, oldValue) -> CalloutBankTransfer.fromCurrency(ctx, windowNo, mTab, mField));
        calloutMap.put("To_C_Currency_ID", (ctx, windowNo, mTab, mField, value, oldValue) -> CalloutBankTransfer.toCurrency(ctx, windowNo, mTab, mField));
        calloutMap.put("Rate", (ctx, windowNo, mTab, mField, value, oldValue) -> CalloutBankTransfer.rate(ctx, windowNo, mTab, mField, value));
        calloutMap.put("C_ConversionType_ID", (ctx, windowNo, mTab, mField, value, oldValue) -> CalloutBankTransfer.conversionType(ctx, windowNo, mTab, mField));
        calloutMap.put("To_Amt", (ctx, windowNo, mTab, mField, value, oldValue) -> CalloutBankTransfer.toAmt(ctx, windowNo, mTab, mField));
    }

    public String start(Properties ctx, int windowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        IColumnCallout callout = calloutMap.get(mField.getColumnName());
        return callout != null ? callout.start(ctx, windowNo, mTab, mField, value, oldValue) : "";
    }

    private static String toAmt(Properties ctx, int windowNo, GridTab mTab, GridField mField) {
        BigDecimal fromAmt = (BigDecimal)mTab.getValue("From_Amt");
        BigDecimal toAmt = (BigDecimal)mTab.getValue("To_Amt");
        if (fromAmt == null || toAmt == null) {
            return "";
        }
        Integer From_C_Currency_ID = (Integer)mTab.getValue("From_C_Currency_ID");
        Integer To_C_Currency_ID = (Integer)mTab.getValue("To_C_Currency_ID");
        if (From_C_Currency_ID != null && From_C_Currency_ID > 0 && To_C_Currency_ID != null && To_C_Currency_ID > 0 && From_C_Currency_ID != To_C_Currency_ID && ((Boolean)mTab.getValue("IsOverrideCurrencyRate")).booleanValue() && fromAmt.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal rate = toAmt.divide(fromAmt, 12, RoundingMode.HALF_UP);
            mTab.setValue("Rate", (Object)rate);
        }
        return "";
    }

    private static String conversionType(Properties ctx, int windowNo, GridTab mTab, GridField mField) {
        if (mField.getValue() != null && mTab.getValue("To_AD_Org_ID") != null && mTab.getValue("From_C_Currency_ID") != null) {
            Integer AD_Client_ID = (Integer)mTab.getValue("AD_Client_ID");
            Integer AD_Org_ID = (Integer)mTab.getValue("To_AD_Org_ID");
            Integer From_C_Currency_ID = (Integer)mTab.getValue("From_C_Currency_ID");
            BigDecimal amt = (BigDecimal)mTab.getValue("From_Amt");
            if (amt.signum() != 0 && mTab.getValue("To_C_Currency_ID") != null && mTab.getValue("C_ConversionType_ID") != null && mTab.getValue("PayDate") != null && !((Boolean)mTab.getValue("IsOverrideCurrencyRate")).booleanValue()) {
                Timestamp payDate = (Timestamp)mTab.getValue("PayDate");
                Integer To_C_Currency_ID = (Integer)mTab.getValue("To_C_Currency_ID");
                Integer C_ConversionType_ID = (Integer)mTab.getValue("C_ConversionType_ID");
                BigDecimal rate = MConversionRate.getRate((int)From_C_Currency_ID, (int)To_C_Currency_ID, (Timestamp)payDate, (int)C_ConversionType_ID, (int)AD_Client_ID, (int)AD_Org_ID);
                if (rate != null) {
                    mTab.setValue("Rate", (Object)rate);
                    return CalloutBankTransfer.fromAmt(ctx, windowNo, mTab, mField);
                }
            }
        }
        return "";
    }

    private static String fromCurrency(Properties ctx, int windowNo, GridTab mTab, GridField mField) {
        if (mField.getValue() != null && mTab.getValue("To_AD_Org_ID") != null) {
            Integer AD_Client_ID = (Integer)mTab.getValue("AD_Client_ID");
            Integer AD_Org_ID = (Integer)mTab.getValue("To_AD_Org_ID");
            Integer From_C_Currency_ID = (Integer)mField.getValue();
            BigDecimal amt = (BigDecimal)mTab.getValue("From_Amt");
            if (amt.signum() != 0 && mTab.getValue("To_C_Currency_ID") != null && mTab.getValue("C_ConversionType_ID") != null && mTab.getValue("PayDate") != null && !((Boolean)mTab.getValue("IsOverrideCurrencyRate")).booleanValue()) {
                Timestamp payDate = (Timestamp)mTab.getValue("PayDate");
                Integer To_C_Currency_ID = (Integer)mTab.getValue("To_C_Currency_ID");
                Integer C_ConversionType_ID = (Integer)mTab.getValue("C_ConversionType_ID");
                BigDecimal rate = MConversionRate.getRate((int)From_C_Currency_ID, (int)To_C_Currency_ID, (Timestamp)payDate, (int)C_ConversionType_ID, (int)AD_Client_ID, (int)AD_Org_ID);
                if (rate != null) {
                    mTab.setValue("Rate", (Object)rate);
                    return CalloutBankTransfer.fromAmt(ctx, windowNo, mTab, mField);
                }
            }
        }
        return "";
    }

    private static String toCurrency(Properties ctx, int windowNo, GridTab mTab, GridField mField) {
        if (mField.getValue() != null && mTab.getValue("To_AD_Org_ID") != null) {
            Integer AD_Client_ID = (Integer)mTab.getValue("AD_Client_ID");
            Integer AD_Org_ID = (Integer)mTab.getValue("To_AD_Org_ID");
            Integer To_C_Currency_ID = (Integer)mField.getValue();
            BigDecimal amt = (BigDecimal)mTab.getValue("From_Amt");
            if (amt.signum() != 0 && mTab.getValue("From_C_Currency_ID") != null && mTab.getValue("C_ConversionType_ID") != null && mTab.getValue("PayDate") != null && !((Boolean)mTab.getValue("IsOverrideCurrencyRate")).booleanValue()) {
                Timestamp payDate = (Timestamp)mTab.getValue("PayDate");
                Integer From_C_Currency_ID = (Integer)mTab.getValue("From_C_Currency_ID");
                Integer C_ConversionType_ID = (Integer)mTab.getValue("C_ConversionType_ID");
                BigDecimal rate = MConversionRate.getRate((int)From_C_Currency_ID, (int)To_C_Currency_ID, (Timestamp)payDate, (int)C_ConversionType_ID, (int)AD_Client_ID, (int)AD_Org_ID);
                if (rate != null) {
                    mTab.setValue("Rate", (Object)rate);
                    return CalloutBankTransfer.fromAmt(ctx, windowNo, mTab, mField);
                }
            }
        }
        return "";
    }

    private static String fromTenderType(Properties ctx, int windowNo, GridTab mTab, GridField mField) {
        mTab.setValue("To_TenderType", mField.getValue());
        return "";
    }

    private static String fromCharge(Properties ctx, int windowNo, GridTab mTab, GridField mField) {
        mTab.setValue("To_C_Charge_ID", mField.getValue());
        return "";
    }

    private static String payDate(Properties ctx, int windowNo, GridTab mTab, GridField mField) {
        mTab.setValue("DateAcct", mField.getValue());
        return "";
    }

    private static String fromBankAccount(Properties ctx, int windowNo, GridTab mTab, GridField mField, Object value) {
        Integer From_C_BankAccount_ID = (Integer)value;
        if (From_C_BankAccount_ID == null || From_C_BankAccount_ID == 0) {
            return "";
        }
        MBankAccount ba = MBankAccount.get((Properties)ctx, (int)From_C_BankAccount_ID);
        int AD_Org_ID = ba.getAD_Org_ID();
        if (AD_Org_ID > 0) {
            mTab.setValue("From_AD_Org_ID", (Object)AD_Org_ID);
        } else {
            AD_Org_ID = Env.getAD_Org_ID((Properties)Env.getCtx());
            if (AD_Org_ID > 0) {
                mTab.setValue("From_AD_Org_ID", (Object)AD_Org_ID);
            }
        }
        if (ba.getC_Currency_ID() > 0) {
            mTab.setValue("From_C_Currency_ID", (Object)ba.getC_Currency_ID());
        }
        int C_BPartner_ID = 0;
        if (AD_Org_ID > 0) {
            String sql = "SELECT bp.C_BPartner_ID FROM C_BPartner bp WHERE bp.AD_OrgBP_ID = ? AND bp.IsActive = 'Y' ";
            C_BPartner_ID = DB.getSQLValue(null, (String)sql, (int)AD_Org_ID);
        }
        if (C_BPartner_ID > 0) {
            mTab.setValue("From_C_BPartner_ID", (Object)C_BPartner_ID);
        } else {
            mTab.setValue("From_C_BPartner_ID", null);
        }
        return "";
    }

    private static String toBankAccount(Properties ctx, int windowNo, GridTab mTab, GridField mField, Object value) {
        Integer To_C_BankAccount_ID = (Integer)value;
        if (To_C_BankAccount_ID == null || To_C_BankAccount_ID == 0) {
            return "";
        }
        MBankAccount ba = MBankAccount.get((Properties)ctx, (int)To_C_BankAccount_ID);
        int AD_Org_ID = ba.getAD_Org_ID();
        if (AD_Org_ID > 0) {
            mTab.setValue("To_AD_Org_ID", (Object)ba.getAD_Org_ID());
        } else {
            AD_Org_ID = Env.getAD_Org_ID((Properties)Env.getCtx());
            if (AD_Org_ID > 0) {
                mTab.setValue("To_AD_Org_ID", (Object)AD_Org_ID);
            }
        }
        if (ba.getC_Currency_ID() > 0) {
            mTab.setValue("To_C_Currency_ID", (Object)ba.getC_Currency_ID());
        }
        int C_BPartner_ID = 0;
        if (AD_Org_ID > 0) {
            String sql = "SELECT bp.C_BPartner_ID FROM C_BPartner bp WHERE bp.AD_OrgBP_ID = ? AND bp.IsActive = 'Y' ";
            C_BPartner_ID = DB.getSQLValue(null, (String)sql, (int)AD_Org_ID);
        }
        if (C_BPartner_ID > 0) {
            mTab.setValue("To_C_BPartner_ID", (Object)C_BPartner_ID);
        } else if (mTab.getValue("From_AD_Org_ID") != null && AD_Org_ID == (Integer)mTab.getValue("From_AD_Org_ID") && mTab.getValue("From_C_BPartner_ID") != null && (Integer)mTab.getValue("From_C_BPartner_ID") > 0) {
            mTab.setValue("To_C_BPartner_ID", mTab.getValue("From_C_BPartner_ID"));
        } else {
            mTab.setValue("To_C_BPartner_ID", null);
        }
        Integer From_C_Currency_ID = (Integer)mTab.getValue("From_C_Currency_ID");
        Integer To_C_Currency_ID = (Integer)mTab.getValue("To_C_Currency_ID");
        Timestamp PayDate = (Timestamp)mTab.getValue("PayDate");
        Integer AD_Client_ID = (Integer)mTab.getValue("AD_Client_ID");
        if (From_C_Currency_ID != null && From_C_Currency_ID > 0 && To_C_Currency_ID != null && To_C_Currency_ID > 0) {
            if (From_C_Currency_ID == To_C_Currency_ID) {
                mTab.setValue("Rate", (Object)BigDecimal.ONE);
                return CalloutBankTransfer.fromAmt(ctx, windowNo, mTab, mField);
            }
            if (PayDate != null && AD_Client_ID != null && mTab.getValue("C_ConversionType_ID") != null) {
                Integer C_ConversionType_ID = (Integer)mTab.getValue("C_ConversionType_ID");
                BigDecimal rate = MConversionRate.getRate((int)From_C_Currency_ID, (int)To_C_Currency_ID, (Timestamp)PayDate, (int)C_ConversionType_ID, (int)AD_Client_ID, (int)AD_Org_ID);
                if (rate != null) {
                    mTab.setValue("Rate", (Object)rate);
                    return CalloutBankTransfer.fromAmt(ctx, windowNo, mTab, mField);
                }
            }
        }
        return "";
    }

    private static String rate(Properties ctx, int windowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal fromAmt = (BigDecimal)mTab.getValue("From_Amt");
        if (fromAmt == null) {
            return "";
        }
        Integer From_C_Currency_ID = (Integer)mTab.getValue("From_C_Currency_ID");
        Integer To_C_Currency_ID = (Integer)mTab.getValue("To_C_Currency_ID");
        if (From_C_Currency_ID != null && From_C_Currency_ID > 0 && To_C_Currency_ID != null && To_C_Currency_ID > 0) {
            if (From_C_Currency_ID == To_C_Currency_ID) {
                mTab.setValue("Rate", (Object)BigDecimal.ONE);
                return CalloutBankTransfer.fromAmt(ctx, windowNo, mTab, mField);
            }
            if (fromAmt.signum() != 0) {
                return CalloutBankTransfer.fromAmt(ctx, windowNo, mTab, mField);
            }
        }
        return "";
    }

    private static String fromAmt(Properties ctx, int WindowNo, GridTab mTab, GridField mField) {
        MCurrency cur;
        BigDecimal rate = (BigDecimal)mTab.getValue("Rate");
        BigDecimal fromAmt = (BigDecimal)mTab.getValue("From_Amt");
        if (fromAmt == null || rate == null) {
            return "";
        }
        BigDecimal toAmt = rate.multiply(fromAmt);
        Integer To_C_Currency_ID = (Integer)mTab.getValue("To_C_Currency_ID");
        if (To_C_Currency_ID != null && To_C_Currency_ID > 0 && (cur = MCurrency.get((Properties)ctx, (int)To_C_Currency_ID)) != null) {
            toAmt = toAmt.setScale(cur.getStdPrecision(), RoundingMode.HALF_UP);
        }
        mTab.setValue("To_Amt", (Object)toAmt);
        return "";
    }
}

