/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps.event;

import java.util.Map;
import org.zkoss.gmaps.Gmarker;
import org.zkoss.gmaps.LatLng;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.MouseEvent;

public class MapMouseEvent
extends MouseEvent {
    private final Component _ref;
    private final LatLng _latLng;

    public static final MapMouseEvent getMapMouseEvent(AuRequest request) {
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)request);
        }
        Map data = request.getData();
        if (data == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{data, request});
        }
        Component ref = request.getDesktop().getComponentByUuidIfAny((String)data.get("reference"));
        double lat = ((Number)data.get("lat")).doubleValue();
        double lng = ((Number)data.get("lng")).doubleValue();
        Number xn = (Number)data.get("x");
        Number yn = (Number)data.get("y");
        Number pxn = (Number)data.get("pageX");
        Number pyn = (Number)data.get("pageY");
        int x = xn instanceof Double ? (int)Math.round((Double)xn) : xn.intValue();
        int y = yn instanceof Double ? (int)Math.round((Double)yn) : yn.intValue();
        int pageX = pxn instanceof Double ? (int)Math.round((Double)pxn) : pxn.intValue();
        int pageY = pyn instanceof Double ? (int)Math.round((Double)pyn) : pyn.intValue();
        return new MapMouseEvent(request.getCommand(), comp, ref, new LatLng(lat, lng), x, y, pageX, pageY, AuRequests.parseKeys((Map)data));
    }

    public MapMouseEvent(String name, Component target, Component ref, LatLng latLng, int x, int y, int pageX, int pageY, int keys) {
        super(name, target, x, y, pageX, pageY, keys);
        this._ref = ref;
        this._latLng = latLng;
    }

    public MapMouseEvent(String name, Component target, Component ref, double lat, double lng, int x, int y, int pageX, int pageY, int keys) {
        this(name, target, ref, new LatLng(lat, lng), x, y, pageX, pageY, keys);
    }

    public Gmarker getGmarker() {
        Component ref = this.getReference();
        return ref instanceof Gmarker ? (Gmarker)ref : null;
    }

    public Component getReference() {
        return this._ref;
    }

    public String getArea() {
        return null;
    }

    public LatLng getLatLng() {
        return this._latLng;
    }

    public double getLat() {
        return this._latLng.getLatitude();
    }

    public double getLng() {
        return this._latLng.getLongitude();
    }
}

