/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.zkoss.gmaps.AbstractMapModel;

public class MapModelSet
extends AbstractMapModel
implements Set,
Serializable {
    private static final long serialVersionUID = 200807021330L;
    protected Set _set;

    public MapModelSet(Set set, boolean live) {
        this._set = live ? set : new HashSet(set);
    }

    public MapModelSet() {
        this._set = new HashSet();
    }

    public MapModelSet(Collection c) {
        this._set = new HashSet(c);
    }

    public MapModelSet(Object[] array) {
        this._set = new HashSet(array.length);
        for (int j = 0; j < array.length; ++j) {
            this._set.add(array[j]);
        }
    }

    public MapModelSet(int initialCapacity) {
        this._set = new HashSet(initialCapacity);
    }

    public MapModelSet(int initialCapacity, float loadFactor) {
        this._set = new HashSet(initialCapacity, loadFactor);
    }

    public Set getInnerSet() {
        return this._set;
    }

    public Collection getItemsIn(double swlat, double swlng, double nelat, double nelng, double cenlat, double cenlng, int zoom) {
        return Collections.unmodifiableSet(this._set);
    }

    public boolean add(Object o) {
        boolean ret = this._set.add(o);
        if (ret) {
            this.fireEvent(1, Collections.singleton(o));
        }
        return ret;
    }

    public boolean addAll(Collection c) {
        boolean ret = this._set.addAll(c);
        if (ret) {
            this.fireEvent(1, Collections.unmodifiableCollection(c));
        }
        return ret;
    }

    public void clear() {
        if (!this._set.isEmpty()) {
            this._set.clear();
            this.fireEvent(4, null);
        }
    }

    public boolean contains(Object elem) {
        return this._set.contains(elem);
    }

    public boolean containsAll(Collection c) {
        return this._set.containsAll(c);
    }

    public boolean equals(Object o) {
        return this._set.equals(o instanceof MapModelSet ? ((MapModelSet)o)._set : o);
    }

    public int hashCode() {
        return this._set.hashCode();
    }

    public boolean isEmpty() {
        return this._set.isEmpty();
    }

    public String toString() {
        return this._set.toString();
    }

    public Iterator iterator() {
        return new Iterator(){
            private Iterator _it;
            private Object _current;
            {
                this._it = MapModelSet.this._set.iterator();
                this._current = null;
            }

            public boolean hasNext() {
                return this._it.hasNext();
            }

            public Object next() {
                this._current = this._it.next();
                return this._current;
            }

            public void remove() {
                this._it.remove();
                MapModelSet.this.fireEvent(2, Collections.singleton(this._current));
            }
        };
    }

    public boolean remove(Object o) {
        if (this._set.contains(o)) {
            this._set.remove(o);
            this.fireEvent(2, Collections.singleton(o));
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection c) {
        if (this._set == c || this == c) {
            this.clear();
            return true;
        }
        boolean ret = this._set.removeAll(c);
        if (ret) {
            this.fireEvent(2, Collections.unmodifiableCollection(c));
        }
        return ret;
    }

    public boolean retainAll(Collection c) {
        if (this._set == c || this == c) {
            return false;
        }
        boolean ret = this._set.retainAll(c);
        if (ret) {
            this.fireEvent(3, Collections.unmodifiableSet(this._set));
        }
        return ret;
    }

    public int size() {
        return this._set.size();
    }

    public Object[] toArray() {
        return this._set.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this._set.toArray(a);
    }
}

