/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.calendar.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.zkoss.calendar.Calendars;
import org.zkoss.calendar.api.CalendarEvent;
import org.zkoss.calendar.api.DateFormatter;
import org.zkoss.json.JSONObject;
import org.zkoss.util.Locales;
import org.zkoss.xml.XMLs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final int ONE_HOUR = 3600000;
    private static final SimpleDateFormat _sdfKey = new SimpleDateFormat("yyyy/MM/dd");

    public static String createEventTitle(DateFormatter df, Locale locale, TimeZone timezone, CalendarEvent ce) {
        if (df == null) {
            return ce.getTitle();
        }
        Date begin = ce.getBeginDate();
        Date end = ce.getEndDate();
        if (end.getTime() - begin.getTime() < 3600000L) {
            return df.getCaptionByTimeOfDay(begin, locale, timezone) + " - " + ce.getContent();
        }
        return df.getCaptionByTimeOfDay(begin, locale, timezone) + " - " + df.getCaptionByTimeOfDay(end, locale, timezone);
    }

    public static List<List<String>> packAllCaptionOfMonth(Calendars calendars, Calendar cal, Locale locale, TimeZone timezone, DateFormatter dfhandler) {
        int weeks = calendars.getWeekOfMonth();
        boolean isWeekOfYear = calendars.isWeekOfYear();
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        ArrayList<String> list1 = new ArrayList<String>();
        ArrayList<String> list2 = new ArrayList<String>();
        ArrayList<String> list3 = new ArrayList<String>();
        ArrayList<String> list4 = new ArrayList<String>();
        result.add(list1);
        result.add(list2);
        result.add(list3);
        result.add(list4);
        int count = 0;
        for (int j = 0; j < weeks; ++j) {
            if (isWeekOfYear) {
                list4.add(dfhandler.getCaptionByWeekOfYear(cal.getTime(), locale, timezone));
            }
            for (int i = 0; i < 7; ++i) {
                if (count < 7) {
                    ++count;
                    list1.add(dfhandler.getCaptionByDayOfWeek(cal.getTime(), locale, timezone));
                }
                cal.set(14, 0);
                Date d = cal.getTime();
                list2.add(dfhandler.getCaptionByPopup(d, locale, timezone));
                list3.add(dfhandler.getCaptionByDateOfMonth(d, locale, timezone));
                cal.add(5, 1);
            }
        }
        return result;
    }

    public static List<String> packCaptionByDate(Calendar cal, int days, Locale locale, TimeZone timezone, DateFormatter dfhandler) {
        ArrayList<String> result = new ArrayList<String>();
        for (int j = 0; j < days; ++j) {
            result.add(dfhandler.getCaptionByDate(cal.getTime(), locale, timezone));
            cal.add(7, 1);
        }
        return result;
    }

    public static List<String> packCaptionByTimeOfDay(Calendar cal, Map<TimeZone, String> zones, Locale locale, DateFormatter dfhandler) {
        ArrayList<String> result = new ArrayList<String>();
        for (TimeZone tz : zones.keySet()) {
            for (int k = 0; k < 24; ++k) {
                cal.set(11, k);
                result.add(dfhandler.getCaptionByTimeOfDay(cal.getTime(), locale, tz));
            }
        }
        return result;
    }

    public static List<String> packZonesOffset(Map<TimeZone, String> _tzones) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<TimeZone> it = _tzones.keySet().iterator();
        while (it.hasNext()) {
            result.add("" + it.next().getRawOffset() / 60000);
        }
        return result;
    }

    public static String encloseEventList(Calendars calendars, Collection<CalendarEvent> collection) {
        StringBuffer sb = new StringBuffer().append('[');
        Date beginDate = calendars.getBeginDate();
        _sdfKey.setTimeZone(calendars.getDefaultTimeZone());
        for (CalendarEvent ce : collection) {
            String key = ce.getBeginDate().before(beginDate) ? Util.getEventKey(beginDate) : Util.getEventKey(ce.getBeginDate());
            Util.appendEventByJSON(sb, calendars, key, ce);
        }
        int len = sb.length();
        collection.clear();
        return sb.replace(len - 1, len, "]").toString();
    }

    public static String encloseList(Collection<String> collection) {
        StringBuffer sb = new StringBuffer().append("[\"");
        Iterator<String> it = collection.iterator();
        while (it.hasNext()) {
            sb.append(it.next()).append("\",\"");
        }
        int len = sb.length();
        return sb.replace(len - 2, len, "]").toString();
    }

    public static String encloseEventMap(Calendars calendars, Map<String, List<CalendarEvent>> map) {
        int len;
        StringBuffer sb = new StringBuffer().append('[');
        for (Map.Entry<String, List<CalendarEvent>> entry : map.entrySet()) {
            sb.append('[');
            String key = entry.getKey();
            Iterator<CalendarEvent> it2 = entry.getValue().iterator();
            while (it2.hasNext()) {
                Util.appendEventByJSON(sb, calendars, key, it2.next());
            }
            len = sb.length();
            sb.replace(len - 1, len, "],");
        }
        len = sb.length();
        if (map.size() != 0) {
            return sb.replace(len - 1, len, "]").toString();
        }
        return sb.append(']').toString();
    }

    private static void appendEventByJSON(StringBuffer sb, Calendars calendars, String key, CalendarEvent ce) {
        DateFormatter df = calendars.getDateFormatter();
        Locale locale = Locales.getCurrent();
        TimeZone timezone = calendars.getDefaultTimeZone();
        String title = Util.createEventTitle(df, locale, timezone, ce);
        JSONObject json = new JSONObject();
        json.put((Object)"id", (Object)calendars.getCalendarEventId(ce));
        json.put((Object)"key", (Object)key);
        json.put((Object)"title", (Object)(calendars.isEscapeXML() ? Util.escapeXML(title) : title));
        json.put((Object)"headerColor", (Object)ce.getHeaderColor());
        json.put((Object)"contentColor", (Object)ce.getContentColor());
        json.put((Object)"content", (Object)(calendars.isEscapeXML() ? Util.escapeXML(ce.getContent()) : ce.getContent()));
        json.put((Object)"beginDate", (Object)String.valueOf(Util.getDSTTime(timezone, ce.getBeginDate())));
        json.put((Object)"endDate", (Object)String.valueOf(Util.getDSTTime(timezone, ce.getEndDate())));
        json.put((Object)"isLocked", (Object)String.valueOf(ce.isLocked()));
        json.put((Object)"zclass", (Object)ce.getZclass());
        sb.append(json.toString()).append(",");
    }

    public static String escapeXML(String s) {
        StringBuffer sb = new StringBuffer();
        if (s == null) {
            return "";
        }
        int len = s.length();
        for (int j = 0; j < len; ++j) {
            char cc = s.charAt(j);
            String esc = XMLs.escapeXML((char)cc);
            if (esc != null) {
                sb.append(esc);
                continue;
            }
            sb.append(cc);
        }
        return sb.toString();
    }

    public static long getDSTTime(TimeZone tz, Date date) {
        return date.getTime() + (long)(tz.inDaylightTime(date) ? tz.getDSTSavings() : 0);
    }

    public static Date fixDSTTime(TimeZone tz, Date date) {
        return new Date(date.getTime() - (long)(tz.inDaylightTime(date) ? tz.getDSTSavings() : 0));
    }

    private static String getEventKey(Date date) {
        return _sdfKey.format(date);
    }
}

