/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.compiere.acct.Doc;
import org.compiere.acct.DocManager;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MShipper;
import org.compiere.model.MShippingProcessor;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.ProductCost;
import org.compiere.model.Query;
import org.compiere.model.X_C_BP_ShippingAcct;
import org.compiere.model.X_M_ShippingProcessorCfg;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.ConversionRateHelper;
import org.idempiere.test.DictionaryIDs;
import org.idempiere.test.FactAcct;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceLock;

public class InOutTest
extends AbstractTestCase {
    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testMatReceiptPosting() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        int Spot_ConversionType_ID = DictionaryIDs.C_ConversionType.SPOT.id;
        int Company_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MPriceList priceList = new MPriceList(Env.getCtx(), 0, null);
        priceList.setName("Purchase AUD " + System.currentTimeMillis());
        MCurrency australianDollar = MCurrency.get((int)DictionaryIDs.C_Currency.AUD.id);
        priceList.setC_Currency_ID(australianDollar.getC_Currency_ID());
        priceList.setPricePrecision(australianDollar.getStdPrecision());
        priceList.saveEx();
        MPriceListVersion plv = new MPriceListVersion(priceList);
        plv.setM_DiscountSchema_ID(DictionaryIDs.M_DiscountSchema.PURCHASE_2001.id);
        plv.setValidFrom(currentDate);
        plv.saveEx();
        BigDecimal priceInAud = new BigDecimal(23.32);
        MProductPrice pp = new MProductPrice(plv, product.getM_Product_ID(), priceInAud, priceInAud, Env.ZERO);
        pp.saveEx();
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        BigDecimal audToUsdCompany = new BigDecimal(0.676234);
        MConversionRate crUsdCompany = this.createConversionRate(australianDollar.getC_Currency_ID(), usd.getC_Currency_ID(), Company_ConversionType_ID, currentDate, audToUsdCompany);
        BigDecimal audToUsdSpot = new BigDecimal(0.77);
        MConversionRate crUsdSpot = this.createConversionRate(australianDollar.getC_Currency_ID(), usd.getC_Currency_ID(), Spot_ConversionType_ID, currentDate, audToUsdSpot);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal audToEuroCompany = new BigDecimal(0.746234);
        MConversionRate crEurCompany = this.createConversionRate(australianDollar.getC_Currency_ID(), euro.getC_Currency_ID(), Company_ConversionType_ID, currentDate, audToEuroCompany);
        BigDecimal audToEuroSpot = new BigDecimal(0.64);
        MConversionRate crEurSpot = this.createConversionRate(australianDollar.getC_Currency_ID(), euro.getC_Currency_ID(), Spot_ConversionType_ID, currentDate, audToEuroSpot);
        try {
            List<FactAcct> expected;
            List factAccts;
            Query query;
            BigDecimal acctAmount;
            BigDecimal acctSource;
            MAccount acctNIR;
            Doc doc;
            BigDecimal rate;
            MAcctSchema as;
            MAcctSchema[] ass;
            MOrder order = this.createPurchaseOrder(bpartner, currentDate, priceList.getM_PriceList_ID(), Company_ConversionType_ID);
            BigDecimal qtyOrdered = new BigDecimal(500);
            MOrderLine orderLine = this.createOrderLine(order, 10, product, qtyOrdered, priceInAud);
            this.completeDocument((PO)order);
            MInOut receipt = this.createMMReceipt(order, currentDate);
            BigDecimal qtyDelivered = new BigDecimal(500);
            MInOutLine receiptLine = this.createInOutLine(receipt, orderLine, qtyDelivered);
            this.completeDocument((PO)receipt);
            this.postDocument((PO)receipt);
            MAcctSchema[] mAcctSchemaArray = ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            int n = ass.length;
            int n2 = 0;
            while (n2 < n) {
                as = mAcctSchemaArray[n2];
                rate = Env.ZERO;
                if (as.getC_Currency_ID() == usd.getC_Currency_ID()) {
                    rate = audToUsdCompany;
                } else if (as.getC_Currency_ID() == euro.getC_Currency_ID()) {
                    rate = audToEuroCompany;
                }
                doc = DocManager.getDocument((MAcctSchema)as, (int)319, (int)receipt.get_ID(), (String)this.getTrxName());
                doc.setC_BPartner_ID(receipt.getC_BPartner_ID());
                acctNIR = doc.getAccount(51, as);
                acctSource = orderLine.getPriceActual().multiply(receiptLine.getMovementQty()).setScale(as.getC_Currency().getStdPrecision(), RoundingMode.HALF_UP);
                acctAmount = acctSource.multiply(rate).setScale(as.getC_Currency().getStdPrecision(), RoundingMode.HALF_UP);
                query = MFactAcct.createRecordIdQuery((int)319, (int)receipt.get_ID(), (int)as.getC_AcctSchema_ID(), (String)this.getTrxName());
                factAccts = query.list();
                expected = Arrays.asList(new FactAcct(acctNIR, acctAmount, acctSource, as.getC_Currency().getStdPrecision(), false, receiptLine.get_ID()));
                this.assertFactAcctEntries(factAccts, expected);
                ++n2;
            }
            order = this.createPurchaseOrder(bpartner, currentDate, priceList.getM_PriceList_ID(), Spot_ConversionType_ID);
            orderLine = this.createOrderLine(order, 10, product, qtyOrdered, priceInAud);
            this.completeDocument((PO)order);
            receipt = this.createMMReceipt(order, currentDate);
            receiptLine = this.createInOutLine(receipt, orderLine, qtyDelivered);
            this.completeDocument((PO)receipt);
            this.postDocument((PO)receipt);
            mAcctSchemaArray = ass;
            n = ass.length;
            n2 = 0;
            while (n2 < n) {
                as = mAcctSchemaArray[n2];
                rate = Env.ZERO;
                if (as.getC_Currency_ID() == usd.getC_Currency_ID()) {
                    rate = audToUsdSpot;
                } else if (as.getC_Currency_ID() == euro.getC_Currency_ID()) {
                    rate = audToEuroSpot;
                }
                doc = DocManager.getDocument((MAcctSchema)as, (int)319, (int)receipt.get_ID(), (String)this.getTrxName());
                doc.setC_BPartner_ID(receipt.getC_BPartner_ID());
                acctNIR = doc.getAccount(51, as);
                acctSource = orderLine.getPriceActual().multiply(receiptLine.getMovementQty()).setScale(as.getC_Currency().getStdPrecision(), RoundingMode.HALF_UP);
                acctAmount = acctSource.multiply(rate).setScale(as.getC_Currency().getStdPrecision(), RoundingMode.HALF_UP);
                query = MFactAcct.createRecordIdQuery((int)319, (int)receipt.get_ID(), (int)as.getC_AcctSchema_ID(), (String)this.getTrxName());
                factAccts = query.list();
                expected = Arrays.asList(new FactAcct(acctNIR, acctAmount, acctSource, as.getC_Currency().getStdPrecision(), false, receiptLine.get_ID()));
                this.assertFactAcctEntries(factAccts, expected);
                ++n2;
            }
        }
        finally {
            this.rollback();
            this.deleteConversionRate(crUsdCompany);
            this.deleteConversionRate(crUsdSpot);
            this.deleteConversionRate(crEurCompany);
            this.deleteConversionRate(crEurSpot);
            pp.deleteEx(true);
            plv.deleteEx(true);
            priceList.deleteEx(true);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testMatShipmentPosting() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        int Company_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MPriceList priceList = new MPriceList(Env.getCtx(), 0, null);
        priceList.setName("Purchase AUD " + System.currentTimeMillis());
        MCurrency australianDollar = MCurrency.get((int)DictionaryIDs.C_Currency.AUD.id);
        priceList.setC_Currency_ID(australianDollar.getC_Currency_ID());
        priceList.setPricePrecision(australianDollar.getStdPrecision());
        priceList.saveEx();
        MPriceListVersion plv = new MPriceListVersion(priceList);
        plv.setM_DiscountSchema_ID(DictionaryIDs.M_DiscountSchema.PURCHASE_2001.id);
        plv.setValidFrom(currentDate);
        plv.saveEx();
        BigDecimal priceInAud = new BigDecimal(23.32);
        MProductPrice pp = new MProductPrice(plv, product.getM_Product_ID(), priceInAud, priceInAud, Env.ZERO);
        pp.saveEx();
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        BigDecimal audToUsdCompany = new BigDecimal(0.676234);
        MConversionRate crUsdCompany = this.createConversionRate(australianDollar.getC_Currency_ID(), usd.getC_Currency_ID(), Company_ConversionType_ID, currentDate, audToUsdCompany);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal audToEuroCompany = new BigDecimal(0.746234);
        MConversionRate crEurCompany = this.createConversionRate(australianDollar.getC_Currency_ID(), euro.getC_Currency_ID(), Company_ConversionType_ID, currentDate, audToEuroCompany);
        try {
            MAcctSchema[] ass;
            MOrder order = this.createPurchaseOrder(bpartner, currentDate, priceList.getM_PriceList_ID(), Company_ConversionType_ID);
            BigDecimal qtyOrdered = BigDecimal.TEN;
            MOrderLine orderLine = this.createOrderLine(order, 10, product, qtyOrdered, priceInAud);
            this.completeDocument((PO)order);
            MInOut receipt = this.createMMReceipt(order, currentDate);
            BigDecimal qtyDelivered = BigDecimal.TEN;
            MInOutLine receiptLine = this.createInOutLine(receipt, orderLine, qtyDelivered);
            this.completeDocument((PO)receipt);
            this.postDocument((PO)receipt);
            MAcctSchema[] mAcctSchemaArray = ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            int n = ass.length;
            int n2 = 0;
            while (n2 < n) {
                MAcctSchema as = mAcctSchemaArray[n2];
                BigDecimal rate = Env.ZERO;
                if (as.getC_Currency_ID() == usd.getC_Currency_ID()) {
                    rate = audToUsdCompany;
                } else if (as.getC_Currency_ID() == euro.getC_Currency_ID()) {
                    rate = audToEuroCompany;
                }
                Doc doc = DocManager.getDocument((MAcctSchema)as, (int)319, (int)receipt.get_ID(), (String)this.getTrxName());
                doc.setC_BPartner_ID(receipt.getC_BPartner_ID());
                MAccount acctNIR = doc.getAccount(51, as);
                BigDecimal acctSource = orderLine.getPriceActual().multiply(receiptLine.getMovementQty()).setScale(as.getC_Currency().getStdPrecision(), RoundingMode.HALF_UP);
                BigDecimal acctAmount = acctSource.multiply(rate).setScale(as.getC_Currency().getStdPrecision(), RoundingMode.HALF_UP);
                Query query = MFactAcct.createRecordIdQuery((int)319, (int)receipt.get_ID(), (int)as.getC_AcctSchema_ID(), (String)this.getTrxName());
                List fas = query.list();
                List<FactAcct> expected = Arrays.asList(new FactAcct(acctNIR, acctAmount, acctSource, 2, false, receiptLine.get_ID()));
                this.assertFactAcctEntries(fas, expected);
                ++n2;
            }
            MRMA rma = new MRMA(Env.getCtx(), 0, this.getTrxName());
            rma.setName(order.getDocumentNo());
            rma.setC_DocType_ID(DictionaryIDs.C_DocType.VENDOR_RETURN_MATERIAL.id);
            rma.setM_RMAType_ID(DictionaryIDs.M_RMAType.DAMAGE_ON_ARRIVAL.id);
            rma.setM_InOut_ID(receipt.get_ID());
            rma.setIsSOTrx(false);
            rma.setSalesRep_ID(100);
            rma.saveEx();
            MRMALine rmaLine = new MRMALine(Env.getCtx(), 0, this.getTrxName());
            rmaLine.setLine(10);
            rmaLine.setM_RMA_ID(rma.get_ID());
            rmaLine.setM_InOutLine_ID(receiptLine.get_ID());
            rmaLine.setQty(BigDecimal.TEN);
            rmaLine.saveEx();
            this.completeDocument((PO)rma);
            MInOut delivery = new MInOut(Env.getCtx(), 0, this.getTrxName());
            delivery.setM_RMA_ID(rma.get_ID());
            delivery.setBPartner(bpartner);
            delivery.setIsSOTrx(false);
            delivery.setMovementType("V-");
            delivery.setC_DocType_ID(DictionaryIDs.C_DocType.MM_VENDOR_RETURN.id);
            delivery.setDocStatus("DR");
            delivery.setDocAction("CO");
            delivery.setM_Warehouse_ID(receipt.getM_Warehouse_ID());
            delivery.saveEx();
            MInOutLine deliveryLine = new MInOutLine(delivery);
            deliveryLine.setM_RMALine_ID(rmaLine.get_ID());
            deliveryLine.setLine(10);
            deliveryLine.setProduct(product);
            deliveryLine.setQty(BigDecimal.TEN);
            deliveryLine.setM_Locator_ID(receiptLine.getM_Locator_ID());
            deliveryLine.saveEx();
            this.completeDocument((PO)delivery);
            this.postDocument((PO)delivery);
            MAcctSchema[] mAcctSchemaArray2 = ass;
            int n3 = ass.length;
            int n4 = 0;
            while (n4 < n3) {
                MAcctSchema as = mAcctSchemaArray2[n4];
                BigDecimal rate = Env.ZERO;
                if (as.getC_Currency_ID() == usd.getC_Currency_ID()) {
                    rate = audToUsdCompany;
                } else if (as.getC_Currency_ID() == euro.getC_Currency_ID()) {
                    rate = audToEuroCompany;
                }
                Doc doc = DocManager.getDocument((MAcctSchema)as, (int)319, (int)delivery.get_ID(), (String)this.getTrxName());
                doc.setC_BPartner_ID(delivery.getC_BPartner_ID());
                MAccount acctNIR = doc.getAccount(51, as);
                BigDecimal acctSource = orderLine.getPriceActual().multiply(deliveryLine.getMovementQty()).setScale(as.getC_Currency().getStdPrecision(), RoundingMode.HALF_UP);
                BigDecimal acctAmount = acctSource.multiply(rate).setScale(as.getC_Currency().getStdPrecision(), RoundingMode.HALF_UP);
                Query query = MFactAcct.createRecordIdQuery((int)319, (int)delivery.get_ID(), (int)as.getC_AcctSchema_ID(), (String)this.getTrxName());
                List fas = query.list();
                List<FactAcct> expected = Arrays.asList(new FactAcct(acctNIR, acctAmount, null, 2, true, deliveryLine.get_ID()));
                this.assertFactAcctEntries(fas, expected);
                ++n4;
            }
        }
        finally {
            this.rollback();
            this.deleteConversionRate(crUsdCompany);
            this.deleteConversionRate(crEurCompany);
            pp.deleteEx(true);
            plv.deleteEx(true);
            priceList.deleteEx(true);
        }
    }

    private MConversionRate createConversionRate(int C_Currency_ID, int C_Currency_ID_To, int C_ConversionType_ID, Timestamp date, BigDecimal rate) {
        return this.createConversionRate(C_Currency_ID, C_Currency_ID_To, C_ConversionType_ID, date, rate, true);
    }

    private MConversionRate createConversionRate(int C_Currency_ID, int C_Currency_ID_To, int C_ConversionType_ID, Timestamp date, BigDecimal rate, boolean isMultiplyRate) {
        return ConversionRateHelper.createConversionRate(C_Currency_ID, C_Currency_ID_To, C_ConversionType_ID, date, rate, isMultiplyRate);
    }

    private void deleteConversionRate(MConversionRate cr) {
        ConversionRateHelper.deleteConversionRate(cr);
    }

    private MOrder createPurchaseOrder(MBPartner bpartner, Timestamp date, int M_PriceList_ID, int C_ConversionType_ID) {
        return this.createOrder(bpartner, date, M_PriceList_ID, C_ConversionType_ID, false);
    }

    private MOrder createSalseOrder(MBPartner bpartner, Timestamp date, int M_PriceList_ID, int C_ConversionType_ID) {
        return this.createOrder(bpartner, date, M_PriceList_ID, C_ConversionType_ID, true);
    }

    private MOrder createOrder(MBPartner bpartner, Timestamp date, int M_PriceList_ID, int C_ConversionType_ID, boolean isSOTrx) {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setAD_Org_ID(DictionaryIDs.AD_Org.HQ.id);
        order.setBPartner(bpartner);
        order.setIsSOTrx(isSOTrx);
        order.setC_DocTypeTarget_ID();
        order.setDateOrdered(date);
        order.setDateAcct(date);
        order.setM_PriceList_ID(M_PriceList_ID);
        order.setC_ConversionType_ID(C_ConversionType_ID);
        order.setM_Warehouse_ID(DictionaryIDs.M_Warehouse.HQ.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.saveEx();
        return order;
    }

    private MOrderLine createOrderLine(MOrder order, int line, MProduct product, BigDecimal qty, BigDecimal price) {
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(line);
        orderLine.setProduct(product);
        orderLine.setQty(qty);
        if (price != null) {
            orderLine.setPrice(price);
        } else {
            orderLine.setPrice();
        }
        orderLine.saveEx();
        return orderLine;
    }

    private MInOut createMMReceipt(MOrder order, Timestamp date) {
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, date);
        receipt.saveEx();
        return receipt;
    }

    private MInOut createShipment(MOrder order, Timestamp date) {
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_SHIPMENT.id, date);
        receipt.saveEx();
        return receipt;
    }

    private MInOutLine createInOutLine(MInOut mInOut, MOrderLine orderLine, BigDecimal qty) {
        MInOutLine receiptLine = new MInOutLine(mInOut);
        receiptLine.setC_OrderLine_ID(orderLine.get_ID());
        receiptLine.setLine(orderLine.getLine());
        receiptLine.setProduct(orderLine.getProduct());
        receiptLine.setQty(qty);
        MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)mInOut.getM_Warehouse_ID());
        int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        receiptLine.setM_Locator_ID(M_Locator_ID);
        receiptLine.saveEx();
        return receiptLine;
    }

    private void completeDocument(PO po) {
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)po, (String)"CO");
        po.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        String docStatus = (String)po.get_Value("DocStatus");
        Assertions.assertEquals((Object)"CO", (Object)docStatus, (String)("CO != " + docStatus));
    }

    private void postDocument(PO po) {
        if (!po.get_ValueAsBoolean("Posted")) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)po.getAD_Client_ID(), (int)po.get_Table_ID(), (int)po.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
        }
        po.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)po.get_ValueAsBoolean("Posted"));
    }

    private void repostDocument(PO po) {
        if (po.get_ValueAsBoolean("Posted")) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)po.getAD_Client_ID(), (int)po.get_Table_ID(), (int)po.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
        }
        po.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)po.get_ValueAsBoolean("Posted"));
    }

    @Test
    public void testFreightCostRuleCustomerAccount() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        X_M_ShippingProcessorCfg cfg = new X_M_ShippingProcessorCfg(Env.getCtx(), 0, this.getTrxName());
        cfg.setHostAddress("0.0.0.0");
        cfg.setName("Test Shipping Processor Config");
        cfg.setHostPort(0);
        cfg.saveEx();
        MShippingProcessor processor = new MShippingProcessor(Env.getCtx(), 0, this.getTrxName());
        processor.setM_ShippingProcessorCfg_ID(cfg.get_ID());
        processor.setUserID("-");
        processor.setConnectionPassword("-");
        processor.setName("Test Shipping Processor");
        processor.saveEx();
        MShipper shipper = new MShipper(Env.getCtx(), 0, this.getTrxName());
        shipper.setName("Test Shipper");
        shipper.setM_ShipperCfg_ID(cfg.get_ID());
        shipper.setM_ShippingProcessor_ID(processor.get_ID());
        shipper.saveEx();
        MBPartner bp = new MBPartner(Env.getCtx(), DictionaryIDs.C_BPartner.JOE_BLOCK.id, this.getTrxName());
        X_C_BP_ShippingAcct acct = new X_C_BP_ShippingAcct(Env.getCtx(), 0, this.getTrxName());
        acct.setC_BPartner_ID(bp.getC_BPartner_ID());
        acct.setShipperAccount("testFreightCostRuleCustomerAccount");
        acct.setM_ShippingProcessor_ID(processor.get_ID());
        acct.saveEx();
        MInOut inout = new MInOut(Env.getCtx(), 0, this.getTrxName());
        inout.setBPartner(bp);
        inout.setIsSOTrx(true);
        inout.setC_Order_ID(order.getC_Order_ID());
        inout.setM_Warehouse_ID(this.getM_Warehouse_ID());
        inout.setC_DocType_ID();
        inout.setDeliveryViaRule("S");
        inout.setM_Shipper_ID(shipper.get_ID());
        inout.setFreightCostRule("U");
        inout.saveEx();
        Assertions.assertEquals((Object)"testFreightCostRuleCustomerAccount", (Object)inout.getShipperAccount(), (String)"Unexpected shipper account");
        Assertions.assertEquals((Object)"A_Col", (Object)inout.getFreightCharges(), (String)"Unexpected freight charges rule");
    }

    @Test
    public void testCreditCheckInOut() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id, (String)this.getTrxName());
        bpartner.setSOCreditStatus("X");
        bpartner.saveEx();
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        MOrder order = this.createSalseOrder(bpartner, currentDate, DictionaryIDs.M_PriceList.STANDARD.id, DictionaryIDs.C_ConversionType.COMPANY.id);
        MOrderLine orderLine = this.createOrderLine(order, 10, product, new BigDecimal(500), new BigDecimal(23.32));
        this.completeDocument((PO)order);
        MInOut receipt = this.createShipment(order, currentDate);
        BigDecimal qtyDelivered = new BigDecimal(500);
        this.createInOutLine(receipt, orderLine, qtyDelivered);
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"PR");
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"IP", (Object)receipt.getDocStatus());
        bpartner.setSOCreditStatus("S");
        bpartner.saveEx();
        receipt.load(this.getTrxName(), new String[0]);
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"PR");
        Assertions.assertTrue((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"IN", (Object)receipt.getDocStatus());
        bpartner.setSOCreditStatus("H");
        bpartner.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"PR");
        Assertions.assertTrue((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"IN", (Object)receipt.getDocStatus());
    }

    @Test
    public void testShipmentRePosting() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        MBPartner vendor = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.SEED_FARM.id);
        MOrder purchaseOrder = this.createPurchaseOrder(vendor, currentDate, DictionaryIDs.M_PriceList.PURCHASE.id, DictionaryIDs.C_ConversionType.SPOT.id);
        MOrderLine poLine = this.createOrderLine(purchaseOrder, 10, product, new BigDecimal("1"), null);
        this.completeDocument((PO)purchaseOrder);
        MInOut receipt = this.createMMReceipt(purchaseOrder, currentDate);
        this.createInOutLine(receipt, poLine, new BigDecimal("1"));
        this.completeDocument((PO)receipt);
        MOrder order = this.createSalseOrder(bpartner, currentDate, DictionaryIDs.M_PriceList.STANDARD.id, DictionaryIDs.C_ConversionType.SPOT.id);
        int plv = MPriceList.get((int)DictionaryIDs.M_PriceList.STANDARD.id).getPriceListVersion(currentDate).get_ID();
        BigDecimal price = MProductPrice.get((Properties)Env.getCtx(), (int)plv, (int)product.get_ID(), (String)this.getTrxName()).getPriceStd();
        MOrderLine orderLine = this.createOrderLine(order, 10, product, new BigDecimal("1"), price);
        this.completeDocument((PO)order);
        MInOut delivery = this.createShipment(order, currentDate);
        MInOutLine deliveryLine = this.createInOutLine(delivery, orderLine, new BigDecimal("1"));
        this.completeDocument((PO)delivery);
        this.postDocument((PO)delivery);
        ProductCost pc = new ProductCost(Env.getCtx(), deliveryLine.getM_Product_ID(), deliveryLine.getM_AttributeSetInstance_ID(), this.getTrxName());
        MAcctSchema as = MClient.get((Properties)Env.getCtx()).getAcctSchema();
        MAccount cogs = pc.getAccount(4, as);
        MAccount asset = pc.getAccount(3, as);
        Query query = MFactAcct.createRecordIdQuery((int)319, (int)delivery.get_ID(), (int)as.getC_AcctSchema_ID(), (String)this.getTrxName());
        List fas = query.list();
        Assertions.assertTrue((fas.size() > 0 ? 1 : 0) != 0, (String)"Failed to retrieve fact posting entries for shipment document");
        boolean cogsFound = false;
        boolean assetFound = false;
        for (MFactAcct fa : fas) {
            if (cogs.getAccount_ID() == fa.getAccount_ID()) {
                if (deliveryLine.get_ID() == fa.getLine_ID()) {
                    Assertions.assertEquals((Object)fa.getAmtSourceDr().abs().toPlainString(), (Object)fa.getAmtSourceDr().toPlainString(), (String)"Not DR COGS");
                    Assertions.assertTrue((fa.getAmtSourceDr().signum() > 0 ? 1 : 0) != 0, (String)"Not DR COGS");
                }
                cogsFound = true;
                continue;
            }
            if (asset.getAccount_ID() != fa.getAccount_ID()) continue;
            if (deliveryLine.get_ID() == fa.getLine_ID()) {
                Assertions.assertEquals((Object)fa.getAmtSourceCr().abs().toPlainString(), (Object)fa.getAmtSourceCr().toPlainString(), (String)"Not CR Product Asset");
                Assertions.assertTrue((fa.getAmtSourceCr().signum() > 0 ? 1 : 0) != 0, (String)"Not CR Product Asset");
            }
            assetFound = true;
        }
        Assertions.assertTrue((boolean)cogsFound, (String)"No COGS posting found");
        Assertions.assertTrue((boolean)assetFound, (String)"No Product Asset posting found");
        this.repostDocument((PO)delivery);
        fas = query.list();
        cogsFound = false;
        assetFound = false;
        for (MFactAcct fa : fas) {
            if (cogs.getAccount_ID() == fa.getAccount_ID()) {
                if (deliveryLine.get_ID() == fa.getLine_ID()) {
                    Assertions.assertEquals((Object)fa.getAmtSourceDr().abs().toPlainString(), (Object)fa.getAmtSourceDr().toPlainString(), (String)"Not DR COGS");
                    Assertions.assertTrue((fa.getAmtSourceDr().signum() > 0 ? 1 : 0) != 0, (String)"Not DR COGS");
                }
                cogsFound = true;
                continue;
            }
            if (asset.getAccount_ID() != fa.getAccount_ID()) continue;
            if (deliveryLine.get_ID() == fa.getLine_ID()) {
                Assertions.assertEquals((Object)fa.getAmtSourceCr().abs().toPlainString(), (Object)fa.getAmtSourceCr().toPlainString(), (String)"Not CR Product Asset");
                Assertions.assertTrue((fa.getAmtSourceCr().signum() > 0 ? 1 : 0) != 0, (String)"Not CR Product Asset");
            }
            assetFound = true;
        }
        Assertions.assertTrue((boolean)cogsFound, (String)"No COGS posting found");
        Assertions.assertTrue((boolean)assetFound, (String)"No Product Asset posting found");
    }
}

