/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.logging.LogRecord;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutConfirm;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInOutLineConfirm;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MPayment;
import org.compiere.model.MProduct;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MTax;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.X_C_BP_Relation;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.CLogErrorBuffer;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class InvoiceCustomerTest
extends AbstractTestCase {
    static final BigDecimal TWOHUNDRED = new BigDecimal("200");

    @Test
    public void testOpenAmt() {
        int severeCount = 0;
        LogRecord[] errorLogs = CLogErrorBuffer.get((boolean)true).getRecords(true);
        if (errorLogs != null) {
            severeCount = errorLogs.length;
        }
        MBPartner bp = new MBPartner(Env.getCtx(), DictionaryIDs.C_BPartner.C_AND_W.id, this.getTrxName());
        DB.getDatabase().forUpdate((PO)bp, 0);
        MInvoice invoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
        invoice.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.C_AND_W.id));
        invoice.setC_DocTypeTarget_ID("ARI");
        invoice.setC_DocType_ID(invoice.getC_DocTypeTarget_ID());
        invoice.setPaymentRule("S");
        invoice.setC_PaymentTerm_ID(DictionaryIDs.C_PaymentTerm.IMMEDIATE.id);
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        invoice.setDateInvoiced(today);
        invoice.setDateAcct(today);
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine line1 = new MInvoiceLine(invoice);
        line1.setLine(10);
        line1.setC_Charge_ID(DictionaryIDs.C_Charge.BANK.id);
        line1.setQty(new BigDecimal("1"));
        line1.setPrice(Env.ONEHUNDRED);
        line1.saveEx();
        MInvoiceLine line2 = new MInvoiceLine(invoice);
        line2.setLine(20);
        line2.setC_Charge_ID(DictionaryIDs.C_Charge.COMMISSIONS.id);
        line2.setQty(new BigDecimal("1"));
        line2.setPrice(Env.ONEHUNDRED);
        line2.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)("Error processing invoice: " + info.getSummary()));
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus(), (String)("Invoice document status is not completed: " + invoice.getDocStatus()));
        Assertions.assertTrue((TWOHUNDRED.compareTo(invoice.getGrandTotal()) == 0 ? 1 : 0) != 0, (String)("Invoice grand total not as expected: " + invoice.getGrandTotal().toPlainString()));
        Assertions.assertTrue((boolean)invoice.isPosted(), (String)"Invoice not posted");
        MPayment payment1 = new MPayment(Env.getCtx(), 0, this.getTrxName());
        payment1.setC_Invoice_ID(invoice.getC_Invoice_ID());
        payment1.setC_BPartner_ID(invoice.getC_BPartner_ID());
        payment1.setC_DocType_ID(true);
        payment1.setDocStatus("DR");
        payment1.setDocAction("CO");
        payment1.setPayAmt(Env.ONEHUNDRED);
        payment1.setTenderType("K");
        payment1.setC_BankAccount_ID(DictionaryIDs.C_BankAccount.ACCOUNT_1234.id);
        payment1.setC_Currency_ID(DictionaryIDs.C_Currency.USD.id);
        Timestamp nextweek = TimeUtil.addDays((Timestamp)today, (int)7);
        payment1.setDateTrx(nextweek);
        payment1.setDateAcct(nextweek);
        payment1.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)payment1, (String)"CO");
        payment1.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)("Error processing payment: " + info.getSummary()));
        Assertions.assertEquals((Object)"CO", (Object)payment1.getDocStatus(), (String)("Payment document status is not completed: " + payment1.getDocStatus()));
        Assertions.assertEquals((Object)false, (Object)invoice.isPaid(), (String)"Invoice isPaid() is not false");
        Assertions.assertTrue((boolean)payment1.isPosted(), (String)"Payment not posted");
        List postProcessDocs = payment1.getDocsPostProcess();
        for (PO postProcessDoc : postProcessDocs) {
            Assertions.assertTrue((boolean)postProcessDoc.get_ValueAsBoolean("Posted"), (String)("Post Process Doc not posted: " + String.valueOf(postProcessDoc)));
        }
        MPayment payment2 = new MPayment(Env.getCtx(), 0, this.getTrxName());
        payment2.setC_Invoice_ID(invoice.getC_Invoice_ID());
        payment2.setC_BPartner_ID(invoice.getC_BPartner_ID());
        payment2.setC_DocType_ID(true);
        payment2.setDocStatus("DR");
        payment2.setDocAction("CO");
        payment2.setPayAmt(Env.ONEHUNDRED);
        payment2.setTenderType("K");
        payment2.setC_BankAccount_ID(DictionaryIDs.C_BankAccount.ACCOUNT_1234.id);
        payment2.setC_Currency_ID(DictionaryIDs.C_Currency.USD.id);
        Timestamp next2weeks = TimeUtil.addDays((Timestamp)today, (int)14);
        payment2.setDateTrx(next2weeks);
        payment2.setDateAcct(next2weeks);
        payment2.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)payment2, (String)"CO");
        payment2.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)("Error processing payment: " + info.getSummary()));
        Assertions.assertEquals((Object)"CO", (Object)payment2.getDocStatus(), (String)("Payment document status is not completed: " + payment2.getDocStatus()));
        Assertions.assertTrue((boolean)payment2.isPosted(), (String)"Payment not posted");
        postProcessDocs = payment2.getDocsPostProcess();
        for (PO postProcessDoc : postProcessDocs) {
            Assertions.assertTrue((boolean)postProcessDoc.get_ValueAsBoolean("Posted"), (String)("Post Process Doc not posted: " + String.valueOf(postProcessDoc)));
        }
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)true, (Object)invoice.isPaid(), (String)"Invoice isPaid() is not true");
        Assertions.assertTrue((Env.ZERO.compareTo(invoice.getOpenAmt()) == 0 ? 1 : 0) != 0, (String)("Invoice open amount not zero: " + invoice.getOpenAmt().toPlainString()));
        Assertions.assertTrue((TWOHUNDRED.compareTo(invoice.getOpenAmt(false, today, true)) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((Env.ONEHUNDRED.compareTo(invoice.getOpenAmt(false, nextweek, true)) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((Env.ZERO.compareTo(invoice.getOpenAmt(false, next2weeks, true)) == 0 ? 1 : 0) != 0);
        errorLogs = CLogErrorBuffer.get((boolean)true).getRecords(true);
        if (errorLogs != null) {
            Assertions.assertEquals((int)severeCount, (int)errorLogs.length, (String)("Severe errors recorded in log: " + errorLogs.length));
        }
        this.rollback();
    }

    @Test
    public void testGenerateInvoiceManual() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)line1.getQtyReserved().intValue());
        Assertions.assertEquals((int)0, (int)line1.getQtyInvoiced().intValue());
        int AD_Process_ID = 134;
        MPInstance instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0, 0, null);
        instance.saveEx();
        String insert = "INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) Values (?, ?)";
        DB.executeUpdateEx((String)insert, (Object[])new Object[]{instance.getAD_PInstance_ID(), order.getC_Order_ID()}, null);
        ProcessInfo pi = new ProcessInfo("InvoiceGenerateManual", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        MPInstancePara ip = new MPInstancePara(instance, 10);
        ip.setParameter("Selection", "Y");
        ip.saveEx();
        ip = new MPInstancePara(instance, 20);
        ip.setParameter("DocAction", "CO");
        ip.saveEx();
        ServerProcessCtl processCtl = new ServerProcessCtl(pi, this.getTrx());
        processCtl.setManagedTrxForJavaProcess(false);
        processCtl.run();
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)line1.getQtyReserved().intValue());
        Assertions.assertEquals((int)1, (int)line1.getQtyInvoiced().intValue());
    }

    @Test
    public void testGenerateInvoiceManualForPartialConfirm() {
        MDocType shipmentDocType = MDocType.get((int)DictionaryIDs.C_DocType.MM_SHIPMENT.id);
        MDocType docType = new MDocType(Env.getCtx(), 0, null);
        PO.copyValues((PO)shipmentDocType, (PO)docType);
        docType.setName(shipmentDocType.getName() + " " + System.currentTimeMillis());
        docType.setIsShipConfirm(true);
        docType.saveEx();
        try {
            MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
            order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
            order.setC_DocTypeTarget_ID("SO");
            order.setDeliveryRule("A");
            order.setInvoiceRule("D");
            order.setDocStatus("DR");
            order.setDocAction("CO");
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            order.setDateOrdered(today);
            order.setDatePromised(today);
            order.saveEx();
            MOrderLine orderLine = new MOrderLine(order);
            orderLine.setLine(10);
            orderLine.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.MULCH.id));
            BigDecimal orderQty = new BigDecimal("3");
            orderLine.setQty(orderQty);
            orderLine.setDatePromised(today);
            orderLine.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            order.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
            orderLine.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((int)orderQty.intValue(), (int)orderLine.getQtyReserved().intValue());
            Assertions.assertEquals((int)0, (int)orderLine.getQtyInvoiced().intValue());
            MInOut shipment = new MInOut(order, docType.get_ID(), today);
            shipment.saveEx();
            MInOutLine shipmentLine = new MInOutLine(shipment);
            shipmentLine.setC_OrderLine_ID(orderLine.get_ID());
            shipmentLine.setLine(orderLine.getLine());
            shipmentLine.setProduct(orderLine.getProduct());
            shipmentLine.setQty(orderLine.getQtyEntered());
            MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)shipment.getM_Warehouse_ID());
            int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
            shipmentLine.setM_Locator_ID(M_Locator_ID);
            shipmentLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            shipment.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"IP", (Object)shipment.getDocStatus());
            MInOutConfirm[] confirmations = shipment.getConfirmations(true);
            Assertions.assertEquals((int)1, (int)confirmations.length, (String)"Unexpected number of shipment confirmation records");
            MInOutLineConfirm[] confirmationLines = confirmations[0].getLines(true);
            Assertions.assertEquals((int)1, (int)confirmationLines.length, (String)"Unexpected number of shipment confirmation lines");
            BigDecimal confirmedQty = new BigDecimal("1");
            confirmationLines[0].setConfirmedQty(confirmedQty);
            confirmationLines[0].saveEx();
            Assertions.assertEquals((int)2, (int)confirmationLines[0].getDifferenceQty().intValue(), (String)"Unexpected confirmation line difference quantity");
            info = MWorkflow.runDocumentActionWorkflow((PO)confirmations[0], (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            confirmations[0].load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)confirmations[0].getDocStatus());
            shipment.load(this.getTrxName(), new String[0]);
            info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            shipment.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus());
            shipmentLine.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((int)confirmedQty.intValue(), (int)shipmentLine.getMovementQty().intValue(), (String)"Unexpected shipment line movement quantity");
            Assertions.assertEquals((int)orderQty.intValue(), (int)shipmentLine.getTargetQty().intValue(), (String)"Unexpected shipment line target quantity");
            Assertions.assertEquals((int)orderQty.intValue(), (int)shipmentLine.getQtyEntered().intValue(), (String)"Unexpected shipment line entered quantity");
            int AD_Process_ID = 134;
            MPInstance instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0, 0, null);
            instance.saveEx();
            String insert = "INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) Values (?, ?)";
            DB.executeUpdateEx((String)insert, (Object[])new Object[]{instance.getAD_PInstance_ID(), order.getC_Order_ID()}, null);
            ProcessInfo pi = new ProcessInfo("InvoiceGenerateManual", AD_Process_ID);
            pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
            MPInstancePara ip = new MPInstancePara(instance, 10);
            ip.setParameter("Selection", "Y");
            ip.saveEx();
            ip = new MPInstancePara(instance, 20);
            ip.setParameter("DocAction", "CO");
            ip.saveEx();
            ServerProcessCtl processCtl = new ServerProcessCtl(pi, this.getTrx());
            processCtl.setManagedTrxForJavaProcess(false);
            processCtl.run();
            Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
            orderLine.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((int)1, (int)orderLine.getQtyInvoiced().intValue());
            MInvoiceLine invoiceLine = MInvoiceLine.getOfInOutLine((MInOutLine)shipmentLine);
            Assertions.assertTrue((invoiceLine != null && invoiceLine.get_ID() > 0 ? 1 : 0) != 0, (String)"No invoice line created for shipment line");
            Assertions.assertEquals((int)confirmedQty.intValue(), (int)invoiceLine.getQtyEntered().intValue(), (String)"Unexpected invoice line quantity entered");
            Assertions.assertEquals((int)confirmedQty.intValue(), (int)invoiceLine.getQtyInvoiced().intValue(), (String)"Unexpected invoice line quantity invoiced");
            Assertions.assertEquals((Object)orderLine.getPriceActual().setScale(2, RoundingMode.HALF_UP), (Object)invoiceLine.getLineNetAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected invoice line total amount");
        }
        finally {
            this.rollback();
            if (docType.get_ID() > 0) {
                docType.deleteEx(true);
            }
        }
    }

    @Test
    public void testInvoiceGenerateRMAManual() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.setSalesRep_ID(this.getAD_User_ID());
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)line1.getQtyReserved().intValue());
        MInOut shipment = new MInOut(order, DictionaryIDs.C_DocType.MM_SHIPMENT.id, order.getDateOrdered());
        shipment.setDocStatus("DR");
        shipment.setDocAction("CO");
        shipment.saveEx();
        MInOutLine shipmentLine = new MInOutLine(shipment);
        shipmentLine.setOrderLine(line1, 0, new BigDecimal("1"));
        shipmentLine.setQty(new BigDecimal("1"));
        shipmentLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus());
        MInvoice invoice = new MInvoice(shipment, today);
        invoice.saveEx();
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setShipLine(shipmentLine);
        invoiceLine.setQty(new BigDecimal("1"));
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().intValue());
        Assertions.assertEquals((int)1, (int)line1.getQtyDelivered().intValue());
        Assertions.assertEquals((int)1, (int)line1.getQtyInvoiced().intValue());
        MRMA rma = new MRMA(Env.getCtx(), 0, this.getTrxName());
        rma.setInOut_ID(shipment.get_ID());
        rma.setC_BPartner_ID(shipment.getC_BPartner_ID());
        rma.setC_Currency_ID(order.getC_Currency_ID());
        rma.setM_RMAType_ID(DictionaryIDs.M_RMAType.DAMAGE_ON_ARRIVAL.id);
        rma.setC_DocType_ID(DictionaryIDs.C_DocType.CUSTOMER_RETURN_MATERIAL.id);
        rma.setSalesRep_ID(order.getSalesRep_ID());
        rma.setIsSOTrx(true);
        rma.setName("testInvoiceGenerateRMAManual");
        rma.saveEx();
        MRMALine rmaLine = new MRMALine(Env.getCtx(), 0, this.getTrxName());
        rmaLine.setM_RMA_ID(rma.get_ID());
        rmaLine.setM_InOutLine_ID(shipmentLine.get_ID());
        rmaLine.setM_Product_ID(shipmentLine.getM_Product_ID());
        rmaLine.setQty(new BigDecimal("1"));
        rmaLine.saveEx();
        Assertions.assertEquals((int)0, (int)rmaLine.getQtyInvoiced().intValue());
        info = MWorkflow.runDocumentActionWorkflow((PO)rma, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        rma.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)rma.getDocStatus());
        int AD_Process_ID = 52002;
        MPInstance instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0, 0, null);
        instance.saveEx();
        String insert = "INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) Values (?, ?)";
        DB.executeUpdateEx((String)insert, (Object[])new Object[]{instance.getAD_PInstance_ID(), rma.get_ID()}, null);
        ProcessInfo pi = new ProcessInfo("InvoiceGenerateRMAManual", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        MPInstancePara ip = new MPInstancePara(instance, 10);
        ip.setParameter("Selection", "Y");
        ip.saveEx();
        ip = new MPInstancePara(instance, 20);
        ip.setParameter("DocAction", "CO");
        ip.saveEx();
        ServerProcessCtl processCtl = new ServerProcessCtl(pi, this.getTrx());
        processCtl.setManagedTrxForJavaProcess(false);
        processCtl.run();
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        rmaLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)rmaLine.getQtyInvoiced().intValue());
    }

    @Test
    public void testGenerateInvoiceRelatedBP() {
        X_C_BP_Relation bpr = new X_C_BP_Relation(Env.getCtx(), 0, this.getTrxName());
        bpr.setName("C&W may pay invoices for Seed");
        bpr.setC_BPartner_ID(DictionaryIDs.C_BPartner.SEED_FARM.id);
        bpr.setC_BPartnerRelation_ID(DictionaryIDs.C_BPartner.C_AND_W.id);
        bpr.setC_BPartnerRelation_Location_ID(DictionaryIDs.C_BPartner_Location.C_AND_W_STAMFORD.id);
        bpr.setIsBillTo(true);
        bpr.setIsRemitTo(true);
        bpr.saveEx();
        MOrder order1 = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order1.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order1.setC_DocTypeTarget_ID("SO");
        order1.setDeliveryRule("O");
        order1.setInvoiceRule("I");
        order1.setDocStatus("DR");
        order1.setDocAction("CO");
        order1.setBill_BPartner_ID(DictionaryIDs.C_BPartner.C_AND_W.id);
        order1.setBill_Location_ID(DictionaryIDs.C_BPartner_Location.C_AND_W_STAMFORD.id);
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order1.setDateOrdered(today);
        order1.setDatePromised(today);
        order1.saveEx();
        MOrderLine line1 = new MOrderLine(order1);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.SEEDER.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info1 = MWorkflow.runDocumentActionWorkflow((PO)order1, (String)"CO");
        Assertions.assertFalse((boolean)info1.isError(), (String)info1.getSummary());
        order1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order1.getDocStatus());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)line1.getQtyReserved().intValue());
        Assertions.assertEquals((int)0, (int)line1.getQtyInvoiced().intValue());
        MOrder order2 = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order2.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.SEED_FARM.id));
        order2.setC_DocTypeTarget_ID("SO");
        order2.setDeliveryRule("O");
        order2.setInvoiceRule("I");
        order2.setDocStatus("DR");
        order2.setDocAction("CO");
        order2.setBill_BPartner_ID(DictionaryIDs.C_BPartner.C_AND_W.id);
        order2.setBill_Location_ID(DictionaryIDs.C_BPartner_Location.C_AND_W_STAMFORD.id);
        order2.setDateOrdered(today);
        order2.setDatePromised(today);
        order2.saveEx();
        MOrderLine line2 = new MOrderLine(order2);
        line2.setLine(10);
        line2.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.WEEDER.id));
        line2.setQty(new BigDecimal("1"));
        line2.setDatePromised(today);
        line2.saveEx();
        ProcessInfo info2 = MWorkflow.runDocumentActionWorkflow((PO)order2, (String)"CO");
        Assertions.assertFalse((boolean)info2.isError(), (String)info2.getSummary());
        order2.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order2.getDocStatus());
        line2.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)line2.getQtyReserved().intValue());
        Assertions.assertEquals((int)0, (int)line2.getQtyInvoiced().intValue());
        int AD_Process_ID = 119;
        MPInstance instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0, 0, null);
        instance.saveEx();
        ProcessInfo pi = new ProcessInfo("InvoiceGenerate", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        MPInstancePara ip = new MPInstancePara(instance, 10);
        ip.setParameter("DateInvoiced", today);
        ip.saveEx();
        ip = new MPInstancePara(instance, 20);
        ip.setParameter("AD_Org_ID", DictionaryIDs.AD_Org.HQ.id);
        ip.saveEx();
        ip = new MPInstancePara(instance, 50);
        ip.setParameter("DocAction", "PR");
        ip.saveEx();
        ip = new MPInstancePara(instance, 60);
        ip.setParameter("ConsolidateDocument", true);
        ip.saveEx();
        ServerProcessCtl processCtl = new ServerProcessCtl(pi, this.getTrx());
        processCtl.setManagedTrxForJavaProcess(false);
        processCtl.run();
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        Assertions.assertEquals((Object)pi.getSummary(), (Object)"Created = 2");
    }

    @Test
    public void testInvoiceWithParentTax() {
        MInvoice invoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
        MBPartner bp = new MBPartner(Env.getCtx(), DictionaryIDs.C_BPartner.C_AND_W.id, this.getTrxName());
        DB.getDatabase().forUpdate((PO)bp, 0);
        invoice.setBPartner(bp);
        invoice.setIsSOTrx(true);
        invoice.setC_DocTypeTarget_ID();
        invoice.saveEx();
        MInvoiceLine line = new MInvoiceLine(invoice);
        line.setM_Product_ID(DictionaryIDs.M_Product.AZALEA_BUSH.id);
        line.setQty(new BigDecimal("1"));
        line.setC_Tax_ID(DictionaryIDs.C_Tax.GST_PST.id);
        line.saveEx();
        MTax tax = new MTax(Env.getCtx(), line.getC_Tax_ID(), null);
        MTax[] childs = tax.getChildTaxes(true);
        MInvoiceTax[] invoiceTaxes = invoice.getTaxes(true);
        Assertions.assertEquals((int)childs.length, (int)invoiceTaxes.length, (String)"Unexpected number of MInvoiceTax records");
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        invoiceTaxes = invoice.getTaxes(true);
        Assertions.assertEquals((int)childs.length, (int)invoiceTaxes.length, (String)"Unexpected number of MInvoiceTax records");
        int match = 0;
        MInvoiceTax[] mInvoiceTaxArray = invoiceTaxes;
        int n = invoiceTaxes.length;
        int n2 = 0;
        while (n2 < n) {
            MInvoiceTax invoiceTax = mInvoiceTaxArray[n2];
            MTax[] mTaxArray = childs;
            int n3 = childs.length;
            int n4 = 0;
            while (n4 < n3) {
                MTax c = mTaxArray[n4];
                if (c.getC_Tax_ID() == invoiceTax.getC_Tax_ID()) {
                    ++match;
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        Assertions.assertEquals((int)invoiceTaxes.length, (int)match, (String)"MInvoiceTax record doesn't match child tax records");
    }

    @Test
    public void testInvoiceGenerateRMAManualDateInvoiced() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, -2);
        Timestamp date1 = new Timestamp(cal.getTimeInMillis());
        cal.setTimeInMillis(currentDate.getTime());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, -1);
        Timestamp date2 = new Timestamp(cal.getTimeInMillis());
        order.setDateOrdered(date1);
        order.setDatePromised(date1);
        order.setSalesRep_ID(this.getAD_User_ID());
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(date1);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)line1.getQtyReserved().intValue());
        MInOut shipment = new MInOut(order, DictionaryIDs.C_DocType.MM_SHIPMENT.id, order.getDateOrdered());
        shipment.setDocStatus("DR");
        shipment.setDocAction("CO");
        shipment.saveEx();
        MInOutLine shipmentLine = new MInOutLine(shipment);
        shipmentLine.setOrderLine(line1, 0, new BigDecimal("1"));
        shipmentLine.setQty(new BigDecimal("1"));
        shipmentLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus());
        MInvoice invoice = new MInvoice(shipment, date1);
        invoice.saveEx();
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setShipLine(shipmentLine);
        invoiceLine.setQty(new BigDecimal("1"));
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().intValue());
        Assertions.assertEquals((int)1, (int)line1.getQtyDelivered().intValue());
        Assertions.assertEquals((int)1, (int)line1.getQtyInvoiced().intValue());
        MRMA rma = new MRMA(Env.getCtx(), 0, this.getTrxName());
        rma.setInOut_ID(shipment.get_ID());
        rma.setC_BPartner_ID(shipment.getC_BPartner_ID());
        rma.setC_Currency_ID(order.getC_Currency_ID());
        rma.setM_RMAType_ID(DictionaryIDs.M_RMAType.DAMAGE_ON_ARRIVAL.id);
        rma.setC_DocType_ID(DictionaryIDs.C_DocType.CUSTOMER_RETURN_MATERIAL.id);
        rma.setSalesRep_ID(order.getSalesRep_ID());
        rma.setIsSOTrx(true);
        rma.setName("testInvoiceGenerateRMAManualDateInvoiced");
        rma.saveEx();
        MRMALine rmaLine = new MRMALine(Env.getCtx(), 0, this.getTrxName());
        rmaLine.setM_RMA_ID(rma.get_ID());
        rmaLine.setM_InOutLine_ID(shipmentLine.get_ID());
        rmaLine.setM_Product_ID(shipmentLine.getM_Product_ID());
        rmaLine.setQty(new BigDecimal("1"));
        rmaLine.saveEx();
        Assertions.assertEquals((int)0, (int)rmaLine.getQtyInvoiced().intValue());
        info = MWorkflow.runDocumentActionWorkflow((PO)rma, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        rma.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)rma.getDocStatus());
        int AD_Process_ID = 52002;
        MPInstance instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0, 0, null);
        instance.saveEx();
        String insert = "INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) Values (?, ?)";
        DB.executeUpdateEx((String)insert, (Object[])new Object[]{instance.getAD_PInstance_ID(), rma.get_ID()}, null);
        ProcessInfo pi = new ProcessInfo("InvoiceGenerateRMAManual", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        MPInstancePara ip = new MPInstancePara(instance, 10);
        ip.setParameter("Selection", "Y");
        ip.saveEx();
        ip = new MPInstancePara(instance, 20);
        ip.setParameter("DocAction", "CO");
        ip.saveEx();
        ip = new MPInstancePara(instance, 30);
        ip.setParameter("DateInvoiced", date2);
        ip.saveEx();
        ServerProcessCtl processCtl = new ServerProcessCtl(pi, this.getTrx());
        processCtl.setManagedTrxForJavaProcess(false);
        processCtl.run();
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        rmaLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)rmaLine.getQtyInvoiced().intValue());
        int C_Invoice_ID = DB.getSQLValueEx((String)this.getTrxName(), (String)"SELECT C_Invoice_ID FROM C_Invoice WHERE M_RMA_ID=?", (Object[])new Object[]{rma.getM_RMA_ID()});
        MInvoice creditMemo = new MInvoice(Env.getCtx(), C_Invoice_ID, this.getTrxName());
        Assertions.assertEquals((Object)date2, (Object)creditMemo.getDateInvoiced());
        Assertions.assertEquals((Object)date2, (Object)creditMemo.getDateAcct());
    }
}

