/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.form;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Vector;
import org.compiere.grid.CreateFromStatement;
import org.compiere.minigrid.IMiniTable;
import org.compiere.minigrid.MiniTableImpl;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindow;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MPayment;
import org.compiere.model.MQuery;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CreateFromStatementFormTest
extends AbstractTestCase {
    @Test
    public void testCreateFromPayments() {
        MPayment payment = new MPayment(Env.getCtx(), 0, this.getTrxName());
        payment.setC_DocType_ID(true);
        payment.setC_BPartner_ID(DictionaryIDs.C_BPartner.JOE_BLOCK.id);
        payment.setTenderType("D");
        int C_BankAccount_ID = DB.getSQLValueEx((String)this.getTrxName(), (String)"SELECT C_BankAccount_ID FROM C_BankAccount WHERE IsActive='Y' AND AD_Client_ID=? AND IsDefault='Y' ORDER BY C_BankAccount_ID", (Object[])new Object[]{this.getAD_Client_ID()});
        payment.setC_BankAccount_ID(C_BankAccount_ID);
        payment.setC_Currency_ID(Env.getContextAsInt((Properties)Env.getCtx(), (String)"$C_Currency_ID"));
        payment.setPayAmt(new BigDecimal("10.00"));
        payment.saveEx();
        ProcessInfo pi = MWorkflow.runDocumentActionWorkflow((PO)payment, (String)"CO");
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        payment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)payment.getDocStatus(), (String)"Unexpected document status");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        MBankStatement stmt = new MBankStatement(Env.getCtx(), 0, this.getTrxName());
        stmt.setC_BankAccount_ID(C_BankAccount_ID);
        stmt.setDateAcct(today);
        stmt.setName("testCreateFromPayments");
        stmt.setStatementDate(today);
        stmt.saveEx();
        GridWindow gridWindow = GridWindow.get((Properties)Env.getCtx(), (int)1, (int)194);
        Assertions.assertNotNull((Object)gridWindow, (String)"Failed to load grid window of Bank Statement");
        gridWindow.initTab(0);
        GridTab gridTab = gridWindow.getTab(0);
        MQuery query = new MQuery("C_BankStatement");
        query.addRestriction("C_BankStatement_ID", "=", stmt.get_ID());
        gridTab.setQuery(query);
        gridTab.getTableModel().setImportingMode(false, this.getTrxName());
        gridTab.query(false);
        Assertions.assertEquals((int)1, (int)gridTab.getRowCount(), (String)"Unexpected number of row retrieve from DB");
        Assertions.assertEquals((int)stmt.get_ID(), (int)gridTab.getRecord_ID(), (String)"Wrong Bank Statement record id");
        CreateFromStatementImpl form = new CreateFromStatementImpl(gridTab);
        form.setTrxName(this.getTrxName());
        Timestamp dateFrom = TimeUtil.addDays((Timestamp)today, (int)-1);
        Timestamp dateTo = TimeUtil.addDays((Timestamp)today, (int)1);
        form.loadPayments(C_BankAccount_ID, null, null, dateFrom, dateTo, null, null, payment.getC_DocType_ID(), null, null);
        Assertions.assertTrue((form.minitable.getRowCount() > 0 ? 1 : 0) != 0, (String)"Failed to load data from DB");
        form.minitable.setSelectedRow(-1);
        int i = 0;
        while (i < form.minitable.getRowCount()) {
            KeyNamePair pp = (KeyNamePair)form.minitable.getValueAt(i, 2);
            if (pp.getKey() == payment.get_ID()) {
                form.minitable.setValueAt((Object)Boolean.TRUE, i, 0);
                form.minitable.setSelectedRow(i);
                break;
            }
            ++i;
        }
        Assertions.assertTrue((form.minitable.getSelectedRow() >= 0 ? 1 : 0) != 0, (String)"Failed to find payment record");
        Assertions.assertTrue((boolean)form.save((IMiniTable)form.minitable, this.getTrxName()), (String)"Failed to save changes");
        stmt.load(this.getTrxName(), new String[0]);
        MBankStatementLine[] lines = stmt.getLines(true);
        Assertions.assertNotNull((Object)lines, (String)"Null bank statement line");
        Assertions.assertEquals((int)1, (int)lines.length, (String)"Unexpected number of bank statement line records");
        Assertions.assertEquals((int)payment.get_ID(), (int)lines[0].getC_Payment_ID());
    }

    private static class CreateFromStatementImpl
    extends CreateFromStatement {
        private MiniTableImpl minitable = null;

        public CreateFromStatementImpl(GridTab mTab) {
            super(mTab);
            try {
                this.dynInit();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public Object getWindow() {
            return null;
        }

        protected boolean dynInit() throws Exception {
            super.dynInit();
            this.minitable = new MiniTableImpl();
            for (String column : this.getOISColumnNames()) {
                this.minitable.addColumn(column);
            }
            this.configureMiniTable((IMiniTable)this.minitable);
            return true;
        }

        public void loadPayments(Integer BankAccount, Integer BPartner, String DocumentNo, Timestamp DateFrom, Timestamp DateTo, BigDecimal AmtFrom, BigDecimal AmtTo, Integer DocType, String TenderType, String AuthCode) {
            Vector datas = super.getBankAccountData(BankAccount, BPartner, DocumentNo, DateFrom, DateTo, AmtFrom, AmtTo, DocType, TenderType, AuthCode);
            int i = 0;
            while (i < datas.size()) {
                this.minitable.setRowCount(i + 1);
                Vector data = (Vector)datas.get(i);
                int j = 0;
                while (j < data.size()) {
                    this.minitable.setValueAt(data.get(j), i, j);
                    ++j;
                }
                ++i;
            }
        }
    }
}

