/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.MPayment;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PaymentTest
extends AbstractTestCase {
    @Test
    public void testClearCreditCardFields() {
        MPayment payment = new MPayment(Env.getCtx(), 0, this.getTrxName());
        payment.setC_DocType_ID(true);
        payment.setC_BPartner_ID(DictionaryIDs.C_BPartner.JOE_BLOCK.id);
        payment.setTenderType("C");
        payment.setCreditCard("S", "M", "5555555555554444", "123", "0122");
        int C_BankAccount_ID = DB.getSQLValueEx((String)this.getTrxName(), (String)"SELECT C_BankAccount_ID FROM C_BankAccount WHERE IsActive='Y' AND AD_Client_ID=? AND IsDefault='Y' ORDER BY C_BankAccount_ID", (Object[])new Object[]{this.getAD_Client_ID()});
        payment.setC_BankAccount_ID(C_BankAccount_ID);
        payment.setC_Currency_ID(Env.getContextAsInt((Properties)Env.getCtx(), (String)"$C_Currency_ID"));
        payment.saveEx();
        Assertions.assertEquals((Object)"123", (Object)payment.getCreditCardVV());
        payment.setTenderType("K");
        payment.saveEx();
        Assertions.assertTrue((boolean)Util.isEmpty((String)payment.getCreditCardVV()), (String)("Credit card verification code not clear after change of tender type: " + payment.getCreditCardVV()));
    }

    @Test
    public void testCreditCheckPayment() {
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        MBPartner bp = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id, (String)this.getTrxName());
        bp.setSOCreditStatus("S");
        bp.saveEx();
        MPayment payment = new MPayment(Env.getCtx(), 0, this.getTrxName());
        payment.setC_BPartner_ID(bp.getC_BPartner_ID());
        payment.setC_BankAccount_ID(DictionaryIDs.C_BankAccount.HQ_POS_CASH.id);
        payment.setC_Currency_ID(DictionaryIDs.C_Currency.USD.id);
        payment.setAD_Org_ID(DictionaryIDs.AD_Org.HQ.id);
        payment.setC_DocType_ID(false);
        payment.setDateTrx(today);
        payment.setPayAmt(new BigDecimal(1000));
        payment.setDateAcct(today);
        payment.saveEx();
        payment.load(this.getTrxName(), new String[0]);
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)payment, (String)"PR");
        Assertions.assertTrue((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"IN", (Object)payment.getDocStatus());
        bp.setSOCreditStatus("X");
        bp.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)payment, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)payment.getDocStatus());
        info = MWorkflow.runDocumentActionWorkflow((PO)payment, (String)"RA");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"RE", (Object)payment.getDocStatus());
    }
}

