/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.Disable;
import org.zkoss.zk.ui.ext.Readonly;
import org.zkoss.zk.ui.sys.ContentRenderer;

public class Rating
extends HtmlBasedComponent
implements Disable,
Readonly {
    private String _orient = "horizontal";
    private int _rating = 0;
    private boolean _cancelable = true;
    private int _max = 5;
    private boolean _disabled = false;
    private boolean _readonly = false;
    private String _iconSclass = "z-icon-star";

    public String getIconSclass() {
        return this._iconSclass;
    }

    public void setIconSclass(String iconSclass) {
        if (!Objects.equals((Object)this._iconSclass, (Object)iconSclass)) {
            this._iconSclass = iconSclass;
            this.smartUpdate("iconSclass", this._iconSclass);
        }
    }

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) {
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.invalidate();
        }
    }

    public int getRating() {
        return this._rating;
    }

    public void setRating(int rating) {
        if (this.isInitialized() && (rating > this._max || rating < 0)) {
            throw new UiException("Out of bound: " + rating + " while max is " + this._max);
        }
        if (this._rating != rating) {
            this._rating = rating;
            this.smartUpdate("rating", this._rating);
        }
    }

    public boolean isCancelable() {
        return this._cancelable;
    }

    public void setCancelable(boolean cancelable) {
        if (this._cancelable != cancelable) {
            this._cancelable = cancelable;
            this.smartUpdate("_cancelable", this._cancelable);
        }
    }

    public int getMax() {
        return this._max;
    }

    public void setMax(int max) {
        if (max <= 0) {
            throw new UiException("max should be > 0");
        }
        if (this.isInitialized() && max < this._rating) {
            throw new UiException("max should be larger than rating");
        }
        if (this._max != max) {
            this._max = max;
            this.invalidate();
        }
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public boolean isReadonly() {
        return this._readonly;
    }

    public void setReadonly(boolean readonly) {
        if (this._readonly != readonly) {
            this._readonly = readonly;
            this.smartUpdate("readonly", this._readonly);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._max <= 0) {
            throw new UiException("max should be > 0");
        }
        if (this._rating > this._max) {
            throw new UiException("Out of bound: " + this._rating + " while max is" + this._max);
        }
        if (this._rating != 0) {
            this.render(renderer, "rating", this._rating);
        }
        if (this._max != 5) {
            this.render(renderer, "_max", this._max);
        }
        if (this._disabled) {
            renderer.render("disabled", true);
        }
        if (this._readonly) {
            renderer.render("readonly", true);
        }
        if (!this._cancelable) {
            renderer.render("_cancelable", false);
        }
        if (!"horizontal".equals(this._orient)) {
            this.render(renderer, "_orient", "vertical");
        }
        if (!"z-icon-star".equals(this._iconSclass)) {
            this.render(renderer, "iconSclass", this._iconSclass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        Map data = request.getData();
        if (cmd.equals("onChange")) {
            this.disableClientUpdate(true);
            try {
                this.setRating((Integer)data.get("rating"));
            }
            finally {
                this.disableClientUpdate(false);
                Events.postEvent((Event)Event.getEvent((AuRequest)request));
            }
        } else {
            super.service(request, everError);
        }
    }

    static {
        Rating.addClientEvent(Rating.class, (String)"onChange", (int)16385);
    }
}

