/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.PageableModel;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.event.PagingListener;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.ext.SelectionControl;

public abstract class AbstractListModel<E>
implements ListModel<E>,
Selectable<E>,
Serializable,
PageableModel {
    private static final Logger log = LoggerFactory.getLogger(AbstractListModel.class);
    private transient List<ListDataListener> _listeners = new ArrayList<ListDataListener>();
    private transient List<PagingListener> _pagingListeners = new ArrayList<PagingListener>();
    protected transient Set<E> _selection = this.newEmptySelection();
    private SelectionControl<E> _ctrl = new DefaultSelectionControl(this);
    private boolean _multiple;
    private int _pageSize = -1;
    private int _activePage = -1;

    protected AbstractListModel() {
    }

    protected void fireEvent(int type, int index0, int index1) {
        ListDataEvent evt = new ListDataEvent(this, type, index0, index1);
        for (ListDataListener l : this._listeners) {
            l.onChange(evt);
        }
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this._listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this._listeners.remove(l);
    }

    @Override
    public Set<E> getSelection() {
        return Collections.unmodifiableSet(this._selection);
    }

    @Override
    public void setSelection(Collection<? extends E> selection) {
        if (this.isSelectionChanged(selection)) {
            if (!this._multiple && selection.size() > 1) {
                throw new IllegalArgumentException("Only one selection is allowed, not " + selection);
            }
            this._selection.clear();
            this._selection.addAll(selection);
            if (selection.isEmpty()) {
                this.fireSelectionEvent(null);
            } else {
                this.fireEvent(4, -1, -1);
            }
        }
    }

    private boolean isSelectionChanged(Collection<? extends E> selection) {
        if (this._selection.size() != selection.size()) {
            return true;
        }
        for (E e : selection) {
            if (this._selection.contains(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSelected(Object obj) {
        return !this.isSelectionEmpty() && (this._selection.size() == 1 ? Objects.equals(this._selection.iterator().next(), (Object)obj) : this._selection.contains(obj));
    }

    @Override
    public boolean isSelectionEmpty() {
        return this._selection.isEmpty();
    }

    @Override
    public boolean addToSelection(E obj) {
        if (this._selection.add(obj)) {
            if (!this._multiple) {
                this._selection.clear();
                this._selection.add(obj);
            }
            this.fireSelectionEvent(obj);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeFromSelection(Object obj) {
        if (this._selection.remove(obj)) {
            this.fireEvent(4, -1, -1);
            return true;
        }
        return false;
    }

    @Override
    public void clearSelection() {
        if (!this._selection.isEmpty()) {
            this._selection.clear();
            this.fireEvent(4, -1, -1);
        }
    }

    protected void fireSelectionEvent(E e) {
        this.fireEvent(4, -1, -1);
    }

    protected void removeAllSelection(Collection<?> c) {
        if (this._selection.removeAll(c)) {
            this.fireEvent(4, -1, -1);
        }
    }

    protected void retainAllSelection(Collection<?> c) {
        if (this._selection.retainAll(c)) {
            this.fireEvent(4, -1, -1);
        }
    }

    @Override
    public boolean isMultiple() {
        return this._multiple;
    }

    @Override
    public void setMultiple(boolean multiple) {
        if (this._multiple != multiple) {
            this._multiple = multiple;
            this.fireEvent(6, -1, -1);
            if (!multiple && this._selection.size() > 1) {
                E v = this._selection.iterator().next();
                this._selection.clear();
                this._selection.add(v);
                this.fireEvent(4, -1, -1);
            }
        }
    }

    @Override
    public void setSelectionControl(SelectionControl ctrl) {
        this._ctrl = ctrl;
    }

    @Override
    public SelectionControl getSelectionControl() {
        return this._ctrl;
    }

    protected Set<E> newEmptySelection() {
        return new LinkedHashSet();
    }

    protected void writeSelection(ObjectOutputStream s) throws IOException {
        s.writeObject(this._selection);
    }

    protected void readSelection(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this._selection = (Set)s.readObject();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this.writeSelection(s);
        Serializables.smartWrite((ObjectOutputStream)s, this._listeners);
        Serializables.smartWrite((ObjectOutputStream)s, this._pagingListeners);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.readSelection(s);
        this._listeners = new ArrayList<ListDataListener>();
        Serializables.smartRead((ObjectInputStream)s, this._listeners);
        this._pagingListeners = new ArrayList<PagingListener>();
        Serializables.smartRead((ObjectInputStream)s, this._pagingListeners);
    }

    public Object clone() {
        AbstractListModel clone;
        try {
            clone = (AbstractListModel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone._listeners = new ArrayList<ListDataListener>();
        clone._pagingListeners = new ArrayList<PagingListener>();
        clone._selection = clone.newEmptySelection();
        clone._selection.addAll(this._selection);
        return clone;
    }

    @Override
    public int getPageSize() {
        return this._pageSize;
    }

    @Override
    public void setPageSize(int size) throws WrongValueException {
        int maxPageIndex;
        if (size < 0) {
            throw new WrongValueException("page size should >= 0");
        }
        if (this._pageSize == size) {
            return;
        }
        int oldPageSize = this._pageSize;
        this._pageSize = size;
        if (size > oldPageSize && this._activePage > (maxPageIndex = this.getPageCount() - 1)) {
            this._activePage = maxPageIndex;
        }
        for (PagingListener p : this._pagingListeners) {
            try {
                p.onEvent(new PagingEvent("internalModelEvent", null, this, this._activePage));
            }
            catch (Exception e) {
                log.warn("Failed to publish internal paging event", (Throwable)e);
            }
        }
    }

    @Override
    public int getPageCount() {
        int size = this.getSize();
        if (size > 0 && this._pageSize > 0) {
            int pageCount = size / this._pageSize;
            if (size % this._pageSize == 0) {
                return pageCount;
            }
            return pageCount + 1;
        }
        return 1;
    }

    @Override
    public int getActivePage() {
        return this._activePage;
    }

    @Override
    public void setActivePage(int pg) throws WrongValueException {
        if (pg < 0) {
            throw new WrongValueException("active page index should >= 0");
        }
        if (pg >= this.getPageCount()) {
            pg = this.getPageCount() - 1;
        }
        if (this._activePage == pg) {
            return;
        }
        this._activePage = pg;
        for (PagingListener p : this._pagingListeners) {
            try {
                p.onEvent(new PagingEvent("internalModelEvent", null, this, pg));
            }
            catch (Exception e) {
                log.warn("Failed to publish internal paging event", (Throwable)e);
            }
        }
    }

    @Override
    public void addPagingEventListener(PagingListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this._pagingListeners.add(l);
    }

    @Override
    public void removePagingEventListener(PagingListener l) {
        this._pagingListeners.remove(l);
    }

    public static class DefaultSelectionControl<E>
    implements SelectionControl<E> {
        private AbstractListModel<E> model;

        public DefaultSelectionControl(AbstractListModel<E> model) {
            this.model = model;
        }

        @Override
        public boolean isSelectable(E e) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSelectAll(boolean selectAll) {
            if (selectAll) {
                LinkedList all = new LinkedList();
                int j = this.model.getSize();
                for (int i = 0; i < j; ++i) {
                    Object o = this.model.getElementAt(i);
                    if (!this.isSelectable(o)) continue;
                    all.add(o);
                }
                this.model.fireEvent(11, -1, -1);
                try {
                    this.model.setSelection(all);
                }
                finally {
                    this.model.fireEvent(12, -1, -1);
                }
            } else {
                this.model.clearSelection();
            }
        }

        @Override
        public boolean isSelectAll() {
            int j = this.model.getSize();
            for (int i = 0; i < j; ++i) {
                Object o = this.model.getElementAt(i);
                if (!this.isSelectable(o) || this.model.isSelected(o)) continue;
                return false;
            }
            return true;
        }
    }
}

