/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.recursive.comparison.ComparisonDifference;
import org.assertj.core.api.recursive.comparison.ComparisonKeyDifference;
import org.assertj.core.api.recursive.comparison.DualValue;
import org.assertj.core.api.recursive.comparison.DualValueDeque;
import org.assertj.core.api.recursive.comparison.FieldLocation;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Sets;
import org.assertj.core.util.introspection.PropertyOrFieldSupport;

public class RecursiveComparisonDifferenceCalculator {
    private static final String DIFFERENT_ACTUAL_AND_EXPECTED_FIELD_TYPES = "expected field is %s but actual field is not (%s)";
    private static final String ACTUAL_NOT_ORDERED_COLLECTION = "expected field is an ordered collection but actual field is not (%s), ordered collections are: " + RecursiveComparisonDifferenceCalculator.describeOrderedCollectionTypes();
    private static final String VALUE_FIELD_NAME = "value";
    private static final String STRICT_TYPE_ERROR = "the fields are considered different since the comparison enforces strict type check and %s is not a subtype of %s";
    private static final String DIFFERENT_SIZE_ERROR = "actual and expected values are %s of different size, actual size=%s when expected size=%s";
    private static final String MISSING_FIELDS = "%s can't be compared to %s as %s does not declare all %s fields, it lacks these: %s";
    private static final Map<Class<?>, Boolean> customEquals = new ConcurrentHashMap();
    private static final Map<Class<?>, Boolean> customHash = new ConcurrentHashMap();

    public List<ComparisonDifference> determineDifferences(Object actual, Object expected, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        if (recursiveComparisonConfiguration.isInStrictTypeCheckingMode() && RecursiveComparisonDifferenceCalculator.expectedTypeIsNotSubtypeOfActualType(actual, expected)) {
            return Lists.list(RecursiveComparisonDifferenceCalculator.expectedAndActualTypeDifference(actual, expected));
        }
        List<DualValue> visited = Lists.list(new DualValue[0]);
        return RecursiveComparisonDifferenceCalculator.determineDifferences(actual, expected, FieldLocation.rootFieldLocation(), true, visited, recursiveComparisonConfiguration);
    }

    private static List<ComparisonDifference> determineDifferences(Object actual, Object expected, FieldLocation fieldLocation, boolean isRootObject, List<DualValue> visited, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        ComparisonState comparisonState = new ComparisonState(visited, recursiveComparisonConfiguration);
        comparisonState.initDualValuesToCompare(actual, expected, fieldLocation, isRootObject);
        while (comparisonState.hasDualValuesToCompare()) {
            DualValue dualValue = comparisonState.pickDualValueToCompare();
            Object actualFieldValue = dualValue.actual;
            Object expectedFieldValue = dualValue.expected;
            if (recursiveComparisonConfiguration.hasCustomComparator(dualValue)) {
                if (RecursiveComparisonDifferenceCalculator.areDualValueEqual(dualValue, recursiveComparisonConfiguration)) continue;
                comparisonState.addDifference(dualValue);
                continue;
            }
            if (actualFieldValue == expectedFieldValue) continue;
            if (actualFieldValue == null || expectedFieldValue == null) {
                comparisonState.addDifference(dualValue);
                continue;
            }
            if (dualValue.isExpectedAnEnum()) {
                RecursiveComparisonDifferenceCalculator.compareAsEnums(dualValue, comparisonState, recursiveComparisonConfiguration);
                continue;
            }
            if (dualValue.isExpectedFieldAnArray()) {
                RecursiveComparisonDifferenceCalculator.compareArrays(dualValue, comparisonState);
                continue;
            }
            if (dualValue.isExpectedFieldAnOrderedCollection() && !recursiveComparisonConfiguration.shouldIgnoreCollectionOrder(dualValue.fieldLocation)) {
                RecursiveComparisonDifferenceCalculator.compareOrderedCollections(dualValue, comparisonState);
                continue;
            }
            if (dualValue.isExpectedFieldAnIterable()) {
                RecursiveComparisonDifferenceCalculator.compareUnorderedIterables(dualValue, comparisonState);
                continue;
            }
            if (dualValue.isExpectedFieldAnOptional()) {
                RecursiveComparisonDifferenceCalculator.compareOptional(dualValue, comparisonState);
                continue;
            }
            if (dualValue.isExpectedFieldASortedMap()) {
                RecursiveComparisonDifferenceCalculator.compareSortedMap(dualValue, comparisonState);
                continue;
            }
            if (dualValue.isExpectedFieldAMap()) {
                RecursiveComparisonDifferenceCalculator.compareUnorderedMap(dualValue, comparisonState);
                continue;
            }
            if (RecursiveComparisonDifferenceCalculator.shouldCompareDualValue(recursiveComparisonConfiguration, dualValue)) {
                if (actualFieldValue.equals(expectedFieldValue)) continue;
                comparisonState.addDifference(dualValue);
                continue;
            }
            Class<?> actualFieldValueClass = actualFieldValue.getClass();
            Class<?> expectedFieldClass = expectedFieldValue.getClass();
            if (recursiveComparisonConfiguration.isInStrictTypeCheckingMode() && RecursiveComparisonDifferenceCalculator.expectedTypeIsNotSubtypeOfActualType(dualValue)) {
                comparisonState.addDifference(dualValue, String.format(STRICT_TYPE_ERROR, expectedFieldClass.getName(), actualFieldValueClass.getName()));
                continue;
            }
            Set<String> actualNonIgnoredFieldsNames = recursiveComparisonConfiguration.getNonIgnoredActualFieldNames(dualValue);
            Set<String> expectedFieldsNames = Objects.getFieldsNames(expectedFieldClass);
            if (!expectedFieldsNames.containsAll(actualNonIgnoredFieldsNames)) {
                HashSet<String> actualFieldsNamesNotInExpected = Sets.newHashSet(actualNonIgnoredFieldsNames);
                actualFieldsNamesNotInExpected.removeAll(expectedFieldsNames);
                String missingFields = ((Object)actualFieldsNamesNotInExpected).toString();
                String expectedClassName = expectedFieldClass.getName();
                String actualClassName = actualFieldValueClass.getName();
                String missingFieldsDescription = String.format(MISSING_FIELDS, actualClassName, expectedClassName, expectedFieldClass.getSimpleName(), actualFieldValueClass.getSimpleName(), missingFields);
                comparisonState.addDifference(dualValue, missingFieldsDescription);
                continue;
            }
            for (String actualFieldName : actualNonIgnoredFieldsNames) {
                if (!expectedFieldsNames.contains(actualFieldName)) continue;
                DualValue newDualValue = new DualValue(dualValue.fieldLocation.field(actualFieldName), PropertyOrFieldSupport.COMPARISON.getSimpleValue(actualFieldName, actualFieldValue), PropertyOrFieldSupport.COMPARISON.getSimpleValue(actualFieldName, expectedFieldValue));
                comparisonState.registerForComparison(newDualValue);
            }
        }
        return comparisonState.getDifferences();
    }

    private static boolean shouldCompareDualValue(RecursiveComparisonConfiguration recursiveComparisonConfiguration, DualValue dualValue) {
        return !recursiveComparisonConfiguration.shouldIgnoreOverriddenEqualsOf(dualValue) && RecursiveComparisonDifferenceCalculator.hasOverriddenEquals(dualValue.actual.getClass());
    }

    private static void compareAsEnums(DualValue dualValue, ComparisonState comparisonState, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        if (recursiveComparisonConfiguration.isInStrictTypeCheckingMode()) {
            if (dualValue.actual != dualValue.expected) {
                comparisonState.addDifference(dualValue);
            }
            return;
        }
        if (!dualValue.isActualAnEnum()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "an enum"));
            return;
        }
        Enum actualEnum = (Enum)dualValue.actual;
        Enum expectedEnum = (Enum)dualValue.expected;
        if (!actualEnum.name().equals(expectedEnum.name())) {
            comparisonState.addDifference(dualValue);
        }
    }

    private static boolean shouldHonorOverriddenEquals(DualValue dualValue, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        boolean shouldNotIgnoreOverriddenEqualsIfAny = !recursiveComparisonConfiguration.shouldIgnoreOverriddenEqualsOf(dualValue);
        return shouldNotIgnoreOverriddenEqualsIfAny && dualValue.actual != null && RecursiveComparisonDifferenceCalculator.hasOverriddenEquals(dualValue.actual.getClass());
    }

    private static void compareArrays(DualValue dualValue, ComparisonState comparisonState) {
        int expectedArrayLength;
        if (!dualValue.isActualFieldAnArray()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "an array"));
            return;
        }
        int actualArrayLength = Array.getLength(dualValue.actual);
        if (actualArrayLength != (expectedArrayLength = Array.getLength(dualValue.expected))) {
            comparisonState.addDifference(dualValue, String.format(DIFFERENT_SIZE_ERROR, "arrays", actualArrayLength, expectedArrayLength));
            return;
        }
        FieldLocation arrayFieldLocation = dualValue.fieldLocation;
        for (int i = 0; i < actualArrayLength; ++i) {
            Object actualElement = Array.get(dualValue.actual, i);
            Object expectedElement = Array.get(dualValue.expected, i);
            FieldLocation elementFieldLocation = arrayFieldLocation.field(String.format("[%d]", i));
            comparisonState.registerForComparison(new DualValue(elementFieldLocation, actualElement, expectedElement));
        }
    }

    private static void compareOrderedCollections(DualValue dualValue, ComparisonState comparisonState) {
        if (!dualValue.isActualFieldAnOrderedCollection()) {
            comparisonState.addDifference(dualValue, String.format(ACTUAL_NOT_ORDERED_COLLECTION, dualValue.actual.getClass().getCanonicalName()));
            return;
        }
        Collection actualCollection = (Collection)dualValue.actual;
        Collection expectedCollection = (Collection)dualValue.expected;
        if (actualCollection.size() != expectedCollection.size()) {
            comparisonState.addDifference(dualValue, String.format(DIFFERENT_SIZE_ERROR, "collections", actualCollection.size(), expectedCollection.size()));
            return;
        }
        Iterator expectedIterator = expectedCollection.iterator();
        int i = 0;
        for (Object element : actualCollection) {
            FieldLocation elementFielLocation = dualValue.fieldLocation.field(String.format("[%d]", i));
            DualValue elementDualValue = new DualValue(elementFielLocation, element, expectedIterator.next());
            comparisonState.registerForComparison(elementDualValue);
            ++i;
        }
    }

    private static String differentTypeErrorMessage(DualValue dualValue, String actualTypeDescription) {
        return String.format(DIFFERENT_ACTUAL_AND_EXPECTED_FIELD_TYPES, actualTypeDescription, dualValue.actual.getClass().getCanonicalName());
    }

    private static void compareUnorderedIterables(DualValue dualValue, ComparisonState comparisonState) {
        int expectedSize;
        if (!dualValue.isActualFieldAnIterable()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "an iterable"));
            return;
        }
        Iterable actual = (Iterable)dualValue.actual;
        Iterable expected = (Iterable)dualValue.expected;
        int actualSize = IterableUtil.sizeOf(actual);
        if (actualSize != (expectedSize = IterableUtil.sizeOf(expected))) {
            comparisonState.addDifference(dualValue, String.format(DIFFERENT_SIZE_ERROR, "collections", actualSize, expectedSize));
            return;
        }
        LinkedList expectedCopy = new LinkedList(IterableUtil.toCollection(expected));
        List<Object> unmatchedActualElements = Lists.list(new Object[0]);
        for (Object actualElement : actual) {
            boolean actualElementMatched = false;
            Iterator expectedIterator = expectedCopy.iterator();
            while (expectedIterator.hasNext()) {
                Object expectedElement = expectedIterator.next();
                List<ComparisonDifference> differences = RecursiveComparisonDifferenceCalculator.determineDifferences(actualElement, expectedElement, dualValue.fieldLocation, false, comparisonState.visitedDualValues, comparisonState.recursiveComparisonConfiguration);
                if (!differences.isEmpty()) continue;
                expectedIterator.remove();
                actualElementMatched = true;
                break;
            }
            if (actualElementMatched) continue;
            unmatchedActualElements.add(actualElement);
        }
        if (!unmatchedActualElements.isEmpty()) {
            String unmatched = String.format("The following actual elements were not matched in the expected %s:%n  %s", expected.getClass().getSimpleName(), unmatchedActualElements);
            comparisonState.addDifference(dualValue, unmatched);
        }
    }

    private static <K, V> void compareSortedMap(DualValue dualValue, ComparisonState comparisonState) {
        if (!dualValue.isActualFieldASortedMap()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "a sorted map"));
            return;
        }
        Map actualMap = (Map)dualValue.actual;
        Map expectedMap = (Map)dualValue.expected;
        if (actualMap.size() != expectedMap.size()) {
            comparisonState.addDifference(dualValue, String.format(DIFFERENT_SIZE_ERROR, "sorted maps", actualMap.size(), expectedMap.size()));
            return;
        }
        Iterator expectedMapEntries = expectedMap.entrySet().iterator();
        for (Map.Entry actualEntry : actualMap.entrySet()) {
            Map.Entry expectedEntry = expectedMapEntries.next();
            if (!java.util.Objects.equals(actualEntry.getKey(), expectedEntry.getKey())) {
                comparisonState.addKeyDifference(dualValue, actualEntry.getKey(), expectedEntry.getKey());
                continue;
            }
            FieldLocation keyFieldLocation = RecursiveComparisonDifferenceCalculator.keyFieldLocation(dualValue.fieldLocation, actualEntry.getKey());
            comparisonState.registerForComparison(new DualValue(keyFieldLocation, actualEntry.getValue(), expectedEntry.getValue()));
        }
    }

    private static void compareUnorderedMap(DualValue dualValue, ComparisonState comparisonState) {
        if (!dualValue.isActualFieldAMap()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "a map"));
            return;
        }
        Map actualMap = (Map)dualValue.actual;
        Map expectedMap = (Map)dualValue.expected;
        if (actualMap.size() != expectedMap.size()) {
            comparisonState.addDifference(dualValue, String.format(DIFFERENT_SIZE_ERROR, "maps", actualMap.size(), expectedMap.size()));
            return;
        }
        Map<Integer, Map.Entry> expectedEntriesByDeepHashCode = expectedMap.entrySet().stream().collect(Collectors.toMap(entry -> RecursiveComparisonDifferenceCalculator.deepHashCode(entry.getKey()), entry -> entry));
        Map<Object, Integer> actualDeepHashCodesByKey = actualMap.keySet().stream().collect(Collectors.toMap(key -> key, key -> RecursiveComparisonDifferenceCalculator.deepHashCode(key)));
        Map<Object, Object> unmatchedActualEntries = actualDeepHashCodesByKey.entrySet().stream().filter(entry -> !expectedEntriesByDeepHashCode.containsKey(entry.getValue())).collect(Collectors.toMap(entry -> entry.getKey(), entry -> actualMap.get(entry.getKey())));
        if (!unmatchedActualEntries.isEmpty()) {
            comparisonState.addDifference(dualValue, String.format("The following actual map entries were not found in the expected map:%n  %s", unmatchedActualEntries));
            return;
        }
        for (Map.Entry actualEntry : actualMap.entrySet()) {
            int deepHashCode = actualDeepHashCodesByKey.get(actualEntry.getKey());
            Map.Entry expectedEntry = expectedEntriesByDeepHashCode.get(deepHashCode);
            FieldLocation keyFieldLocation = RecursiveComparisonDifferenceCalculator.keyFieldLocation(dualValue.fieldLocation, actualEntry.getKey());
            comparisonState.registerForComparison(new DualValue(keyFieldLocation, actualEntry.getValue(), expectedEntry.getValue()));
        }
    }

    private static FieldLocation keyFieldLocation(FieldLocation parentFieldLocation, Object key) {
        return key == null ? parentFieldLocation : parentFieldLocation.field(key.toString());
    }

    private static void compareOptional(DualValue dualValue, ComparisonState comparisonState) {
        if (!dualValue.isActualFieldAnOptional()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "an Optional"));
            return;
        }
        Optional actual = (Optional)dualValue.actual;
        Optional expected = (Optional)dualValue.expected;
        if (actual.isPresent() != expected.isPresent()) {
            comparisonState.addDifference(dualValue);
            return;
        }
        if (!actual.isPresent()) {
            return;
        }
        Object value1 = actual.get();
        Object value2 = expected.get();
        comparisonState.registerForComparison(new DualValue(dualValue.fieldLocation.field(VALUE_FIELD_NAME), value1, value2));
    }

    static boolean hasOverriddenEquals(Class<?> c) {
        if (customEquals.containsKey(c)) {
            return customEquals.get(c);
        }
        Class<?> origClass = c;
        while (!Object.class.equals(c)) {
            try {
                c.getDeclaredMethod("equals", Object.class);
                customEquals.put(origClass, true);
                return true;
            }
            catch (Exception exception) {
                c = c.getSuperclass();
            }
        }
        customEquals.put(origClass, false);
        return false;
    }

    static int deepHashCode(Object obj) {
        HashSet<Object> visited = new HashSet<Object>();
        LinkedList<Object> stack = new LinkedList<Object>();
        stack.addFirst(obj);
        int hash = 0;
        while (!stack.isEmpty()) {
            obj = stack.removeFirst();
            if (obj == null || visited.contains(obj)) continue;
            visited.add(obj);
            if (obj.getClass().isArray()) {
                int len = Array.getLength(obj);
                for (int i = 0; i < len; ++i) {
                    stack.addFirst(Array.get(obj, i));
                }
                continue;
            }
            if (obj instanceof Collection) {
                stack.addAll(0, (Collection)obj);
                continue;
            }
            if (obj instanceof Map) {
                stack.addAll(0, ((Map)obj).keySet());
                stack.addAll(0, ((Map)obj).values());
                continue;
            }
            if (obj instanceof Double || obj instanceof Float) {
                stack.add(Math.round(((Number)obj).doubleValue()));
                continue;
            }
            if (RecursiveComparisonDifferenceCalculator.hasCustomHashCode(obj.getClass())) {
                hash += obj.hashCode();
                continue;
            }
            Set<Field> fields = Objects.getDeclaredFieldsIncludingInherited(obj.getClass());
            for (Field field : fields) {
                stack.addFirst(PropertyOrFieldSupport.COMPARISON.getSimpleValue(field.getName(), obj));
            }
        }
        return hash;
    }

    static boolean hasCustomHashCode(Class<?> c) {
        Class<?> origClass = c;
        if (customHash.containsKey(c)) {
            return customHash.get(c);
        }
        while (!Object.class.equals(c)) {
            try {
                c.getDeclaredMethod("hashCode", new Class[0]);
                customHash.put(origClass, true);
                return true;
            }
            catch (Exception exception) {
                c = c.getSuperclass();
            }
        }
        customHash.put(origClass, false);
        return false;
    }

    private static boolean areDualValueEqual(DualValue dualValue, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        String fieldName = dualValue.getConcatenatedPath();
        Object actualFieldValue = dualValue.actual;
        Object expectedFieldValue = dualValue.expected;
        Comparator<Object> fieldComparator = recursiveComparisonConfiguration.getComparatorForField(fieldName);
        if (fieldComparator != null) {
            return RecursiveComparisonDifferenceCalculator.areEqualUsingComparator(actualFieldValue, expectedFieldValue, fieldComparator);
        }
        Class<?> fieldType = actualFieldValue != null ? actualFieldValue.getClass() : expectedFieldValue.getClass();
        Comparator<Object> typeComparator = recursiveComparisonConfiguration.getComparatorForType(fieldType);
        if (typeComparator != null) {
            return RecursiveComparisonDifferenceCalculator.areEqualUsingComparator(actualFieldValue, expectedFieldValue, typeComparator);
        }
        return java.util.Objects.deepEquals(actualFieldValue, expectedFieldValue);
    }

    private static boolean areEqualUsingComparator(Object actual, Object expected, Comparator<Object> comparator) {
        try {
            return comparator.compare(actual, expected) == 0;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private static ComparisonDifference expectedAndActualTypeDifference(Object actual, Object expected) {
        String additionalInformation = String.format("actual and expected are considered different since the comparison enforces strict type check and expected type %s is not a subtype of actual type %s", expected.getClass().getName(), actual.getClass().getName());
        return ComparisonDifference.rootComparisonDifference(actual, expected, additionalInformation);
    }

    private static boolean expectedTypeIsNotSubtypeOfActualType(DualValue dualField) {
        return RecursiveComparisonDifferenceCalculator.expectedTypeIsNotSubtypeOfActualType(dualField.actual, dualField.expected);
    }

    private static boolean expectedTypeIsNotSubtypeOfActualType(Object actual, Object expected) {
        return !actual.getClass().isAssignableFrom(expected.getClass());
    }

    private static String describeOrderedCollectionTypes() {
        return Stream.of(DualValue.DEFAULT_ORDERED_COLLECTION_TYPES).map(Class::getName).collect(Collectors.joining(", ", "[", "]"));
    }

    private static class ComparisonState {
        List<DualValue> visitedDualValues;
        List<ComparisonDifference> differences = new ArrayList<ComparisonDifference>();
        DualValueDeque dualValuesToCompare;
        RecursiveComparisonConfiguration recursiveComparisonConfiguration;

        public ComparisonState(List<DualValue> visited, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
            this.visitedDualValues = visited;
            this.dualValuesToCompare = new DualValueDeque(recursiveComparisonConfiguration);
            this.recursiveComparisonConfiguration = recursiveComparisonConfiguration;
        }

        void addDifference(DualValue dualValue) {
            this.differences.add(new ComparisonDifference(dualValue, null, this.getCustomErrorMessage(dualValue)));
        }

        void addDifference(DualValue dualValue, String description) {
            this.differences.add(new ComparisonDifference(dualValue, description, this.getCustomErrorMessage(dualValue)));
        }

        void addKeyDifference(DualValue parentDualValue, Object actualKey, Object expectedKey) {
            this.differences.add(new ComparisonKeyDifference(parentDualValue, actualKey, expectedKey));
        }

        public List<ComparisonDifference> getDifferences() {
            Collections.sort(this.differences);
            return this.differences;
        }

        public boolean hasDualValuesToCompare() {
            return !this.dualValuesToCompare.isEmpty();
        }

        public DualValue pickDualValueToCompare() {
            DualValue dualValue = (DualValue)this.dualValuesToCompare.removeFirst();
            if (dualValue.hasPotentialCyclingValues()) {
                this.visitedDualValues.add(dualValue);
            }
            return dualValue;
        }

        private void registerForComparison(DualValue dualValue) {
            if (!this.visitedDualValues.contains(dualValue)) {
                this.dualValuesToCompare.addFirst(dualValue);
            }
        }

        private void initDualValuesToCompare(Object actual, Object expected, FieldLocation fieldLocation, boolean isRootObject) {
            DualValue dualValue = new DualValue(fieldLocation, actual, expected);
            boolean mustCompareFieldsRecursively = this.mustCompareFieldsRecursively(isRootObject, dualValue);
            if (dualValue.hasNoNullValues() && dualValue.hasNoContainerValues() && mustCompareFieldsRecursively) {
                Set<String> nonIgnoredActualFieldsNames = this.recursiveComparisonConfiguration.getNonIgnoredActualFieldNames(dualValue);
                if (!nonIgnoredActualFieldsNames.isEmpty()) {
                    Set<String> expectedFieldsNames = Objects.getFieldsNames(expected.getClass());
                    if (expectedFieldsNames.containsAll(nonIgnoredActualFieldsNames)) {
                        for (String nonIgnoredActualFieldName : nonIgnoredActualFieldsNames) {
                            DualValue fieldDualValue = new DualValue(fieldLocation.field(nonIgnoredActualFieldName), PropertyOrFieldSupport.COMPARISON.getSimpleValue(nonIgnoredActualFieldName, actual), PropertyOrFieldSupport.COMPARISON.getSimpleValue(nonIgnoredActualFieldName, expected));
                            this.dualValuesToCompare.addFirst(fieldDualValue);
                        }
                    } else {
                        this.dualValuesToCompare.addFirst(dualValue);
                    }
                } else {
                    this.dualValuesToCompare.addFirst(dualValue);
                }
            } else {
                this.dualValuesToCompare.addFirst(dualValue);
            }
            this.visitedDualValues.forEach(visitedDualValue -> this.dualValuesToCompare.stream().filter(dualValueToCompare -> dualValueToCompare.equals(visitedDualValue)).findFirst().ifPresent(this.dualValuesToCompare::remove));
        }

        private boolean mustCompareFieldsRecursively(boolean isRootObject, DualValue dualValue) {
            boolean noCustomComparisonForDualValue = !this.recursiveComparisonConfiguration.hasCustomComparator(dualValue) && !RecursiveComparisonDifferenceCalculator.shouldHonorOverriddenEquals(dualValue, this.recursiveComparisonConfiguration);
            return isRootObject || noCustomComparisonForDualValue;
        }

        private String getCustomErrorMessage(DualValue dualValue) {
            Class<?> fieldType;
            String fieldName = dualValue.getConcatenatedPath();
            if (this.recursiveComparisonConfiguration.hasCustomMessageForField(fieldName)) {
                return this.recursiveComparisonConfiguration.getMessageForField(fieldName);
            }
            Class<?> clazz = fieldType = dualValue.actual != null ? dualValue.actual.getClass() : dualValue.expected.getClass();
            if (this.recursiveComparisonConfiguration.hasCustomMessageForType(fieldType)) {
                return this.recursiveComparisonConfiguration.getMessageForType(fieldType);
            }
            return null;
        }
    }
}

