/* Timer.js

	Purpose:

	Description:

	History:
		Thu Dec 11 17:37:20     2008, Created by tomyeh

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/

/**
 * Fires one or more timer after a specified delay.
 *
 * <p>{@link Timer} is a special component that is invisible.
 *
 * <p>Notice that the timer won't fire any event until it is attached
 * to a page.
 */
zul.utl.Timer = zk.$extends(zk.Widget, {
  _running: true,
  _delay: 0,
  $define: {
    /** Returns whether the timer shall send Event repeatly.
     * <p>Default: false.
     * @return boolean
     */

    /** Sets whether the timer shall send Event repeatly.
     * @param boolean repeats
     */
    repeats: _zkf = function _zkf() {
      if (this.desktop) this._sync();
    },

    /** Returns the delay, the number of milliseconds between
     * successive action events.
     * <p>Default: 0 (immediately).
     * @return int
     */

    /** Sets the delay, the number of milliseconds between
     * successive action events.
     * @param int delay
     */
    delay: _zkf,

    /** Returns whether this timer is running.
     * <p>Default: true.
     * @see #play
     * @see #stop
     * @return boolean
     */

    /** Start or stops the timer.
     * @param boolean running
     */
    running: _zkf
  },

  /** Starts the timer.
   */
  play: function play() {
    this.setRunning(true);
  },

  /** Stops the timer.
   */
  stop: function stop() {
    this.setRunning(false);
  },
  _sync: function _sync() {
    this._stop();

    this._play();
  },
  _play: function _play() {
    if (this._running) {
      var fn = this.proxy(this._tmfn);

      if (this._repeats) {
        this._iid = setInterval(fn, this._delay);
        zAu.onError(this.proxy(this._onErr));
      } else this._tid = setTimeout(fn, this._delay);
    }
  },
  _stop: function _stop() {
    var id = this._iid;

    if (id) {
      this._iid = null;
      clearInterval(id);
    }

    id = this._tid;

    if (id) {
      this._tid = null;
      clearTimeout(id);
    }

    zAu.unError(this.proxy(this._onErr));
  },
  _onErr: function _onErr(req, errCode) {
    if (errCode == 410 || errCode == 404 || errCode == 405) this._stop();
  },
  _tmfn: function _tmfn() {
    if (!this._repeats) this._running = false;
    this.fire('onTimer', null, {
      ignorable: true,
      rtags: {
        onTimer: 1
      } // Bug ZK-2720 only timer-keep-alive should reset the timeout

    });
  },
  //super//
  redraw: function redraw() {},
  bind_: function bind_() {
    this.$supers(zul.utl.Timer, 'bind_', arguments);
    this._visible = false; //Bug ZK-1516: no DOM element widget should always return false.

    if (this._running) this._play();
  },
  unbind_: function unbind_() {
    this._stop();

    this.$supers(zul.utl.Timer, 'unbind_', arguments);
  }
});