/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.copyobject.impl;

import java.lang.reflect.Array;
import java.util.Map;
import org.glassfish.pfl.dynamic.copyobject.impl.ClassCopier;
import org.glassfish.pfl.dynamic.copyobject.impl.ClassCopierBase;
import org.glassfish.pfl.dynamic.copyobject.impl.ClassCopierFactory;
import org.glassfish.pfl.dynamic.copyobject.spi.ReflectiveCopyException;

public class ClassCopierFactoryArrayImpl
implements ClassCopierFactory {
    private final ClassCopierFactory classCopierFactory;
    private ClassCopier arrayClassCopier = new ClassCopierBase("array"){

        @Override
        public Object createCopy(Object source) throws ReflectiveCopyException {
            int alen = Array.getLength(source);
            Object result = Array.newInstance(source.getClass().getComponentType(), alen);
            return result;
        }

        @Override
        public Object doCopy(Map<Object, Object> oldToNew, Object source, Object result) throws ReflectiveCopyException {
            int alen = Array.getLength(source);
            for (int ctr = 0; ctr < alen; ++ctr) {
                Object aobj = Array.get(source, ctr);
                if (aobj != null) {
                    ClassCopier copier = ClassCopierFactoryArrayImpl.this.classCopierFactory.getClassCopier(aobj.getClass());
                    aobj = copier.copy(oldToNew, aobj);
                }
                Array.set(result, ctr, aobj);
            }
            return result;
        }
    };
    private static ClassCopier booleanArrayClassCopier = new ClassCopierBase("boolean"){

        @Override
        public Object createCopy(Object source) throws ReflectiveCopyException {
            boolean[] obj = (boolean[])source;
            return obj.clone();
        }
    };
    private static ClassCopier byteArrayClassCopier = new ClassCopierBase("byte"){

        @Override
        public Object createCopy(Object source) throws ReflectiveCopyException {
            byte[] obj = (byte[])source;
            return obj.clone();
        }
    };
    private static ClassCopier charArrayClassCopier = new ClassCopierBase("char"){

        @Override
        public Object createCopy(Object source) throws ReflectiveCopyException {
            char[] obj = (char[])source;
            return obj.clone();
        }
    };
    private static ClassCopier shortArrayClassCopier = new ClassCopierBase("short"){

        @Override
        public Object createCopy(Object source) throws ReflectiveCopyException {
            short[] obj = (short[])source;
            return obj.clone();
        }
    };
    private static ClassCopier intArrayClassCopier = new ClassCopierBase("int"){

        @Override
        public Object createCopy(Object source) throws ReflectiveCopyException {
            int[] obj = (int[])source;
            return obj.clone();
        }
    };
    private static ClassCopier longArrayClassCopier = new ClassCopierBase("long"){

        @Override
        public Object createCopy(Object source) throws ReflectiveCopyException {
            long[] obj = (long[])source;
            return obj.clone();
        }
    };
    private static ClassCopier floatArrayClassCopier = new ClassCopierBase("float"){

        @Override
        public Object createCopy(Object source) throws ReflectiveCopyException {
            float[] obj = (float[])source;
            return obj.clone();
        }
    };
    private static ClassCopier doubleArrayClassCopier = new ClassCopierBase("double"){

        @Override
        public Object createCopy(Object source) throws ReflectiveCopyException {
            double[] obj = (double[])source;
            return obj.clone();
        }
    };

    public ClassCopierFactoryArrayImpl(ClassCopierFactory ccf) {
        this.classCopierFactory = ccf;
    }

    @Override
    public ClassCopier getClassCopier(Class<?> cls) {
        Class<?> compType = cls.getComponentType();
        if (compType == null) {
            return null;
        }
        if (compType.isPrimitive()) {
            if (compType == Boolean.TYPE) {
                return booleanArrayClassCopier;
            }
            if (compType == Byte.TYPE) {
                return byteArrayClassCopier;
            }
            if (compType == Character.TYPE) {
                return charArrayClassCopier;
            }
            if (compType == Short.TYPE) {
                return shortArrayClassCopier;
            }
            if (compType == Integer.TYPE) {
                return intArrayClassCopier;
            }
            if (compType == Long.TYPE) {
                return longArrayClassCopier;
            }
            if (compType == Float.TYPE) {
                return floatArrayClassCopier;
            }
            if (compType == Double.TYPE) {
                return doubleArrayClassCopier;
            }
            return null;
        }
        return this.arrayClassCopier;
    }
}

