/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import org.compiere.model.MRefList;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class StateEngine {
    public static final String STATE_NotStarted = "ON";
    public static final String STATE_Running = "OR";
    public static final String STATE_Suspended = "OS";
    public static final String STATE_Completed = "CC";
    public static final String STATE_Aborted = "CA";
    public static final String STATE_Terminated = "CT";
    public static final String ACTION_Suspend = "Suspend";
    public static final String ACTION_Start = "Start";
    public static final String ACTION_Resume = "Resume";
    public static final String ACTION_Complete = "Complete";
    public static final String ACTION_Abort = "Abort";
    public static final String ACTION_Terminate = "Terminate";
    private String m_state = "ON";
    private boolean m_throwException = false;
    protected CLogger log = null;

    public StateEngine() {
        this(STATE_NotStarted);
        this.log = CLogger.getCLogger(this.getClass());
    }

    public StateEngine(String startState) {
        if (startState != null) {
            this.m_state = startState;
        }
    }

    public boolean isThrowException() {
        return this.m_throwException;
    }

    public void setThrowException(boolean throwException) {
        this.m_throwException = throwException;
    }

    public String getState() {
        return this.m_state;
    }

    public String getStateInfo() {
        String state = this.getState();
        String stateName = MRefList.getListName(Env.getCtx(), 305, state);
        if (!Util.isEmpty(stateName)) {
            return stateName;
        }
        return state;
    }

    public boolean isOpen() {
        return STATE_Running.equals(this.m_state) || STATE_NotStarted.equals(this.m_state) || STATE_Suspended.equals(this.m_state);
    }

    public boolean isNotRunning() {
        return STATE_NotStarted.equals(this.m_state) || STATE_Suspended.equals(this.m_state);
    }

    public boolean isClosed() {
        return STATE_Completed.equals(this.m_state) || STATE_Aborted.equals(this.m_state) || STATE_Terminated.equals(this.m_state);
    }

    public boolean isNotStarted() {
        return STATE_NotStarted.equals(this.m_state);
    }

    public boolean isRunning() {
        return STATE_Running.equals(this.m_state);
    }

    public boolean isSuspended() {
        return STATE_Suspended.equals(this.m_state);
    }

    public boolean isCompleted() {
        return STATE_Completed.equals(this.m_state);
    }

    public boolean isAborted() {
        return STATE_Aborted.equals(this.m_state);
    }

    public boolean isTerminated() {
        return STATE_Terminated.equals(this.m_state);
    }

    public boolean start() {
        if (this.log == null) {
            this.log = CLogger.getCLogger(this.getClass());
        }
        if (this.isNotStarted()) {
            this.m_state = STATE_Running;
            this.log.info("starting ...");
            return true;
        }
        String msg = "start failed: Not Not Started (" + this.getState() + ")";
        if (this.m_throwException) {
            throw new IllegalStateException(msg);
        }
        this.log.warning(msg);
        return false;
    }

    public boolean resume() {
        if (this.log == null) {
            this.log = CLogger.getCLogger(this.getClass());
        }
        if (this.isSuspended()) {
            this.m_state = STATE_Running;
            this.log.info("resuming ...");
            return true;
        }
        String msg = "resume failed: Not Suspended (" + this.getState() + ")";
        if (this.m_throwException) {
            throw new IllegalStateException(msg);
        }
        this.log.warning(msg);
        return false;
    }

    public boolean suspend() {
        if (this.log == null) {
            this.log = CLogger.getCLogger(this.getClass());
        }
        if (this.isRunning()) {
            this.m_state = STATE_Suspended;
            this.log.info("suspending ...");
            return true;
        }
        String msg = "suspend failed: Not Running (" + this.getState() + ")";
        if (this.m_throwException) {
            throw new IllegalStateException(msg);
        }
        this.log.warning(msg);
        return false;
    }

    public boolean complete() {
        if (this.log == null) {
            this.log = CLogger.getCLogger(this.getClass());
        }
        if (this.isRunning()) {
            this.m_state = STATE_Completed;
            this.log.info("completing ...");
            return true;
        }
        String msg = "complete failed: Not Running (" + this.getState() + ")";
        if (this.m_throwException) {
            throw new IllegalStateException(msg);
        }
        this.log.warning(msg);
        return false;
    }

    public boolean abort() {
        if (this.log == null) {
            this.log = CLogger.getCLogger(this.getClass());
        }
        if (this.isOpen()) {
            this.m_state = STATE_Aborted;
            this.log.info("aborting ...");
            return true;
        }
        String msg = "abort failed: Not Open (" + this.getState() + ")";
        if (this.m_throwException) {
            throw new IllegalStateException(msg);
        }
        this.log.warning(msg);
        return false;
    }

    public boolean terminate() {
        if (this.log == null) {
            this.log = CLogger.getCLogger(this.getClass());
        }
        if (this.isOpen()) {
            this.m_state = STATE_Terminated;
            this.log.info("terminating ...");
            return true;
        }
        String msg = "terminate failed: Not Open (" + this.getState() + ")";
        if (this.m_throwException) {
            throw new IllegalStateException(msg);
        }
        this.log.warning(msg);
        return false;
    }

    public String[] getNewStateOptions() {
        if (this.isNotStarted()) {
            return new String[]{STATE_Running, STATE_Aborted, STATE_Terminated};
        }
        if (this.isRunning()) {
            return new String[]{STATE_Suspended, STATE_Completed, STATE_Aborted, STATE_Terminated};
        }
        if (this.isSuspended()) {
            return new String[]{STATE_Running, STATE_Aborted, STATE_Terminated, STATE_Completed};
        }
        return new String[0];
    }

    public boolean isValidNewState(String newState) {
        String[] options = this.getNewStateOptions();
        int i2 = 0;
        while (i2 < options.length) {
            if (options[i2].equals(newState)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public boolean setState(String newState) {
        if (STATE_Running.equals(newState)) {
            if (this.isNotStarted()) {
                return this.start();
            }
            return this.resume();
        }
        if (STATE_Suspended.equals(newState)) {
            return this.suspend();
        }
        if (STATE_Completed.equals(newState)) {
            return this.complete();
        }
        if (STATE_Aborted.equals(newState)) {
            return this.abort();
        }
        if (STATE_Terminated.equals(newState)) {
            return this.terminate();
        }
        return false;
    }

    public String[] getActionOptions() {
        if (this.isNotStarted()) {
            return new String[]{ACTION_Start, ACTION_Abort, ACTION_Terminate};
        }
        if (this.isRunning()) {
            return new String[]{ACTION_Suspend, ACTION_Complete, ACTION_Abort, ACTION_Terminate};
        }
        if (this.isSuspended()) {
            return new String[]{ACTION_Resume, ACTION_Abort, ACTION_Terminate};
        }
        return new String[0];
    }

    public boolean isValidAction(String action) {
        String[] options = this.getActionOptions();
        int i2 = 0;
        while (i2 < options.length) {
            if (options[i2].equals(action)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public boolean process(String action) {
        if (ACTION_Start.equals(action)) {
            return this.start();
        }
        if (ACTION_Complete.equals(action)) {
            return this.complete();
        }
        if (ACTION_Suspend.equals(action)) {
            return this.suspend();
        }
        if (ACTION_Resume.equals(action)) {
            return this.resume();
        }
        if (ACTION_Abort.equals(action)) {
            return this.abort();
        }
        if (ACTION_Terminate.equals(action)) {
            return this.terminate();
        }
        return false;
    }

    public String getNewStateIfAction(String action) {
        if (this.isValidAction(action)) {
            if (ACTION_Start.equals(action)) {
                return STATE_Running;
            }
            if (ACTION_Complete.equals(action)) {
                return STATE_Completed;
            }
            if (ACTION_Suspend.equals(action)) {
                return STATE_Suspended;
            }
            if (ACTION_Resume.equals(action)) {
                return STATE_Running;
            }
            if (ACTION_Abort.equals(action)) {
                return STATE_Aborted;
            }
            if (ACTION_Terminate.equals(action)) {
                return STATE_Terminated;
            }
        }
        return this.getState();
    }

    public String toString() {
        return this.getStateInfo();
    }
}

