/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl;

import io.keikai.api.AreaRef;
import io.keikai.api.AreaRefWithType;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Book;
import io.keikai.api.model.CellStyle;
import io.keikai.api.model.Sheet;
import io.keikai.model.SBook;
import io.keikai.ui.AuxAction;
import io.keikai.ui.CellSelectionType;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.UserActionHandler;
import io.keikai.ui.UserActionManager;
import io.keikai.ui.event.AuxActionEvent;
import io.keikai.ui.event.KeyEvent;
import io.keikai.ui.impl.ua.AbstractBookHandler;
import io.keikai.ui.impl.ua.AbstractCellHandler;
import io.keikai.ui.impl.ua.AbstractHandler;
import io.keikai.ui.impl.ua.AddColumnHandler;
import io.keikai.ui.impl.ua.AddRowHandler;
import io.keikai.ui.impl.ua.AddSheetHandler;
import io.keikai.ui.impl.ua.ApplyBorderHandler;
import io.keikai.ui.impl.ua.BackColorHandler;
import io.keikai.ui.impl.ua.ClearCellHandler;
import io.keikai.ui.impl.ua.CloseBookHandler;
import io.keikai.ui.impl.ua.CopyHandler;
import io.keikai.ui.impl.ua.CopySheetHandler;
import io.keikai.ui.impl.ua.CutHandler;
import io.keikai.ui.impl.ua.DeleteCellLeftHandler;
import io.keikai.ui.impl.ua.DeleteCellUpHandler;
import io.keikai.ui.impl.ua.DeleteColumnHandler;
import io.keikai.ui.impl.ua.DeleteRowHandler;
import io.keikai.ui.impl.ua.DeleteSheetHandler;
import io.keikai.ui.impl.ua.FillColorHandler;
import io.keikai.ui.impl.ua.FontBoldHandler;
import io.keikai.ui.impl.ua.FontColorHandler;
import io.keikai.ui.impl.ua.FontFamilyHandler;
import io.keikai.ui.impl.ua.FontItalicHandler;
import io.keikai.ui.impl.ua.FontSizeHandler;
import io.keikai.ui.impl.ua.FontStrikeoutHandler;
import io.keikai.ui.impl.ua.FontTypeOffsetHandler;
import io.keikai.ui.impl.ua.FontUnderlineHandler;
import io.keikai.ui.impl.ua.HideHeaderHandler;
import io.keikai.ui.impl.ua.HorizontalAlignHandler;
import io.keikai.ui.impl.ua.InsertCellDownHandler;
import io.keikai.ui.impl.ua.InsertCellRightHandler;
import io.keikai.ui.impl.ua.InsertColumnHandler;
import io.keikai.ui.impl.ua.InsertRowHandler;
import io.keikai.ui.impl.ua.MoveSheetHandler;
import io.keikai.ui.impl.ua.PasteHandler;
import io.keikai.ui.impl.ua.RenameSheetHandler;
import io.keikai.ui.impl.ua.TextIndentHandler;
import io.keikai.ui.impl.ua.VerticalAlignHandler;
import io.keikai.ui.impl.ua.WrapTextHandler;
import io.keikai.ui.impl.undo.ClearCellAction;
import io.keikai.ui.impl.undo.HideHeaderAction;
import io.keikai.ui.sys.DisplayGridlinesAction;
import io.keikai.ui.sys.SortHandler;
import io.keikai.ui.sys.UndoableActionManager;
import io.keikai.ui.sys.UserActionManagerCtrl;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.event.Event;

public class DefaultUserActionManagerCtrl
implements UserActionManagerCtrl,
UserActionManager {
    private static final long serialVersionUID = 1L;
    private final Set<String> _interestedEvents = new LinkedHashSet<String>();
    private static final String CLIPBOARD_KEY = "$keikai.clipboard$";
    private Map<String, List<UserActionHandler>> _handlerMap = new HashMap<String, List<UserActionHandler>>();
    protected static final char SPLIT_CHAR = '/';
    Spreadsheet _sparedsheet;

    @Override
    public void bind(Spreadsheet sparedsheet) {
        this._sparedsheet = sparedsheet;
    }

    public DefaultUserActionManagerCtrl() {
        this._interestedEvents.add("onAuxAction");
        this._interestedEvents.add("onSheetSelect");
        this._interestedEvents.add("onCtrlKey");
        this._interestedEvents.add("onCancel");
        this._interestedEvents.add("onStartEditing");
        this.initDefaultAuxHandlers();
    }

    private void initDefaultAuxHandlers() {
        String category = Category.AUXACTION.getName();
        this.registerHandler(category, AuxAction.CLOSE_BOOK.getAction(), new CloseBookHandler());
        this.registerHandler(category, AuxAction.ADD_SHEET.getAction(), new AddSheetHandler());
        this.registerHandler(category, AuxAction.DELETE_SHEET.getAction(), new DeleteSheetHandler());
        this.registerHandler(category, AuxAction.RENAME_SHEET.getAction(), new RenameSheetHandler());
        this.registerHandler(category, AuxAction.COPY_SHEET.getAction(), new CopySheetHandler());
        this.registerHandler(category, AuxAction.MOVE_SHEET_LEFT.getAction(), new MoveSheetHandler(true));
        this.registerHandler(category, AuxAction.MOVE_SHEET_RIGHT.getAction(), new MoveSheetHandler(false));
        this.registerHandler(category, AuxAction.GRIDLINES.getAction(), new DisplayGridlinesAction());
        this.registerHandler(category, AuxAction.PASTE.getAction(), new PasteHandler());
        this.registerHandler(category, AuxAction.CUT.getAction(), new CutHandler());
        this.registerHandler(category, AuxAction.COPY.getAction(), new CopyHandler());
        this.registerHandler(category, AuxAction.FONT_FAMILY.getAction(), new FontFamilyHandler());
        this.registerHandler(category, AuxAction.FONT_SIZE.getAction(), new FontSizeHandler());
        this.registerHandler(category, AuxAction.FONT_BOLD.getAction(), new FontBoldHandler());
        this.registerHandler(category, AuxAction.FONT_ITALIC.getAction(), new FontItalicHandler());
        this.registerHandler(category, AuxAction.FONT_UNDERLINE.getAction(), new FontUnderlineHandler());
        this.registerHandler(category, AuxAction.FONT_STRIKE.getAction(), new FontStrikeoutHandler());
        this.registerHandler(category, AuxAction.FONT_TYPEOFFSET.getAction(), new FontTypeOffsetHandler());
        this.registerHandler(category, AuxAction.BORDER.getAction(), new ApplyBorderHandler(Range.ApplyBorderType.EDGE_BOTTOM, CellStyle.BorderType.THIN));
        this.registerHandler(category, AuxAction.BORDER_BOTTOM.getAction(), new ApplyBorderHandler(Range.ApplyBorderType.EDGE_BOTTOM, CellStyle.BorderType.THIN));
        this.registerHandler(category, AuxAction.BORDER_TOP.getAction(), new ApplyBorderHandler(Range.ApplyBorderType.EDGE_TOP, CellStyle.BorderType.THIN));
        this.registerHandler(category, AuxAction.BORDER_LEFT.getAction(), new ApplyBorderHandler(Range.ApplyBorderType.EDGE_LEFT, CellStyle.BorderType.THIN));
        this.registerHandler(category, AuxAction.BORDER_RIGHT.getAction(), new ApplyBorderHandler(Range.ApplyBorderType.EDGE_RIGHT, CellStyle.BorderType.THIN));
        this.registerHandler(category, AuxAction.BORDER_NO.getAction(), new ApplyBorderHandler(Range.ApplyBorderType.FULL, CellStyle.BorderType.NONE));
        this.registerHandler(category, AuxAction.BORDER_ALL.getAction(), new ApplyBorderHandler(Range.ApplyBorderType.FULL, CellStyle.BorderType.THIN));
        this.registerHandler(category, AuxAction.BORDER_OUTSIDE.getAction(), new ApplyBorderHandler(Range.ApplyBorderType.OUTLINE, CellStyle.BorderType.THIN));
        this.registerHandler(category, AuxAction.BORDER_INSIDE.getAction(), new ApplyBorderHandler(Range.ApplyBorderType.INSIDE, CellStyle.BorderType.THIN));
        this.registerHandler(category, AuxAction.BORDER_INSIDE_HORIZONTAL.getAction(), new ApplyBorderHandler(Range.ApplyBorderType.INSIDE_HORIZONTAL, CellStyle.BorderType.THIN));
        this.registerHandler(category, AuxAction.BORDER_INSIDE_VERTICAL.getAction(), new ApplyBorderHandler(Range.ApplyBorderType.INSIDE_VERTICAL, CellStyle.BorderType.THIN));
        this.registerHandler(category, AuxAction.FONT_COLOR.getAction(), new FontColorHandler());
        this.registerHandler(category, AuxAction.FILL_COLOR.getAction(), new FillColorHandler());
        this.registerHandler(category, AuxAction.BACK_COLOR.getAction(), new BackColorHandler());
        this.registerHandler(category, AuxAction.VERTICAL_ALIGN_TOP.getAction(), new VerticalAlignHandler(CellStyle.VerticalAlignment.TOP));
        this.registerHandler(category, AuxAction.VERTICAL_ALIGN_MIDDLE.getAction(), new VerticalAlignHandler(CellStyle.VerticalAlignment.CENTER));
        this.registerHandler(category, AuxAction.VERTICAL_ALIGN_BOTTOM.getAction(), new VerticalAlignHandler(CellStyle.VerticalAlignment.BOTTOM));
        this.registerHandler(category, AuxAction.HORIZONTAL_ALIGN_LEFT.getAction(), new HorizontalAlignHandler(CellStyle.Alignment.LEFT));
        this.registerHandler(category, AuxAction.HORIZONTAL_ALIGN_CENTER.getAction(), new HorizontalAlignHandler(CellStyle.Alignment.CENTER));
        this.registerHandler(category, AuxAction.HORIZONTAL_ALIGN_RIGHT.getAction(), new HorizontalAlignHandler(CellStyle.Alignment.RIGHT));
        this.registerHandler(category, AuxAction.WRAP_TEXT.getAction(), new WrapTextHandler());
        this.registerHandler(category, AuxAction.TEXT_INDENT_INCREASE.getAction(), new TextIndentHandler(1));
        this.registerHandler(category, AuxAction.TEXT_INDENT_DECREASE.getAction(), new TextIndentHandler(-1));
        this.registerHandler(category, AuxAction.INSERT_SHIFT_CELL_RIGHT.getAction(), new InsertCellRightHandler());
        this.registerHandler(category, AuxAction.INSERT_SHIFT_CELL_DOWN.getAction(), new InsertCellDownHandler());
        this.registerHandler(category, AuxAction.INSERT_SHEET_ROW.getAction(), new InsertRowHandler());
        this.registerHandler(category, AuxAction.INSERT_SHEET_COLUMN.getAction(), new InsertColumnHandler());
        this.registerHandler(category, AuxAction.DELETE_SHIFT_CELL_LEFT.getAction(), new DeleteCellLeftHandler());
        this.registerHandler(category, AuxAction.DELETE_SHIFT_CELL_UP.getAction(), new DeleteCellUpHandler());
        this.registerHandler(category, AuxAction.DELETE_SHEET_ROW.getAction(), new DeleteRowHandler());
        this.registerHandler(category, AuxAction.DELETE_SHEET_COLUMN.getAction(), new DeleteColumnHandler());
        this.registerHandler(category, AuxAction.SORT_ASCENDING.getAction(), new SortHandler(false));
        this.registerHandler(category, AuxAction.SORT_DESCENDING.getAction(), new SortHandler(true));
        this.registerHandler(category, AuxAction.CLEAR_CONTENT.getAction(), new ClearCellHandler(ClearCellAction.Type.CONTENT));
        this.registerHandler(category, AuxAction.CLEAR_STYLE.getAction(), new ClearCellHandler(ClearCellAction.Type.STYLE));
        this.registerHandler(category, AuxAction.CLEAR_ALL.getAction(), new ClearCellHandler(ClearCellAction.Type.ALL));
        this.registerHandler(category, AuxAction.HIDE_COLUMN.getAction(), new HideHeaderHandler(HideHeaderAction.Type.COLUMN, true));
        this.registerHandler(category, AuxAction.UNHIDE_COLUMN.getAction(), new HideHeaderHandler(HideHeaderAction.Type.COLUMN, false));
        this.registerHandler(category, AuxAction.HIDE_ROW.getAction(), new HideHeaderHandler(HideHeaderAction.Type.ROW, true));
        this.registerHandler(category, AuxAction.UNHIDE_ROW.getAction(), new HideHeaderHandler(HideHeaderAction.Type.ROW, false));
        this.registerHandler(category, AuxAction.ADD_ROW.getAction(), new AddRowHandler());
        this.registerHandler(category, AuxAction.ADD_COLUMN.getAction(), new AddColumnHandler());
        AbstractHandler folderhandler = new AbstractHandler(){
            private static final long serialVersionUID = -8432478971347806399L;

            @Override
            protected boolean processAction(UserActionContext ctx) {
                return false;
            }
        };
        AbstractCellHandler cellfolderhandler = new AbstractCellHandler(){
            private static final long serialVersionUID = -5609262169871048327L;

            @Override
            protected boolean processAction(UserActionContext ctx) {
                return false;
            }
        };
        AbstractHandler sortfolderhandler = new AbstractHandler(){
            private static final long serialVersionUID = -7703640984068234979L;

            @Override
            protected boolean processAction(UserActionContext ctx) {
                return false;
            }

            @Override
            public boolean isEnabled(Book book, Sheet sheet) {
                return book != null && sheet != null && (!sheet.isProtected() || Ranges.range(sheet).getSheetProtection().isSortAllowed());
            }
        };
        this.registerHandler(category, AuxAction.VERTICAL_ALIGN.getAction(), cellfolderhandler);
        this.registerHandler(category, AuxAction.HORIZONTAL_ALIGN.getAction(), cellfolderhandler);
        this.registerHandler(category, AuxAction.INSERT.getAction(), folderhandler);
        this.registerHandler(category, AuxAction.DELETE.getAction(), folderhandler);
        this.registerHandler(category, AuxAction.SORT_AND_FILTER.getAction(), sortfolderhandler);
        this.registerHandler(category, AuxAction.CLEAR.getAction(), folderhandler);
        category = Category.KEYSTROKE.getName();
        this.registerHandler(category, "^Z", new AbstractBookHandler(){
            private static final long serialVersionUID = -504443727571681016L;

            @Override
            protected boolean processAction(UserActionContext ctx) {
                DefaultUserActionManagerCtrl.this.doUndo();
                return true;
            }
        });
        this.registerHandler(category, "^Y", new AbstractBookHandler(){
            private static final long serialVersionUID = -527097451854686813L;

            @Override
            protected boolean processAction(UserActionContext ctx) {
                DefaultUserActionManagerCtrl.this.doRedo();
                return true;
            }
        });
        this.registerHandler(category, "^X", new CutHandler());
        this.registerHandler(category, "^C", new CopyHandler());
        this.registerHandler(category, "^V", new PasteHandler());
        this.registerHandler(category, "^B", new FontBoldHandler());
        this.registerHandler(category, "^I", new FontItalicHandler());
        this.registerHandler(category, "^U", new FontUnderlineHandler());
        this.registerHandler(category, "#del", new ClearCellHandler(ClearCellAction.Type.CONTENT));
        category = Category.EVENT.getName();
    }

    protected boolean dispatchAuxAction(UserActionContext ctx) {
        boolean r = false;
        for (UserActionHandler uac : this.getHandlerList(ctx.getCategory(), ctx.getAction())) {
            if (uac == null || !uac.isEnabled(ctx.getBook(), ctx.getSheet())) continue;
            r |= uac.process(ctx);
        }
        return r;
    }

    @Override
    public String getCtrlKeys() {
        return "^Z^Y^X^C^V^B^I^U#del";
    }

    protected String getAction(org.zkoss.zk.ui.event.KeyEvent event) {
        StringBuilder sb = new StringBuilder();
        int keyCode = event.getKeyCode();
        boolean ctrlKey = event.isCtrlKey();
        boolean shiftKey = event.isShiftKey();
        boolean altKey = event.isAltKey();
        switch (keyCode) {
            case 46: {
                sb.append("#del");
            }
        }
        if (sb.length() == 0 && keyCode >= 65 && keyCode <= 90) {
            if (ctrlKey) {
                sb.append("^");
            }
            if (altKey) {
                sb.append("@");
            }
            if (shiftKey) {
                sb.append("$");
            }
            sb.append(Character.toString((char)keyCode).toUpperCase());
        }
        return sb.toString();
    }

    protected boolean dispatchKeyAction(UserActionContext ctx) {
        KeyEvent event = (KeyEvent)ctx.getEvent();
        String action = ctx.getAction();
        if (event != null) {
            action = this.getAction(event);
            if (Strings.isBlank((String)action)) {
                return false;
            }
            ((UserActionContextImpl)ctx).setAction(action);
        }
        boolean r = false;
        for (UserActionHandler uac : this.getHandlerList(ctx.getCategory(), ctx.getAction())) {
            if (uac == null || !uac.isEnabled(ctx.getBook(), ctx.getSheet())) continue;
            r |= uac.process(ctx);
        }
        return r;
    }

    @Override
    public Set<String> getSupportedUserAction(Sheet sheet) {
        LinkedHashSet<String> actions = new LinkedHashSet<String>();
        Book book = sheet == null ? null : sheet.getBook();
        String auxkey = Category.AUXACTION.getName() + '/';
        block0: for (Map.Entry<String, List<UserActionHandler>> entry : this._handlerMap.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(auxkey)) continue;
            for (UserActionHandler handler : entry.getValue()) {
                if (!handler.isEnabled(book, sheet)) continue;
                actions.add(key.substring(auxkey.length()));
                continue block0;
            }
        }
        return actions;
    }

    @Override
    public Set<String> getInterestedEvents() {
        return Collections.unmodifiableSet(this._interestedEvents);
    }

    private CellSelectionType getCellSelectionType(String type) {
        if ("col".equals(type)) {
            return CellSelectionType.COLUMN;
        }
        if ("row".equals(type)) {
            return CellSelectionType.ROW;
        }
        if ("all".equals(type)) {
            return CellSelectionType.ALL;
        }
        return CellSelectionType.CELL;
    }

    public void onEvent(Event event) throws Exception {
        SBook sbook;
        AreaRef selection;
        String nm = event.getName();
        if (!this._interestedEvents.contains(nm)) {
            return;
        }
        Spreadsheet spreadsheet = (Spreadsheet)event.getTarget();
        Book book = spreadsheet.getBook();
        Sheet sheet = spreadsheet.getSelectedSheet();
        String action = "";
        AreaRef uiSelection = spreadsheet.getSelection();
        HashMap<String, Object> extraData = null;
        if ("onCtrlKey".equals(nm)) {
            selection = ((KeyEvent)event).getSelection();
        } else if ("onAuxAction".equals(nm)) {
            AuxActionEvent evt = (AuxActionEvent)event;
            selection = evt.getSelection();
            sheet = evt.getSheet();
            action = evt.getAction();
            extraData = new HashMap(evt.getExtraData());
        } else {
            selection = uiSelection;
        }
        if (extraData == null) {
            extraData = new HashMap<String, Object>();
        }
        AreaRef visibleSelection = new AreaRef(selection.getRow(), selection.getColumn(), Math.min(spreadsheet.getCurrentMaxVisibleRows(), selection.getLastRow()), Math.min(spreadsheet.getCurrentMaxVisibleColumns(), selection.getLastColumn()));
        CellSelectionType selType = this.getCellSelectionType((String)extraData.get("type"));
        SBook sBook = sbook = book == null ? null : book.getInternalBook();
        if (sbook != null) {
            boolean wholeSheet;
            boolean wholeRow = uiSelection.getColumn() == 0 && uiSelection.getLastColumn() >= sbook.getMaxColumnIndex();
            boolean wholeColumn = uiSelection.getRow() == 0 && uiSelection.getLastRow() >= sbook.getMaxRowIndex();
            boolean bl = wholeSheet = wholeRow && wholeColumn;
            CellSelectionType cellSelectionType = wholeSheet ? CellSelectionType.ALL : (wholeRow ? CellSelectionType.ROW : (selType = wholeColumn ? CellSelectionType.COLUMN : CellSelectionType.CELL));
        }
        if ("onAuxAction".equals(nm)) {
            UserActionContextImpl ctx = new UserActionContextImpl(this._sparedsheet, event, book, sheet, visibleSelection, selType, extraData, Category.AUXACTION.getName(), action);
            this.dispatchAuxAction(ctx);
        } else if ("onSheetSelect".equals(nm)) {
            this.updateClipboardEffect(sheet);
        } else if ("onCtrlKey".equals(nm)) {
            KeyEvent kevt = (KeyEvent)event;
            UserActionContextImpl ctx = new UserActionContextImpl(this._sparedsheet, event, book, sheet, visibleSelection, selType, extraData, Category.KEYSTROKE.getName(), action);
            boolean r = this.dispatchKeyAction(ctx);
            if (r && kevt.isCtrlKey() && kevt.getKeyCode() == 86) {
                this._sparedsheet.smartUpdate("doPasteFromServer", true);
            }
        } else if ("onStartEditing".equals(nm)) {
            this.clearClipboard();
        } else if ("onCancel".equals(nm)) {
            this.clearClipboard();
        }
    }

    protected void updateClipboardEffect(Sheet sheet) {
        UserActionContext.Clipboard cb = this.getClipboard();
        if (cb != null) {
            try {
                Sheet src = cb.getSheet();
                src.getBook();
                if (sheet.equals(src)) {
                    this._sparedsheet.setHighlight(cb.getSelection());
                } else {
                    this._sparedsheet.setHighlight(null);
                }
            }
            catch (Exception x) {
                this.clearClipboard();
            }
        }
    }

    @Override
    public void doAfterLoadBook(Book book) {
        this.clearClipboard();
    }

    protected UserActionContext.Clipboard getClipboard() {
        return (UserActionContext.Clipboard)this._sparedsheet.getAttribute(CLIPBOARD_KEY);
    }

    protected void clearClipboard() {
        UserActionContext.Clipboard cp = (UserActionContext.Clipboard)this._sparedsheet.removeAttribute(CLIPBOARD_KEY);
        if (cp != null) {
            this._sparedsheet.setHighlight(null);
        }
    }

    private String getKey(String category, String action) {
        return category + '/' + action;
    }

    private void registerHandler(String category, String action, UserActionHandler handler, boolean reset) {
        if (category.indexOf(47) >= 0) {
            throw new IllegalArgumentException("category can't contain /, " + category + "," + action);
        }
        String key = this.getKey(category, action);
        List<UserActionHandler> handlers = this._handlerMap.get(key);
        if (handlers == null) {
            handlers = new LinkedList<UserActionHandler>();
            this._handlerMap.put(key, handlers);
        } else if (reset) {
            handlers.clear();
        }
        if (!handlers.contains(handler)) {
            handlers.add(handler);
        }
    }

    @Override
    public void registerHandler(String category, String action, UserActionHandler handler) {
        this.registerHandler(category, action, handler, false);
    }

    @Override
    public void setHandler(String category, String action, UserActionHandler handler) {
        this.registerHandler(category, action, handler, true);
    }

    protected List<UserActionHandler> getHandlerList(String category, String action) {
        List<UserActionHandler> list = this._handlerMap.get(this.getKey(category, action));
        return list == null ? Collections.EMPTY_LIST : list;
    }

    protected boolean doUndo() {
        UndoableActionManager uam = this._sparedsheet.getUndoableActionManager();
        if (uam != null && uam.isUndoable()) {
            uam.undoAction();
        }
        return true;
    }

    protected boolean doRedo() {
        UndoableActionManager uam = this._sparedsheet.getUndoableActionManager();
        if (uam != null && uam.isRedoable()) {
            uam.redoAction();
        }
        return true;
    }

    protected void clearUndoable() {
        UndoableActionManager uam = this._sparedsheet.getUndoableActionManager();
        if (uam != null) {
            uam.clear();
        }
    }

    public static class ClipboardImpl
    implements UserActionContext.Clipboard {
        final Spreadsheet _ss;
        final AreaRef _selection;
        final Sheet _sheet;
        final boolean _cutMode;
        final Object _info;

        public ClipboardImpl(Spreadsheet ss, Sheet sheet, AreaRef selection, boolean cutMode, Object info) {
            if (sheet == null) {
                throw new IllegalArgumentException("Sheet is null");
            }
            if (selection == null) {
                throw new IllegalArgumentException("selection is null");
            }
            this._ss = ss;
            this._sheet = sheet;
            this._selection = selection;
            this._cutMode = cutMode;
            this._info = info;
        }

        @Override
        public Sheet getSheet() {
            return this._sheet;
        }

        @Override
        public AreaRef getSelection() {
            return this._selection;
        }

        @Override
        public Object getInfo() {
            return this._info;
        }

        @Override
        public boolean isCutMode() {
            return this._cutMode;
        }

        @Override
        public AreaRefWithType getSelectionWithType() {
            return (AreaRefWithType)this._selection;
        }

        @Override
        public int getSheetMaxVisibleRows() {
            return this._ss.getSheetMaxVisibleRows(this._sheet.getInternalSheet());
        }

        @Override
        public int getSheetMaxVisibleColumns() {
            return this._ss.getSheetMaxVisibleColumns(this._sheet.getInternalSheet());
        }
    }

    public static class UserActionContextImpl
    implements UserActionContext {
        Spreadsheet _spreadsheet;
        Book _book;
        Sheet _sheet;
        AreaRef _selection;
        CellSelectionType _selectionType;
        Map<String, Object> _data;
        String _category;
        String _action;
        Event _event;

        public UserActionContextImpl(Spreadsheet ss, Event event, Book book, Sheet sheet, AreaRef selection, CellSelectionType selectionType, Map<String, Object> data, String category, String action) {
            this._spreadsheet = ss;
            this._sheet = sheet;
            this._book = book;
            this._selection = selection;
            this._selectionType = selectionType;
            this._data = data;
            this._category = category;
            this._action = action;
            this._event = event;
        }

        @Override
        public int getSheetMaxVisibleRows() {
            return this._spreadsheet.getSheetMaxVisibleRows(this._sheet.getInternalSheet());
        }

        @Override
        public int getSheetMaxVisibleColumns() {
            return this._spreadsheet.getSheetMaxVisibleColumns(this._sheet.getInternalSheet());
        }

        @Override
        public Book getBook() {
            return this._book;
        }

        @Override
        public Sheet getSheet() {
            return this._sheet;
        }

        @Override
        public Event getEvent() {
            return this._event;
        }

        @Override
        public Spreadsheet getSpreadsheet() {
            return this._spreadsheet;
        }

        @Override
        public AreaRef getSelection() {
            return this._selection;
        }

        @Override
        public AreaRefWithType getSelectionWithType() {
            return new AreaRefWithType(this._selection.getRow(), this._selection.getColumn(), this._selection.getLastRow(), this._selection.getLastColumn(), this._selectionType);
        }

        @Override
        public CellSelectionType getSelectionType() {
            return this._selectionType;
        }

        @Override
        public Object getData(String key) {
            return this._data == null ? null : this._data.get(key);
        }

        @Override
        public String getCategory() {
            return this._category;
        }

        @Override
        public String getAction() {
            return this._action;
        }

        public void setAction(String action) {
            this._action = action;
        }

        public void setData(String key, Object value) {
            if (this._data == null) {
                this._data = new HashMap<String, Object>();
            }
            this._data.put(key, value);
        }

        @Override
        public UserActionContext.Clipboard getClipboard() {
            return (UserActionContext.Clipboard)this.getSpreadsheet().getAttribute(DefaultUserActionManagerCtrl.CLIPBOARD_KEY);
        }

        @Override
        public void clearClipboard() {
            Spreadsheet ss = this.getSpreadsheet();
            UserActionContext.Clipboard cp = (UserActionContext.Clipboard)ss.removeAttribute(DefaultUserActionManagerCtrl.CLIPBOARD_KEY);
            if (cp != null) {
                this.getSpreadsheet().setHighlight(null);
            }
        }

        @Override
        public void setClipboard(Sheet sheet, AreaRef selection, boolean cutMode, Object info) {
            this.getSpreadsheet().setAttribute(DefaultUserActionManagerCtrl.CLIPBOARD_KEY, new ClipboardImpl(this._spreadsheet, sheet, selection, cutMode, info));
            if (sheet.equals(this.getSpreadsheet().getSelectedSheet())) {
                this.getSpreadsheet().setHighlight(selection);
            }
        }
    }

    public static enum Category {
        AUXACTION("aux"),
        KEYSTROKE("key"),
        EVENT("event");

        private final String name;

        private Category(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }
}

