/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.ListenerConfig;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.EventListener;

public class EntryListenerConfig
extends ListenerConfig {
    private boolean local;
    private boolean includeValue = true;

    public EntryListenerConfig() {
    }

    public EntryListenerConfig(String className, boolean local, boolean includeValue) {
        super(className);
        this.local = local;
        this.includeValue = includeValue;
    }

    public EntryListenerConfig(MapListener implementation, boolean local, boolean includeValue) {
        super(implementation);
        this.local = local;
        this.includeValue = includeValue;
    }

    public EntryListenerConfig(EntryListenerConfig config) {
        this.includeValue = config.isIncludeValue();
        this.local = config.isLocal();
        this.implementation = config.getImplementation();
        this.className = config.getClassName();
    }

    @Override
    public ListenerConfig setImplementation(EventListener implementation) {
        Preconditions.checkInstanceOf(MapListener.class, Preconditions.isNotNull(implementation, "implementation"));
        super.setImplementation(implementation);
        return this;
    }

    public EntryListenerConfig setImplementation(MapListener implementation) {
        super.setImplementation(implementation);
        return this;
    }

    @Override
    public MapListener getImplementation() {
        return (MapListener)this.implementation;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    public EntryListenerConfig setLocal(boolean local) {
        this.local = local;
        return this;
    }

    @Override
    public boolean isIncludeValue() {
        return this.includeValue;
    }

    public EntryListenerConfig setIncludeValue(boolean includeValue) {
        this.includeValue = includeValue;
        return this;
    }

    @Override
    public String toString() {
        return "EntryListenerConfig{local=" + this.local + ", includeValue=" + this.includeValue + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EntryListenerConfig that = (EntryListenerConfig)o;
        if (this.includeValue != that.includeValue) {
            return false;
        }
        return this.local == that.local;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.local ? 1 : 0);
        result = 31 * result + (this.includeValue ? 1 : 0);
        return result;
    }

    @Override
    public int getClassId() {
        return 10;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeBoolean(this.local);
        out.writeBoolean(this.includeValue);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.local = in.readBoolean();
        this.includeValue = in.readBoolean();
    }
}

