/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpc;

import com.hazelcast.client.impl.ClientEndpoint;
import com.hazelcast.client.impl.ClientEngine;
import com.hazelcast.client.impl.TpcToken;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.ClientMessageReader;
import com.hazelcast.client.impl.protocol.codec.ExperimentalTpcAuthenticationCodec;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.tpcengine.net.AsyncSocketReader;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nullable;

public class ClientAsyncSocketReader
extends AsyncSocketReader {
    private static final byte[] PROTOCOL_BYTES = "CP2".getBytes(StandardCharsets.UTF_8);
    private final ClientEngine clientEngine;
    private final ClientMessageReader clientMessageReader;
    private boolean protocolBytesReceived;
    private boolean trusted;
    private Connection connection;

    public ClientAsyncSocketReader(ClientEngine clientEngine, HazelcastProperties properties) {
        this.clientEngine = clientEngine;
        int maxMessageLength = properties.getInteger(ClusterProperty.CLIENT_PROTOCOL_UNVERIFIED_MESSAGE_BYTES);
        this.clientMessageReader = new ClientMessageReader(maxMessageLength);
    }

    @Override
    public void onRead(ByteBuffer src) {
        if (!this.protocolBytesReceived && !this.consumeProtocolBytes(src)) {
            return;
        }
        while (this.clientMessageReader.readFrom(src, this.trusted)) {
            ClientMessage message = this.clientMessageReader.getClientMessage();
            this.clientMessageReader.reset();
            if (this.connection == null) {
                this.loadConnection(message);
            }
            message.setConnection(this.connection);
            message.setAsyncSocket(this.socket);
            this.clientEngine.accept(message);
        }
        return;
    }

    private boolean consumeProtocolBytes(ByteBuffer buffer) {
        if (buffer.remaining() < PROTOCOL_BYTES.length) {
            return false;
        }
        if (buffer.get() != PROTOCOL_BYTES[0] || buffer.get() != PROTOCOL_BYTES[1] || buffer.get() != PROTOCOL_BYTES[2]) {
            throw new IllegalStateException("Received unexpected protocol bytes over socket " + this.socket);
        }
        this.protocolBytesReceived = true;
        return true;
    }

    private void loadConnection(ClientMessage message) {
        if (message.getMessageType() != 16581376) {
            throw new IllegalStateException("Illegal attempt to use " + this.socket + " before authentication");
        }
        ExperimentalTpcAuthenticationCodec.RequestParameters request = ExperimentalTpcAuthenticationCodec.decodeRequest(message);
        ClientEndpoint endpoint = this.findClientEndpoint(request.uuid);
        if (endpoint == null) {
            throw new IllegalStateException("Could not find a connection for client: " + request.uuid + " over socket " + this.socket);
        }
        TpcToken token = endpoint.getTpcToken();
        if (token == null || !token.matches(request.token)) {
            throw new IllegalStateException("The authentication token sent over socket " + this.socket + " by the client " + request.uuid + " is not correct.");
        }
        this.connection = endpoint.getConnection();
        this.trusted = true;
    }

    @Nullable
    private ClientEndpoint findClientEndpoint(UUID clientId) {
        Collection<ClientEndpoint> endpoints = this.clientEngine.getEndpointManager().getEndpoints();
        for (ClientEndpoint endpoint : endpoints) {
            if (!clientId.equals(endpoint.getUuid())) continue;
            return endpoint;
        }
        return null;
    }
}

