/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.eviction;

import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.internal.eviction.Evictable;
import com.hazelcast.internal.eviction.EvictionConfiguration;
import com.hazelcast.internal.eviction.impl.comparator.LFUEvictionPolicyComparator;
import com.hazelcast.internal.eviction.impl.comparator.LRUEvictionPolicyComparator;
import com.hazelcast.internal.eviction.impl.comparator.RandomEvictionPolicyComparator;
import com.hazelcast.internal.eviction.impl.evaluator.EvictionPolicyEvaluator;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.spi.eviction.EvictionPolicyComparator;

public final class EvictionPolicyEvaluatorProvider {
    private EvictionPolicyEvaluatorProvider() {
    }

    public static <A, E extends Evictable> EvictionPolicyEvaluator<A, E> getEvictionPolicyEvaluator(EvictionConfiguration evictionConfig, ClassLoader classLoader) {
        Preconditions.checkNotNull(evictionConfig);
        return new EvictionPolicyEvaluator(EvictionPolicyEvaluatorProvider.getEvictionPolicyComparator(evictionConfig, classLoader));
    }

    public static EvictionPolicyComparator getEvictionPolicyComparator(EvictionConfiguration evictionConfig, ClassLoader classLoader) {
        String evictionPolicyComparatorClassName = evictionConfig.getComparatorClassName();
        if (!StringUtil.isNullOrEmpty(evictionPolicyComparatorClassName)) {
            try {
                return (EvictionPolicyComparator)ClassLoaderUtil.newInstance(classLoader, evictionPolicyComparatorClassName);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        EvictionPolicyComparator comparator = evictionConfig.getComparator();
        if (comparator != null) {
            return comparator;
        }
        return EvictionPolicyEvaluatorProvider.pickOutOfTheBoxComparator(evictionConfig.getEvictionPolicy());
    }

    private static EvictionPolicyComparator pickOutOfTheBoxComparator(EvictionPolicy evictionPolicy) {
        switch (evictionPolicy) {
            case LRU: {
                return LRUEvictionPolicyComparator.INSTANCE;
            }
            case LFU: {
                return LFUEvictionPolicyComparator.INSTANCE;
            }
            case RANDOM: {
                return RandomEvictionPolicyComparator.INSTANCE;
            }
            case NONE: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unsupported eviction policy: " + (Object)((Object)evictionPolicy));
    }
}

