/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.internal.eviction.ExpiredKey;
import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.monitor.LocalRecordStoreStats;
import com.hazelcast.internal.monitor.impl.LocalRecordStoreStatsImpl;
import com.hazelcast.internal.nearcache.impl.invalidation.InvalidationQueue;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.iterator.MapEntriesWithCursor;
import com.hazelcast.map.impl.iterator.MapKeysWithCursor;
import com.hazelcast.map.impl.mapstore.MapDataStore;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordFactory;
import com.hazelcast.map.impl.recordstore.JsonMetadataStore;
import com.hazelcast.map.impl.recordstore.Storage;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryReason;
import com.hazelcast.map.impl.recordstore.expiry.ExpirySystem;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import com.hazelcast.wan.impl.CallerProvenance;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface RecordStore<R extends Record> {
    public ExpirySystem getExpirySystem();

    public String getName();

    public Object set(Data var1, Object var2, long var3, long var5);

    public Object setTxn(Data var1, Object var2, long var3, long var5, UUID var7);

    public Object removeTxn(Data var1, CallerProvenance var2, UUID var3);

    public Object put(Data var1, Object var2, long var3, long var5);

    public Object putIfAbsent(Data var1, Object var2, long var3, long var5, Address var7);

    public R putBackup(Data var1, Object var2, boolean var3, long var4, long var6, long var8, CallerProvenance var10);

    public R putBackup(Data var1, Record var2, ExpiryMetadata var3, boolean var4, CallerProvenance var5);

    public R putBackup(Data var1, Record var2, long var3, long var5, long var7, CallerProvenance var9);

    public R putBackupTxn(Data var1, Record var2, ExpiryMetadata var3, boolean var4, CallerProvenance var5, UUID var6);

    public boolean setWithUncountedAccess(Data var1, Object var2, boolean var3, long var4, long var6);

    public Object remove(Data var1, CallerProvenance var2);

    public boolean delete(Data var1, CallerProvenance var2);

    public boolean remove(Data var1, Object var2);

    public boolean setTtl(Data var1, long var2);

    public boolean setTtlBackup(Data var1, long var2);

    public void accessRecord(Data var1, Record var2, long var3);

    public void removeBackup(Data var1, CallerProvenance var2);

    public void removeBackupTxn(Data var1, CallerProvenance var2, UUID var3);

    public Object get(Data var1, boolean var2, Address var3, boolean var4);

    default public Object get(Data dataKey, boolean backup, Address callerAddress) {
        return this.get(dataKey, backup, callerAddress, true);
    }

    public Data readBackupData(Data var1);

    public MapEntries getAll(Set<Data> var1, Address var2);

    public boolean existInMemory(Data var1);

    public boolean containsKey(Data var1, Address var2);

    public int getLockedEntryCount();

    public Object replace(Data var1, Object var2);

    public boolean replace(Data var1, Object var2, Object var3);

    public Object putTransient(Data var1, Object var2, long var3, long var5);

    public Object putFromLoad(Data var1, Object var2, Address var3);

    public Object putFromLoad(Data var1, Object var2, long var3, Address var5);

    public Object putFromLoadBackup(Data var1, Object var2);

    public Object putFromLoadBackup(Data var1, Object var2, long var3);

    public boolean merge(SplitBrainMergeTypes.MapMergeTypes<Object, Object> var1, SplitBrainMergePolicy<Object, SplitBrainMergeTypes.MapMergeTypes<Object, Object>, Object> var2, CallerProvenance var3);

    public R getRecord(Data var1);

    public R putOrUpdateReplicatedRecord(Data var1, R var2, ExpiryMetadata var3, boolean var4, long var5);

    public void removeReplicatedRecord(Data var1, boolean var2);

    public void forEach(BiConsumer<Data, R> var1, boolean var2);

    public void forEach(BiConsumer<Data, Record> var1, boolean var2, boolean var3);

    public Iterator<Map.Entry<Data, Record>> iterator();

    public void forEachAfterLoad(BiConsumer<Data, R> var1, boolean var2);

    public MapKeysWithCursor fetchKeys(IterationPointer[] var1, int var2);

    public MapEntriesWithCursor fetchEntries(IterationPointer[] var1, int var2);

    public int size();

    public boolean txnLock(Data var1, UUID var2, long var3, long var5, long var7, boolean var9);

    public boolean extendLock(Data var1, UUID var2, long var3, long var5);

    public boolean localLock(Data var1, UUID var2, long var3, long var5, long var7);

    public boolean lock(Data var1, UUID var2, long var3, long var5, long var7);

    public boolean isLockedBy(Data var1, UUID var2, long var3);

    public boolean unlock(Data var1, UUID var2, long var3, long var5);

    public boolean isLocked(Data var1);

    public boolean isTransactionallyLocked(Data var1);

    public boolean canAcquireLock(Data var1, UUID var2, long var3);

    public String getLockOwnerInfo(Data var1);

    public boolean containsValue(Object var1);

    @Nullable
    public Object evict(Data var1, boolean var2);

    public int evictAll(boolean var1);

    public MapContainer getMapContainer();

    public long softFlush();

    public boolean forceUnlock(Data var1);

    public long getOwnedEntryCost();

    public boolean isEmpty();

    public void evictExpiredEntries(int var1, long var2, boolean var4);

    public boolean isExpirable();

    public ExpiryReason hasExpired(Data var1, long var2, boolean var4);

    public boolean isExpired(Data var1, long var2, boolean var4);

    public void doPostEvictionOperations(@Nonnull Data var1, @Nonnull Object var2, @Nonnull ExpiryReason var3);

    public MapDataStore<Data, Object> getMapDataStore();

    public InvalidationQueue<ExpiredKey> getExpiredKeysQueue();

    public int getPartitionId();

    public R getRecordOrNull(Data var1, boolean var2);

    public boolean evictIfExpired(Data var1, long var2, boolean var4);

    public void evictExpiredEntryAndPublishExpiryEvent(Data var1, ExpiryReason var2, boolean var3);

    public void evictEntries(Data var1);

    public boolean shouldEvict();

    public Storage createStorage(RecordFactory<R> var1, InMemoryFormat var2);

    public R createRecord(Data var1, Object var2, long var3);

    public R loadRecordOrNull(Data var1, boolean var2, Address var3);

    public void disposeDeferredBlocks();

    public void init();

    public JsonMetadataStore getOrCreateMetadataStore();

    public Storage getStorage();

    public void sampleAndForceRemoveEntries(int var1);

    public void startLoading();

    public void setPreMigrationLoadedStatus(boolean var1);

    public boolean isKeyLoadFinished();

    public boolean isLoaded();

    public void checkIfLoaded() throws RetryableHazelcastException;

    public void loadAll(boolean var1);

    public void maybeDoInitialLoad();

    public void loadAllFromStore(List<Data> var1, boolean var2);

    public void updateLoadStatus(boolean var1, Throwable var2);

    public boolean hasQueryCache();

    public void clearPartition(boolean var1, boolean var2);

    public int clear(boolean var1);

    public void reset();

    public void destroy();

    public InMemoryFormat getInMemoryFormat();

    public EvictionPolicy getEvictionPolicy();

    public LocalRecordStoreStatsImpl getLocalRecordStoreStats();

    public void setLocalRecordStoreStats(LocalRecordStoreStats var1);

    default public void beforeOperation() {
    }

    default public void afterOperation() {
    }

    public Set<MapOperation> getOffloadedOperations();

    public void incMapStoreOffloadedOperationsCount();

    public void decMapStoreOffloadedOperationsCount();

    public long getMapStoreOffloadedOperationsCount();
}

