/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.ToLongFunctionEx;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

abstract class StatefulKeyedTransformBase<T, K, S>
extends AbstractTransform {
    private static final int TTL_TO_WM_STRIDE_RATIO = 10;
    final long ttl;
    final FunctionEx<? super T, ? extends K> keyFn;
    final ToLongFunctionEx<? super T> timestampFn;
    final Supplier<? extends S> createFn;

    StatefulKeyedTransformBase(@Nonnull String name, @Nonnull Transform upstream, long ttl, @Nonnull FunctionEx<? super T, ? extends K> keyFn, @Nonnull ToLongFunctionEx<? super T> timestampFn, @Nonnull Supplier<? extends S> createFn) {
        super(name, upstream);
        this.ttl = ttl;
        this.keyFn = keyFn;
        this.timestampFn = timestampFn;
        this.createFn = createFn;
    }

    @Override
    public final long preferredWatermarkStride() {
        return Math.max(1L, this.ttl / 10L);
    }
}

