/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.ptg;

import org.zkoss.poi.ss.formula.EvaluationWorkbook;
import org.zkoss.poi.ss.formula.FormulaRenderingWorkbook;
import org.zkoss.poi.ss.formula.SheetNameFormatter;

final class ExternSheetNameResolver {
    private ExternSheetNameResolver() {
    }

    public static String prependSheetName(FormulaRenderingWorkbook book, int field_1_index_extern_sheet, String cellRefText) {
        StringBuffer sb;
        EvaluationWorkbook.ExternalSheet externalSheet = book.getExternalSheet(field_1_index_extern_sheet);
        if (externalSheet != null) {
            String lastSheetName;
            String wbName = externalSheet.getWorkbookName();
            String sheetName = ExternSheetNameResolver.convertSheetName(externalSheet.getSheetName());
            sheetName = sheetName.equals(lastSheetName = ExternSheetNameResolver.convertSheetName(externalSheet.getLastSheetName())) ? sheetName : sheetName + ":" + lastSheetName;
            sb = new StringBuffer(wbName.length() + sheetName.length() + cellRefText.length() + 4);
            SheetNameFormatter.appendFormat(sb, wbName, sheetName);
        } else {
            String sheetName = ExternSheetNameResolver.convertSheetName(book.getSheetNameByExternSheet(field_1_index_extern_sheet));
            sb = new StringBuffer(sheetName.length() + cellRefText.length() + 4);
            SheetNameFormatter.appendFormat(sb, sheetName);
        }
        sb.append('!');
        sb.append(cellRefText);
        return sb.toString();
    }

    private static String convertSheetName(String sheetName) {
        if ("".equals(sheetName) || sheetName == null) {
            sheetName = "#REF";
        }
        return sheetName;
    }

    public static String prependInternalSheetName(FormulaRenderingWorkbook book, int field_1_index_extern_sheet, String cellRefText) {
        StringBuffer sb;
        EvaluationWorkbook.ExternalSheet externalSheet = book.getExternalSheet(field_1_index_extern_sheet);
        if (externalSheet != null) {
            String lastSheetName;
            String sheetName;
            String wbName = externalSheet.getWorkbookName();
            String wbIndex = book.getExternalLinkIndexFromBookName(wbName);
            if (wbIndex == null) {
                wbIndex = wbName;
            }
            sheetName = (sheetName = ExternSheetNameResolver.convertSheetName(externalSheet.getSheetName())).equals(lastSheetName = ExternSheetNameResolver.convertSheetName(externalSheet.getLastSheetName())) ? sheetName : sheetName + ":" + lastSheetName;
            sb = new StringBuffer(wbIndex.length() + sheetName.length() + cellRefText.length() + 4);
            SheetNameFormatter.appendFormat(sb, wbIndex, sheetName);
        } else {
            String sheetName = ExternSheetNameResolver.convertSheetName(book.getSheetNameByExternSheet(field_1_index_extern_sheet));
            sb = new StringBuffer(sheetName.length() + cellRefText.length() + 4);
            SheetNameFormatter.appendFormat(sb, sheetName);
        }
        sb.append('!');
        sb.append(cellRefText);
        return sb.toString();
    }
}

