/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.StandardRecord;
import org.zkoss.poi.util.BitField;
import org.zkoss.poi.util.HexDump;
import org.zkoss.poi.util.LittleEndianOutput;
import org.zkoss.poi.util.StringUtil;

public final class AutoFilterRecord
extends StandardRecord {
    public static final short sid = 158;
    private short _iEntry;
    private short _flags;
    private byte[] _doper1 = new byte[10];
    private byte[] _doper2 = new byte[10];
    private String _str1;
    private String _str2;
    private int _str1Length = 0;
    private int _str2Length = 0;
    private static final BitField opt_wJoin = new BitField(49152);
    private static final BitField opt_fSimple1 = new BitField(8192);
    private static final BitField opt_fSimple2 = new BitField(4096);
    private static final BitField opt_fTopN = new BitField(2048);
    private static final BitField opt_fTop = new BitField(1024);
    private static final BitField opt_fPercent = new BitField(512);
    private static final BitField opt_wTopN = new BitField(511);

    public AutoFilterRecord() {
    }

    public AutoFilterRecord(RecordInputStream in) {
        boolean isMultibyte;
        byte length;
        this._iEntry = in.readShort();
        this._flags = in.readShort();
        in.read(this._doper1, 0, 10);
        in.read(this._doper2, 0, 10);
        if (this._doper1[0] == 6) {
            length = this._doper1[6];
            isMultibyte = in.readByte() != 0;
            this._str1Length = 1 + length;
            this._str1 = isMultibyte ? StringUtil.readUnicodeLE(in, length) : StringUtil.readCompressedUnicode(in, length);
        }
        if (this._doper2[0] == 6) {
            length = this._doper2[6];
            isMultibyte = in.readByte() != 0;
            this._str2Length = 1 + length;
            this._str2 = isMultibyte ? StringUtil.readUnicodeLE(in, length) : StringUtil.readCompressedUnicode(in, length);
        }
    }

    public void setColEntries(short num) {
        this._iEntry = num;
    }

    public short getColEntries() {
        return this._iEntry;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[AUTOFILTER]\n");
        buffer.append("    .iEntry          = ").append(this._iEntry).append("\n");
        buffer.append("    .flags           = ").append(this._flags).append("\n");
        buffer.append("        .wJoin       = ").append(opt_wJoin.getShortRawValue(this._flags)).append("\n");
        buffer.append("        .fSimple1    = ").append(opt_fSimple1.getShortRawValue(this._flags)).append("\n");
        buffer.append("        .fSimple2    = ").append(opt_fSimple2.getShortRawValue(this._flags)).append("\n");
        buffer.append("        .fTopN       = ").append(opt_fTopN.getShortRawValue(this._flags)).append("\n");
        buffer.append("        .fTop        = ").append(opt_fTop.getShortRawValue(this._flags)).append("\n");
        buffer.append("        .fPercent    = ").append(opt_fPercent.getShortRawValue(this._flags)).append("\n");
        buffer.append("        .wTopN       = ").append(opt_wTopN.getShortRawValue(this._flags)).append("\n");
        buffer.append("    .doper1          = ").append(HexDump.toHex(this._doper1)).append("\n");
        buffer.append("        .vt          = ").append(this._doper1[0]).append("\n");
        buffer.append("        .grbitSign   = ").append(this._doper1[1]).append("\n");
        buffer.append("    .doper2          = ").append(HexDump.toHex(this._doper2)).append("\n");
        buffer.append("        .vt          = ").append(this._doper2[0]).append("\n");
        buffer.append("        .grbitSign   = ").append(this._doper2[1]).append("\n");
        buffer.append("    .str1            = ").append(this._str1).append("\n");
        buffer.append("    .str2            = ").append(this._str2).append("\n");
        buffer.append("[/AUTOFILTER]\n");
        return buffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        out.writeShort(this._iEntry);
    }

    @Override
    protected int getDataSize() {
        return 24 + this._str1Length + this._str2Length;
    }

    @Override
    public short getSid() {
        return 158;
    }

    @Override
    public Object clone() {
        return this.cloneViaReserialise();
    }

    public String getStr1() {
        return this._str1;
    }

    public String getStr2() {
        return this._str2;
    }
}

