/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xmlbeans.XmlOptions;
import org.zkoss.poi.POIXMLException;
import org.zkoss.poi.POIXMLFactory;
import org.zkoss.poi.POIXMLRelation;
import org.zkoss.poi.openxml4j.exceptions.InvalidFormatException;
import org.zkoss.poi.openxml4j.exceptions.OpenXML4JException;
import org.zkoss.poi.openxml4j.exceptions.PartAlreadyExistsException;
import org.zkoss.poi.openxml4j.opc.OPCPackage;
import org.zkoss.poi.openxml4j.opc.PackagePart;
import org.zkoss.poi.openxml4j.opc.PackagePartName;
import org.zkoss.poi.openxml4j.opc.PackageRelationship;
import org.zkoss.poi.openxml4j.opc.PackageRelationshipCollection;
import org.zkoss.poi.openxml4j.opc.PackagingURIHelper;
import org.zkoss.poi.openxml4j.opc.TargetMode;
import org.zkoss.poi.openxml4j.opc.internal.MemoryPackagePart;
import org.zkoss.poi.util.POILogFactory;
import org.zkoss.poi.util.POILogger;

public class POIXMLDocumentPart {
    private static final POILogger logger = POILogFactory.getLogger(POIXMLDocumentPart.class);
    public static final XmlOptions DEFAULT_XML_OPTIONS = new XmlOptions();
    private PackagePart packagePart;
    private PackageRelationship packageRel;
    private POIXMLDocumentPart parent;
    private Map<String, POIXMLDocumentPart> relations = new LinkedHashMap<String, POIXMLDocumentPart>();
    private int relationCounter = 0;

    int incrementRelationCounter() {
        ++this.relationCounter;
        return this.relationCounter;
    }

    int decrementRelationCounter() {
        --this.relationCounter;
        return this.relationCounter;
    }

    protected int getRelationCounter() {
        return this.relationCounter;
    }

    public POIXMLDocumentPart(OPCPackage pkg) {
        PackageRelationship coreRel = pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument").getRelationship(0);
        this.packagePart = pkg.getPart(coreRel);
        this.packageRel = coreRel;
    }

    public POIXMLDocumentPart() {
    }

    public POIXMLDocumentPart(PackagePart part, PackageRelationship rel) {
        this.packagePart = part;
        this.packageRel = rel;
    }

    public POIXMLDocumentPart(POIXMLDocumentPart parent, PackagePart part, PackageRelationship rel) {
        this.packagePart = part;
        this.packageRel = rel;
        this.parent = parent;
    }

    protected final void rebase(OPCPackage pkg) throws InvalidFormatException {
        PackageRelationshipCollection cores = this.packagePart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
        if (cores.size() != 1) {
            throw new IllegalStateException("Tried to rebase using http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument but found " + cores.size() + " parts of the right type");
        }
        this.packageRel = cores.getRelationship(0);
        this.packagePart = this.packagePart.getRelatedPart(this.packageRel);
    }

    public final PackagePart getPackagePart() {
        return this.packagePart;
    }

    public final PackageRelationship getPackageRelationship() {
        return this.packageRel;
    }

    public final List<POIXMLDocumentPart> getRelations() {
        return Collections.unmodifiableList(new ArrayList<POIXMLDocumentPart>(this.relations.values()));
    }

    public final POIXMLDocumentPart getRelationById(String id) {
        return this.relations.get(id);
    }

    public final String getRelationId(POIXMLDocumentPart part) {
        for (Map.Entry<String, POIXMLDocumentPart> entry : this.relations.entrySet()) {
            if (entry.getValue() != part) continue;
            return entry.getKey();
        }
        return null;
    }

    public final void addRelation(String id, POIXMLDocumentPart part) {
        this.relations.put(id, part);
        part.incrementRelationCounter();
    }

    protected final void removeRelation(POIXMLDocumentPart part) {
        this.removeRelation(part, true);
    }

    protected final boolean removeRelation(POIXMLDocumentPart part, boolean removeUnusedParts) {
        String id = this.getRelationId(part);
        if (id == null) {
            return false;
        }
        part.decrementRelationCounter();
        this.getPackagePart().removeRelationship(id);
        this.relations.remove(id);
        if (removeUnusedParts && part.getRelationCounter() == 0) {
            try {
                part.onDocumentRemove();
            }
            catch (IOException e) {
                throw new POIXMLException(e);
            }
            this.getPackagePart().getPackage().removePart(part.getPackagePart());
        }
        return true;
    }

    public final POIXMLDocumentPart getParent() {
        return this.parent;
    }

    public String toString() {
        return this.packagePart == null ? null : this.packagePart.toString();
    }

    protected void commit() throws IOException {
    }

    protected final void onSave(Set<PackagePart> alreadySaved) throws IOException {
        this.commit();
        alreadySaved.add(this.getPackagePart());
        for (POIXMLDocumentPart p : this.relations.values()) {
            if (alreadySaved.contains(p.getPackagePart())) continue;
            p.onSave(alreadySaved);
        }
    }

    public final POIXMLDocumentPart createRelationship(POIXMLRelation descriptor, POIXMLFactory factory) {
        return this.createRelationship(descriptor, factory, -1, false);
    }

    public final POIXMLDocumentPart createRelationship(POIXMLRelation descriptor, POIXMLFactory factory, int idx) {
        return this.createRelationship(descriptor, factory, idx, false);
    }

    protected final POIXMLDocumentPart createRelationship(POIXMLRelation descriptor, POIXMLFactory factory, int idx, boolean noRelation) {
        try {
            PackagePartName ppName = PackagingURIHelper.createPartName(descriptor.getFileName(idx));
            PackageRelationship rel = null;
            PackagePart part = this.packagePart.getPackage().createPart(ppName, descriptor.getContentType());
            if (!noRelation) {
                rel = this.packagePart.addRelationship(ppName, TargetMode.INTERNAL, descriptor.getRelation());
            }
            POIXMLDocumentPart doc = factory.newDocumentPart(descriptor);
            doc.packageRel = rel;
            doc.packagePart = part;
            doc.parent = this;
            if (!noRelation) {
                this.addRelation(rel.getId(), doc);
            }
            return doc;
        }
        catch (PartAlreadyExistsException pae) {
            throw pae;
        }
        catch (Exception e) {
            throw new POIXMLException(e);
        }
    }

    protected void read(POIXMLFactory factory, Map<PackagePart, POIXMLDocumentPart> context) throws OpenXML4JException {
        PackageRelationshipCollection rels = this.packagePart.getRelationships();
        for (PackageRelationship rel : rels) {
            PackagePart p;
            if (rel.getTargetMode() != TargetMode.INTERNAL) continue;
            URI uri = rel.getTargetURI();
            if (uri.getRawFragment() != null) {
                p = null;
            } else {
                PackagePartName relName = PackagingURIHelper.createPartName(uri);
                p = this.packagePart.getPackage().getPart(relName);
                if (p == null) {
                    logger.log(7, "Skipped invalid entry " + rel.getTargetURI());
                    continue;
                }
            }
            if (!context.containsKey(p)) {
                POIXMLDocumentPart childPart = factory.createDocumentPart(this, rel, p);
                childPart.parent = this;
                this.addRelation(rel.getId(), childPart);
                if (p == null) continue;
                context.put(p, childPart);
                if (!p.hasRelationships()) continue;
                childPart.read(factory, context);
                continue;
            }
            this.addRelation(rel.getId(), context.get(p));
        }
    }

    protected PackagePart getTargetPart(PackageRelationship rel) throws InvalidFormatException {
        return this.getPackagePart().getRelatedPart(rel);
    }

    protected void onDocumentCreate() throws IOException {
    }

    protected void onDocumentRead() throws IOException {
    }

    protected void onDocumentRemove() throws IOException {
    }

    protected void clearMemoryPackagePart(PackagePart part) {
        if (part instanceof MemoryPackagePart) {
            ((MemoryPackagePart)part).clear();
        }
    }

    static {
        DEFAULT_XML_OPTIONS.setSaveOuter();
        DEFAULT_XML_OPTIONS.setUseDefaultNamespace();
        DEFAULT_XML_OPTIONS.setSaveAggressiveNamespaces();
    }
}

