/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xwpf.usermodel;

import java.lang.reflect.Constructor;
import org.zkoss.poi.POIXMLDocumentPart;
import org.zkoss.poi.POIXMLException;
import org.zkoss.poi.POIXMLFactory;
import org.zkoss.poi.POIXMLRelation;
import org.zkoss.poi.openxml4j.opc.PackagePart;
import org.zkoss.poi.openxml4j.opc.PackageRelationship;
import org.zkoss.poi.util.POILogFactory;
import org.zkoss.poi.util.POILogger;
import org.zkoss.poi.xwpf.usermodel.XWPFRelation;

public final class XWPFFactory
extends POIXMLFactory {
    private static final POILogger logger = POILogFactory.getLogger(XWPFFactory.class);
    private static final XWPFFactory inst = new XWPFFactory();

    private XWPFFactory() {
    }

    public static XWPFFactory getInstance() {
        return inst;
    }

    @Override
    public POIXMLDocumentPart createDocumentPart(POIXMLDocumentPart parent, PackageRelationship rel, PackagePart part) {
        XWPFRelation descriptor = XWPFRelation.getInstance(rel.getRelationshipType());
        if (descriptor == null || descriptor.getRelationClass() == null) {
            logger.log(1, "using default POIXMLDocumentPart for " + rel.getRelationshipType());
            return new POIXMLDocumentPart(part, rel);
        }
        try {
            Class<? extends POIXMLDocumentPart> cls = descriptor.getRelationClass();
            try {
                Constructor<? extends POIXMLDocumentPart> constructor = cls.getDeclaredConstructor(POIXMLDocumentPart.class, PackagePart.class, PackageRelationship.class);
                return constructor.newInstance(parent, part, rel);
            }
            catch (NoSuchMethodException e) {
                Constructor<? extends POIXMLDocumentPart> constructor = cls.getDeclaredConstructor(PackagePart.class, PackageRelationship.class);
                return constructor.newInstance(part, rel);
            }
        }
        catch (Exception e) {
            throw new POIXMLException(e);
        }
    }

    @Override
    public POIXMLDocumentPart newDocumentPart(POIXMLRelation descriptor) {
        try {
            Class<? extends POIXMLDocumentPart> cls = descriptor.getRelationClass();
            Constructor<? extends POIXMLDocumentPart> constructor = cls.getDeclaredConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new POIXMLException(e);
        }
    }
}

