/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel;

import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageMargins;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageSetup;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellComments;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STOrientation;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPageOrder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPrintError;
import org.zkoss.poi.POIXMLException;
import org.zkoss.poi.ss.usermodel.PageOrder;
import org.zkoss.poi.ss.usermodel.PaperSize;
import org.zkoss.poi.ss.usermodel.PrintCellComments;
import org.zkoss.poi.ss.usermodel.PrintOrientation;
import org.zkoss.poi.ss.usermodel.PrintSetup;

public class XSSFPrintSetup
implements PrintSetup {
    private CTWorksheet ctWorksheet;
    private CTPageSetup pageSetup;
    private CTPageMargins pageMargins;

    protected XSSFPrintSetup(CTWorksheet worksheet) {
        this.ctWorksheet = worksheet;
        this.pageSetup = this.ctWorksheet.isSetPageSetup() ? this.ctWorksheet.getPageSetup() : this.ctWorksheet.addNewPageSetup();
        this.pageMargins = this.ctWorksheet.isSetPageMargins() ? this.ctWorksheet.getPageMargins() : this.ctWorksheet.addNewPageMargins();
    }

    @Override
    public void setPaperSize(short size) {
        this.pageSetup.setPaperSize((long)size);
    }

    public void setPaperSize(PaperSize size) {
        this.setPaperSize((short)(size.ordinal() + 1));
    }

    @Override
    public void setScale(short scale) {
        if (scale < 10 || scale > 400) {
            throw new POIXMLException("Scale value not accepted: you must choose a value between 10 and 400: " + scale);
        }
        this.pageSetup.setScale((long)scale);
    }

    @Override
    public void setPageStart(short start) {
        this.pageSetup.setFirstPageNumber((long)start);
    }

    @Override
    public void setFitWidth(short width) {
        this.pageSetup.setFitToWidth((long)width);
    }

    @Override
    public void setFitHeight(short height) {
        this.pageSetup.setFitToHeight((long)height);
    }

    @Override
    public void setLeftToRight(boolean ltor) {
        if (ltor) {
            this.setPageOrder(PageOrder.OVER_THEN_DOWN);
        }
    }

    @Override
    public void setLandscape(boolean ls) {
        if (ls) {
            this.setOrientation(PrintOrientation.LANDSCAPE);
        } else {
            this.setOrientation(PrintOrientation.PORTRAIT);
        }
    }

    @Override
    public void setValidSettings(boolean valid) {
        this.pageSetup.setUsePrinterDefaults(valid);
    }

    @Override
    public void setNoColor(boolean mono) {
        this.pageSetup.setBlackAndWhite(mono);
    }

    @Override
    public void setDraft(boolean d) {
        this.pageSetup.setDraft(d);
    }

    @Override
    public void setNotes(boolean printnotes) {
        if (printnotes) {
            this.pageSetup.setCellComments(STCellComments.AS_DISPLAYED);
        }
    }

    @Override
    public void setNoOrientation(boolean orientation) {
        if (orientation) {
            this.setOrientation(PrintOrientation.DEFAULT);
        }
    }

    @Override
    public void setUsePage(boolean page) {
        this.pageSetup.setUseFirstPageNumber(page);
    }

    @Override
    public void setHResolution(short resolution) {
        this.pageSetup.setHorizontalDpi((long)resolution);
    }

    @Override
    public void setVResolution(short resolution) {
        this.pageSetup.setVerticalDpi((long)resolution);
    }

    @Override
    public void setHeaderMargin(double headermargin) {
        this.pageMargins.setHeader(headermargin);
    }

    @Override
    public void setFooterMargin(double footermargin) {
        this.pageMargins.setFooter(footermargin);
    }

    @Override
    public void setCopies(short copies) {
        this.pageSetup.setCopies((long)copies);
    }

    public void setOrientation(PrintOrientation orientation) {
        STOrientation.Enum v = STOrientation.Enum.forInt((int)orientation.getValue());
        this.pageSetup.setOrientation(v);
    }

    public PrintOrientation getOrientation() {
        STOrientation.Enum val = this.pageSetup.getOrientation();
        return val == null ? PrintOrientation.DEFAULT : PrintOrientation.valueOf(val.intValue());
    }

    public PrintCellComments getCellComment() {
        STCellComments.Enum val = this.pageSetup.getCellComments();
        return val == null ? PrintCellComments.NONE : PrintCellComments.valueOf(val.intValue());
    }

    public void setPageOrder(PageOrder pageOrder) {
        STPageOrder.Enum v = STPageOrder.Enum.forInt((int)pageOrder.getValue());
        this.pageSetup.setPageOrder(v);
    }

    public PageOrder getPageOrder() {
        return this.pageSetup.getPageOrder() == null ? null : PageOrder.valueOf(this.pageSetup.getPageOrder().intValue());
    }

    @Override
    public short getPaperSize() {
        return (short)this.pageSetup.getPaperSize();
    }

    public PaperSize getPaperSizeEnum() {
        return PaperSize.values()[this.getPaperSize() - 1];
    }

    @Override
    public short getScale() {
        return (short)this.pageSetup.getScale();
    }

    @Override
    public short getPageStart() {
        return (short)this.pageSetup.getFirstPageNumber();
    }

    @Override
    public short getFitWidth() {
        return (short)(this.pageSetup.isSetFitToWidth() ? this.pageSetup.getFitToWidth() : 0L);
    }

    @Override
    public short getFitHeight() {
        return (short)(this.pageSetup.isSetFitToHeight() ? this.pageSetup.getFitToHeight() : 0L);
    }

    @Override
    public boolean getLeftToRight() {
        return this.getPageOrder() == PageOrder.OVER_THEN_DOWN;
    }

    @Override
    public boolean getLandscape() {
        return this.getOrientation() == PrintOrientation.LANDSCAPE;
    }

    @Override
    public boolean getValidSettings() {
        return this.pageSetup.getUsePrinterDefaults();
    }

    @Override
    public boolean getNoColor() {
        return this.pageSetup.getBlackAndWhite();
    }

    @Override
    public boolean getDraft() {
        return this.pageSetup.getDraft();
    }

    @Override
    public boolean getNotes() {
        return this.getCellComment() == PrintCellComments.AS_DISPLAYED;
    }

    @Override
    public boolean getNoOrientation() {
        return this.getOrientation() == PrintOrientation.DEFAULT;
    }

    @Override
    public boolean getUsePage() {
        return this.pageSetup.getUseFirstPageNumber();
    }

    @Override
    public short getHResolution() {
        return (short)this.pageSetup.getHorizontalDpi();
    }

    @Override
    public short getVResolution() {
        return (short)this.pageSetup.getVerticalDpi();
    }

    @Override
    public double getHeaderMargin() {
        return this.pageMargins.getHeader();
    }

    @Override
    public double getFooterMargin() {
        return this.pageMargins.getFooter();
    }

    @Override
    public short getCopies() {
        return (short)this.pageSetup.getCopies();
    }

    @Override
    public int getCommentsMode() {
        return this.getCellComment().getValue() - 1;
    }

    @Override
    public void setCommentsMode(int mode) {
        this.pageSetup.setCellComments(STCellComments.Enum.forInt((int)(mode + 1)));
    }

    @Override
    public int getErrorsMode() {
        STPrintError.Enum val = this.pageSetup.getErrors();
        return val.intValue() - 1;
    }

    @Override
    public void setErrorsMode(int mode) {
        if (mode < 0 || mode > 3) {
            mode = 0;
        }
        this.pageSetup.setErrors(STPrintError.Enum.forInt((int)(mode + 1)));
    }
}

