/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xslf.usermodel;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.apache.xmlbeans.XmlObject;
import org.zkoss.poi.util.Internal;
import org.zkoss.poi.xslf.usermodel.XSLFRenderingHint;

public abstract class XSLFShape {
    public abstract Rectangle2D getAnchor();

    public abstract void setAnchor(Rectangle2D var1);

    public abstract XmlObject getXmlObject();

    public abstract String getShapeName();

    public abstract int getShapeId();

    public abstract void setRotation(double var1);

    public abstract double getRotation();

    public abstract void setFlipHorizontal(boolean var1);

    public abstract void setFlipVertical(boolean var1);

    public abstract boolean getFlipHorizontal();

    public abstract boolean getFlipVertical();

    public abstract void draw(Graphics2D var1);

    protected void applyTransform(Graphics2D graphics) {
        double rotation;
        Rectangle2D anchor = this.getAnchor();
        AffineTransform tx = (AffineTransform)graphics.getRenderingHint(XSLFRenderingHint.GROUP_TRANSFORM);
        if (tx != null) {
            anchor = tx.createTransformedShape(anchor).getBounds2D();
        }
        if ((rotation = this.getRotation()) != 0.0) {
            double centerX = anchor.getX() + anchor.getWidth() / 2.0;
            double centerY = anchor.getY() + anchor.getHeight() / 2.0;
            graphics.translate(centerX, centerY);
            graphics.rotate(Math.toRadians(rotation));
            graphics.translate(-centerX, -centerY);
        }
        if (this.getFlipHorizontal()) {
            graphics.translate(anchor.getX() + anchor.getWidth(), anchor.getY());
            graphics.scale(-1.0, 1.0);
            graphics.translate(-anchor.getX(), -anchor.getY());
        }
        if (this.getFlipVertical()) {
            graphics.translate(anchor.getX(), anchor.getY() + anchor.getHeight());
            graphics.scale(1.0, -1.0);
            graphics.translate(-anchor.getX(), -anchor.getY());
        }
    }

    @Internal
    void copy(XSLFShape sh) {
        if (!this.getClass().isInstance(sh)) {
            throw new IllegalArgumentException("Can't copy " + sh.getClass().getSimpleName() + " into " + this.getClass().getSimpleName());
        }
        this.setAnchor(sh.getAnchor());
    }
}

