/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl.imexp;

import io.keikai.model.CellRegion;
import io.keikai.model.SAutoFilter;
import io.keikai.model.SBook;
import io.keikai.model.SBookSeries;
import io.keikai.model.SBooks;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SColor;
import io.keikai.model.SColorFilter;
import io.keikai.model.SComment;
import io.keikai.model.SCustomFilters;
import io.keikai.model.SDynamicFilter;
import io.keikai.model.SFill;
import io.keikai.model.SFont;
import io.keikai.model.SFooter;
import io.keikai.model.SHeader;
import io.keikai.model.SHyperlink;
import io.keikai.model.SName;
import io.keikai.model.SPicture;
import io.keikai.model.SPrintSetup;
import io.keikai.model.SRichText;
import io.keikai.model.SRow;
import io.keikai.model.SSheet;
import io.keikai.model.STop10Filter;
import io.keikai.model.ViewAnchor;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.model.impl.AbstractCellAdv;
import io.keikai.model.impl.HeaderFooterImpl;
import io.keikai.model.impl.NamedStyleImpl;
import io.keikai.model.impl.RichTextImpl;
import io.keikai.model.impl.SheetImpl;
import io.keikai.model.sys.formula.FormulaExpression;
import io.keikai.range.impl.imexp.AbstractImporter;
import io.keikai.range.impl.imexp.BookHelper;
import io.keikai.range.impl.imexp.PoiEnumConversion;
import io.keikai.range.impl.imexp.UnitUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.zkoss.poi.hssf.usermodel.HSSFRichTextString;
import org.zkoss.poi.ss.formula.eval.BoolEval;
import org.zkoss.poi.ss.formula.eval.ErrorEval;
import org.zkoss.poi.ss.formula.eval.NumberEval;
import org.zkoss.poi.ss.formula.eval.StringEval;
import org.zkoss.poi.ss.formula.eval.ValueEval;
import org.zkoss.poi.ss.formula.ptg.FuncVarPtg;
import org.zkoss.poi.ss.formula.ptg.Ptg;
import org.zkoss.poi.ss.usermodel.AutoFilter;
import org.zkoss.poi.ss.usermodel.Cell;
import org.zkoss.poi.ss.usermodel.CellStyle;
import org.zkoss.poi.ss.usermodel.ClientAnchor;
import org.zkoss.poi.ss.usermodel.Color;
import org.zkoss.poi.ss.usermodel.ColorFilter;
import org.zkoss.poi.ss.usermodel.Comment;
import org.zkoss.poi.ss.usermodel.CustomFilters;
import org.zkoss.poi.ss.usermodel.DynamicFilter;
import org.zkoss.poi.ss.usermodel.FilterColumn;
import org.zkoss.poi.ss.usermodel.Font;
import org.zkoss.poi.ss.usermodel.Footer;
import org.zkoss.poi.ss.usermodel.Header;
import org.zkoss.poi.ss.usermodel.Hyperlink;
import org.zkoss.poi.ss.usermodel.Name;
import org.zkoss.poi.ss.usermodel.NamedStyle;
import org.zkoss.poi.ss.usermodel.Picture;
import org.zkoss.poi.ss.usermodel.PictureData;
import org.zkoss.poi.ss.usermodel.PrintSetup;
import org.zkoss.poi.ss.usermodel.RichTextString;
import org.zkoss.poi.ss.usermodel.Row;
import org.zkoss.poi.ss.usermodel.Sheet;
import org.zkoss.poi.ss.usermodel.Top10Filter;
import org.zkoss.poi.ss.usermodel.Workbook;
import org.zkoss.poi.ss.util.CellRangeAddress;
import org.zkoss.poi.xssf.usermodel.XSSFRichTextString;
import org.zkoss.poi.xssf.usermodel.XSSFWorkbook;
import org.zkoss.util.Locales;
import org.zkoss.util.logging.Log;

public abstract class AbstractExcelImporter
extends AbstractImporter
implements Serializable {
    private static final long serialVersionUID = 6978036306999098019L;
    private static final Log _logger = Log.lookup(AbstractExcelImporter.class);
    protected Map<CellStyle, SCellStyle> importedStyle = new HashMap<CellStyle, SCellStyle>();
    protected Map<Short, SFont> importedFont = new HashMap<Short, SFont>();
    protected SBook book;
    protected Workbook workbook;
    protected Map<PictureData, Integer> importedPictureData = new HashMap<PictureData, Integer>();
    protected static String BOOK_TYPE_KEY = "$KK.BOOKTYPE$";
    protected boolean _importCache = false;

    protected void importDefaultCellStyles() {
        ((AbstractBookAdv)this.book).clearDefaultCellStyles();
        for (CellStyle poiStyle : this.workbook.getDefaultCellStyles()) {
            this.book.addDefaultCellStyle(this.importCellStyle(poiStyle, false));
        }
        if (this.book.getDefaultCellStyles().isEmpty()) {
            ((AbstractBookAdv)this.book).initDefaultCellStyles();
        }
        ((AbstractBookAdv)this.book).initDefaultFont();
    }

    protected void importNamedStyles() {
        ((AbstractBookAdv)this.book).clearNamedStyles();
        for (NamedStyle poiStyle : this.workbook.getNamedStyles()) {
            NamedStyleImpl namedStyle = new NamedStyleImpl(poiStyle.getName(), poiStyle.isCustomBuiltin(), poiStyle.getBuiltinId(), this.book, poiStyle.getIndex());
            this.book.addNamedCellstyle(namedStyle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SBook imports(InputStream is, String bookName) throws IOException {
        this.importedStyle.clear();
        this.importedFont.clear();
        this.workbook = this.createPoiBook(is);
        this.book = SBooks.createBook(bookName);
        Locale old = Locales.setThreadLocal((Locale)Locale.US);
        SBookSeries bookSeries = this.book.getBookSeries();
        boolean isCacheClean = bookSeries.isAutoFormulaCacheClean();
        try {
            int i;
            ((AbstractBookAdv)this.book).setPostProcessing(true);
            this.importDefaultCellStyles();
            this.importNamedStyles();
            this.importExtraStyles();
            this.importTableStyles();
            this.setBookType(this.book);
            bookSeries.setAutoFormulaCacheClean(false);
            this.importExternalBookLinks();
            int numberOfSheet = this.workbook.getNumberOfSheets();
            for (i = 0; i < numberOfSheet; ++i) {
                Sheet poiSheet = this.workbook.getSheetAt(i);
                this.importSheet(poiSheet, i);
                SSheet sheet = this.book.getSheet(i);
                this.importTables(poiSheet, sheet);
            }
            this.importNamedRange();
            for (i = 0; i < numberOfSheet; ++i) {
                SSheet sheet = this.book.getSheet(i);
                Sheet poiSheet = this.workbook.getSheetAt(i);
                for (Row poiRow : poiSheet) {
                    this.importRow(poiRow, sheet);
                }
                this.importColumn(poiSheet, sheet);
                this.importMergedRegions(poiSheet, sheet);
                this.importDrawings(poiSheet, sheet);
                this.importValidation(poiSheet, sheet);
                this.importAutoFilter(poiSheet, sheet);
                this.importSheetProtection(poiSheet, sheet);
            }
        }
        finally {
            this.book.getBookSeries().setAutoFormulaCacheClean(isCacheClean);
            Locales.setThreadLocal((Locale)old);
            ((AbstractBookAdv)this.book).setPostProcessing(false);
        }
        return this.book;
    }

    protected abstract Workbook createPoiBook(InputStream var1) throws IOException;

    protected abstract void setBookType(SBook var1);

    public static String getBookType(SBook book) {
        return (String)book.getAttribute(BOOK_TYPE_KEY);
    }

    protected abstract void importColumn(Sheet var1, SSheet var2);

    protected abstract int getAnchorWidthInPx(ClientAnchor var1, Sheet var2);

    protected abstract int getAnchorHeightInPx(ClientAnchor var1, Sheet var2);

    protected void importNamedRange() {
        for (int i = 0; i < this.workbook.getNumberOfNames(); ++i) {
            Name definedName = this.workbook.getNameAt(i);
            if (this.skipName(definedName)) continue;
            SName namedRange = null;
            namedRange = definedName.getSheetIndex() == -1 ? this.book.createName(definedName.getNameName()) : this.book.createName(definedName.getNameName(), definedName.getSheetName());
            namedRange.setRefersToFormula(definedName.getRefersToFormula());
        }
    }

    protected boolean skipName(Name definedName) {
        String namename = definedName.getNameName();
        if (namename == null) {
            return true;
        }
        if (definedName.isFunctionName()) {
            return true;
        }
        return definedName.getRefersToFormula() == null;
    }

    protected abstract void importExternalBookLinks();

    protected void importSheetDefaultColumnWidth(Sheet poiSheet, SSheet sheet) {
        int defaultWidth = UnitUtil.defaultColumnWidthToPx(poiSheet.getDefaultColumnWidth(), ((AbstractBookAdv)this.book).getCharWidth());
        sheet.setDefaultColumnWidth(defaultWidth);
    }

    protected SSheet importSheet(Sheet poiSheet, int poiSheetIndex) {
        CellRangeAddress colrng;
        CellRangeAddress rowrng;
        SFooter footer;
        SSheet sheet = this.book.createSheet(poiSheet.getSheetName());
        sheet.setDefaultRowHeight(UnitUtil.twipToPx(poiSheet.getDefaultRowHeight()));
        this.importSheetDefaultColumnWidth(poiSheet, sheet);
        sheet.getViewInfo().setNumOfRowFreeze(BookHelper.getRowFreeze(poiSheet));
        sheet.getViewInfo().setNumOfColumnFreeze(BookHelper.getColumnFreeze(poiSheet));
        sheet.getViewInfo().setDisplayGridlines(poiSheet.isDisplayGridlines());
        sheet.getViewInfo().setColumnBreaks(poiSheet.getColumnBreaks());
        sheet.getViewInfo().setRowBreaks(poiSheet.getRowBreaks());
        SPrintSetup sps = sheet.getPrintSetup();
        SHeader header = sheet.getViewInfo().getHeader();
        if (header != null) {
            header.setCenterText(poiSheet.getHeader().getCenter());
            header.setLeftText(poiSheet.getHeader().getLeft());
            header.setRightText(poiSheet.getHeader().getRight());
            sps.setHeader(header);
        }
        if ((footer = sheet.getViewInfo().getFooter()) != null) {
            footer.setCenterText(poiSheet.getFooter().getCenter());
            footer.setLeftText(poiSheet.getFooter().getLeft());
            footer.setRightText(poiSheet.getFooter().getRight());
            sps.setFooter(footer);
        }
        if (poiSheet.isDiffOddEven()) {
            Footer poiEvenFooter;
            Header poiEvenHeader = poiSheet.getEvenHeader();
            if (poiEvenHeader != null) {
                HeaderFooterImpl evenHeader = new HeaderFooterImpl();
                evenHeader.setCenterText(poiEvenHeader.getCenter());
                evenHeader.setLeftText(poiEvenHeader.getLeft());
                evenHeader.setRightText(poiEvenHeader.getRight());
                sps.setEvenHeader(evenHeader);
            }
            if ((poiEvenFooter = poiSheet.getEvenFooter()) != null) {
                HeaderFooterImpl evenFooter = new HeaderFooterImpl();
                evenFooter.setCenterText(poiEvenFooter.getCenter());
                evenFooter.setLeftText(poiEvenFooter.getLeft());
                evenFooter.setRightText(poiEvenFooter.getRight());
                sps.setEvenFooter(evenFooter);
            }
        }
        if (poiSheet.isDiffFirst()) {
            Footer poiFirstFooter;
            Header poiFirstHeader = poiSheet.getFirstHeader();
            if (poiFirstHeader != null) {
                HeaderFooterImpl firstHeader = new HeaderFooterImpl();
                firstHeader.setCenterText(poiFirstHeader.getCenter());
                firstHeader.setLeftText(poiFirstHeader.getLeft());
                firstHeader.setRightText(poiFirstHeader.getRight());
                sps.setFirstHeader(firstHeader);
            }
            if ((poiFirstFooter = poiSheet.getFirstFooter()) != null) {
                HeaderFooterImpl firstFooter = new HeaderFooterImpl();
                firstFooter.setCenterText(poiFirstFooter.getCenter());
                firstFooter.setLeftText(poiFirstFooter.getLeft());
                firstFooter.setRightText(poiFirstFooter.getRight());
                sps.setFirstFooter(firstFooter);
            }
        }
        PrintSetup poips = poiSheet.getPrintSetup();
        sps.setBottomMargin(poiSheet.getMargin((short)3));
        sps.setTopMargin(poiSheet.getMargin((short)2));
        sps.setLeftMargin(poiSheet.getMargin((short)0));
        sps.setRightMargin(poiSheet.getMargin((short)1));
        sps.setHeaderMargin(poiSheet.getMargin((short)4));
        sps.setFooterMargin(poiSheet.getMargin((short)5));
        sps.setAlignWithMargins(poiSheet.isAlignMargins());
        sps.setErrorPrintMode(poips.getErrorsMode());
        sps.setFitHeight(poips.getFitHeight());
        sps.setFitWidth(poips.getFitWidth());
        sps.setHCenter(poiSheet.getHorizontallyCenter());
        sps.setLandscape(poips.getLandscape());
        sps.setLeftToRight(poips.getLeftToRight());
        sps.setPageStart(poips.getUsePage() ? poips.getPageStart() : (short)0);
        sps.setPaperSize(PoiEnumConversion.toPaperSize(poips.getPaperSize()));
        sps.setCommentsMode(poips.getCommentsMode());
        sps.setPrintGridlines(poiSheet.isPrintGridlines());
        sps.setPrintHeadings(poiSheet.isPrintHeadings());
        sps.setScale(poips.getScale());
        sps.setScaleWithDoc(poiSheet.isScaleWithDoc());
        sps.setDifferentOddEvenPage(poiSheet.isDiffOddEven());
        sps.setDifferentFirstPage(poiSheet.isDiffFirst());
        sps.setVCenter(poiSheet.getVerticallyCenter());
        Workbook poiBook = poiSheet.getWorkbook();
        String area = poiBook.getPrintArea(poiSheetIndex);
        if (area != null) {
            sps.setPrintArea(area);
        }
        if ((rowrng = poiSheet.getRepeatingRows()) != null) {
            sps.setRepeatingRowsTitle(rowrng.getFirstRow(), rowrng.getLastRow());
        }
        if ((colrng = poiSheet.getRepeatingColumns()) != null) {
            sps.setRepeatingColumnsTitle(colrng.getFirstColumn(), colrng.getLastColumn());
        }
        sheet.setPassword(poiSheet.getProtect() ? "" : null);
        this.importPassword(poiSheet, sheet);
        if (poiBook.isSheetHidden(poiSheetIndex)) {
            sheet.setSheetVisible(SSheet.SheetVisible.HIDDEN);
        } else if (poiBook.isSheetVeryHidden(poiSheetIndex)) {
            sheet.setSheetVisible(SSheet.SheetVisible.VERY_HIDDEN);
        } else {
            sheet.setSheetVisible(SSheet.SheetVisible.VISIBLE);
        }
        this.importConditionalFormatting(sheet, poiSheet);
        return sheet;
    }

    protected abstract void importPassword(Sheet var1, SSheet var2);

    protected void importMergedRegions(Sheet poiSheet, SSheet sheet) {
        int nMerged = poiSheet.getNumMergedRegions();
        SheetImpl sheetImpl = (SheetImpl)sheet;
        for (int i = nMerged - 1; i >= 0; --i) {
            CellRangeAddress mergedRegion = poiSheet.getMergedRegion(i);
            CellRegion r = new CellRegion(mergedRegion.getFirstRow(), mergedRegion.getFirstColumn(), mergedRegion.getLastRow(), mergedRegion.getLastColumn());
            CellRegion overlapped = sheetImpl.checkMergedRegion(r);
            if (overlapped != null) {
                _logger.warning("Drop the region " + r + " which is overlapped with existing merged area " + overlapped + ".");
                continue;
            }
            sheetImpl.addDirectlyMergedRegion(r);
        }
    }

    protected abstract void importDrawings(Sheet var1, SSheet var2);

    protected abstract void importValidation(Sheet var1, SSheet var2);

    protected SRow importRow(Row poiRow, SSheet sheet) {
        SRow row = sheet.getRow(poiRow.getRowNum());
        row.setHeight(UnitUtil.twipToPx(poiRow.getHeight()));
        row.setCustomHeight(poiRow.isCustomHeight());
        row.setHidden(poiRow.getZeroHeight());
        CellStyle rowStyle = poiRow.getRowStyle();
        if (rowStyle != null) {
            row.setCellStyle(this.importCellStyle(rowStyle));
        }
        for (Cell poiCell : poiRow) {
            this.importCell(poiCell, poiRow.getRowNum(), sheet);
        }
        return row;
    }

    protected SCell importCell(Cell poiCell, int row, SSheet sheet) {
        Comment poiComment;
        SCell cell = sheet.getCell(row, poiCell.getColumnIndex());
        cell.setCellStyle(this.importCellStyle(poiCell.getCellStyle()));
        switch (poiCell.getCellType()) {
            case 0: {
                cell.setNumberValue(poiCell.getNumericCellValue());
                break;
            }
            case 1: {
                RichTextString poiRichTextString = poiCell.getRichStringCellValue();
                if (poiRichTextString != null && poiRichTextString.numFormattingRuns() > 0) {
                    SRichText richText = cell.setupRichTextValue();
                    this.importRichText(poiCell, poiRichTextString, richText);
                    break;
                }
                cell.setStringValue(poiCell.getStringCellValue());
                break;
            }
            case 4: {
                cell.setBooleanValue(poiCell.getBooleanCellValue());
                break;
            }
            case 2: {
                cell.setFormulaValue(poiCell.getCellFormula());
                if (!this.isImportCache() || poiCell.isCalcOnLoad() || this.mustCalc(cell)) break;
                BoolEval val = null;
                switch (poiCell.getCachedFormulaResultType()) {
                    case 0: {
                        val = new NumberEval(poiCell.getNumericCellValue());
                        break;
                    }
                    case 1: {
                        RichTextString poiRichTextString0 = poiCell.getRichStringCellValue();
                        if (poiRichTextString0 != null && poiRichTextString0.numFormattingRuns() > 0) {
                            RichTextImpl richText = new RichTextImpl();
                            this.importRichText(poiCell, poiRichTextString0, richText);
                            val = new StringEval(richText.getText());
                            break;
                        }
                        val = new StringEval(poiCell.getStringCellValue());
                        break;
                    }
                    case 4: {
                        val = BoolEval.valueOf((boolean)poiCell.getBooleanCellValue());
                        break;
                    }
                    case 5: {
                        val = ErrorEval.valueOf((int)poiCell.getErrorCellValue());
                        break;
                    }
                }
                if (val == null) break;
                ((AbstractCellAdv)cell).setFormulaResultValue((ValueEval)val);
                break;
            }
            case 5: {
                cell.setErrorValue(PoiEnumConversion.toErrorCode(poiCell.getErrorCellValue()));
                break;
            }
        }
        Hyperlink poiHyperlink = poiCell.getHyperlink();
        if (poiHyperlink != null) {
            String addr = poiHyperlink.getAddress();
            String label = poiHyperlink.getLabel();
            SHyperlink hyperlink = cell.setupHyperlink(PoiEnumConversion.toHyperlinkType(poiHyperlink.getType()), addr == null ? "" : addr, label == null ? "" : label);
            cell.setHyperlink(hyperlink);
        }
        if ((poiComment = poiCell.getCellComment()) != null) {
            SComment comment = cell.setupComment();
            comment.setAuthor(poiComment.getAuthor());
            comment.setVisible(poiComment.isVisible());
            RichTextString poiRichTextString = poiComment.getString();
            if (poiRichTextString != null && poiRichTextString.numFormattingRuns() > 0) {
                this.importRichText(poiCell, poiComment.getString(), comment.setupRichText());
            } else {
                comment.setText(poiComment.toString());
            }
        }
        return cell;
    }

    protected void importRichText(Cell poiCell, RichTextString poiRichTextString, SRichText richText) {
        int count = poiRichTextString.numFormattingRuns();
        if (count <= 0) {
            String cellValue = poiRichTextString.getString();
            richText.addSegment(cellValue, null);
        } else {
            String content;
            int i = 0;
            int prevFormattingRunIndex = poiRichTextString.getIndexOfFormattingRun(0);
            if (prevFormattingRunIndex > 0) {
                content = poiRichTextString.getStringAt(i);
                richText.addSegment(content, null);
                ++i;
            }
            while (i < count) {
                content = poiRichTextString.getStringAt(i);
                richText.addSegment(content, this.toZssFont(this.getPoiFontFromRichText(this.workbook, poiCell, poiRichTextString, i)));
                ++i;
            }
        }
    }

    protected SCellStyle importCellStyle(CellStyle poiCellStyle) {
        return this.importCellStyle(poiCellStyle, true);
    }

    protected SCellStyle importCellStyle(CellStyle poiCellStyle, boolean inStyleTable) {
        SCellStyle cellStyle = null;
        cellStyle = this.importedStyle.get(poiCellStyle);
        if (cellStyle == null) {
            cellStyle = this.book.createCellStyle(inStyleTable);
            this.importedStyle.put(poiCellStyle, cellStyle);
            String dataFormat = poiCellStyle.getRawDataFormatString();
            if (dataFormat == null) {
                dataFormat = "General";
            }
            if (!poiCellStyle.isBuiltinDataFormat()) {
                cellStyle.setDirectDataFormat(dataFormat);
            } else {
                cellStyle.setDataFormat(dataFormat);
            }
            cellStyle.setWrapText(poiCellStyle.getWrapText());
            cellStyle.setLocked(poiCellStyle.getLocked());
            cellStyle.setAlignment(PoiEnumConversion.toHorizontalAlignment(poiCellStyle.getAlignment()));
            cellStyle.setVerticalAlignment(PoiEnumConversion.toVerticalAlignment(poiCellStyle.getVerticalAlignment()));
            cellStyle.setRotation(poiCellStyle.getRotation());
            cellStyle.setIndention(poiCellStyle.getIndention());
            Color fgColor = poiCellStyle.getFillForegroundColorColor();
            Color bgColor = poiCellStyle.getFillBackgroundColorColor();
            cellStyle.setFillPattern(PoiEnumConversion.toFillPattern(poiCellStyle.getFillPattern()));
            SColor fgSColor = this.book.createColor(BookHelper.colorToForegroundHTML(this.workbook, fgColor));
            SColor bgSColor = this.book.createColor(BookHelper.colorToBackgroundHTML(this.workbook, bgColor));
            if (cellStyle.getFillPattern() == SFill.FillPattern.SOLID) {
                SColor tmp = fgSColor;
                fgSColor = bgSColor;
                bgSColor = tmp;
            }
            cellStyle.setFillColor(fgSColor);
            cellStyle.setBackColor(bgSColor);
            cellStyle.setBorderLeft(PoiEnumConversion.toBorderType(poiCellStyle.getBorderLeft()));
            cellStyle.setBorderTop(PoiEnumConversion.toBorderType(poiCellStyle.getBorderTop()));
            cellStyle.setBorderRight(PoiEnumConversion.toBorderType(poiCellStyle.getBorderRight()));
            cellStyle.setBorderBottom(PoiEnumConversion.toBorderType(poiCellStyle.getBorderBottom()));
            cellStyle.setBorderLeftColor(this.book.createColor(BookHelper.colorToBorderHTML(this.workbook, poiCellStyle.getLeftBorderColorColor())));
            cellStyle.setBorderTopColor(this.book.createColor(BookHelper.colorToBorderHTML(this.workbook, poiCellStyle.getTopBorderColorColor())));
            cellStyle.setBorderRightColor(this.book.createColor(BookHelper.colorToBorderHTML(this.workbook, poiCellStyle.getRightBorderColorColor())));
            cellStyle.setBorderBottomColor(this.book.createColor(BookHelper.colorToBorderHTML(this.workbook, poiCellStyle.getBottomBorderColorColor())));
            cellStyle.setHidden(poiCellStyle.getHidden());
            cellStyle.setFont(this.importFont(poiCellStyle));
        }
        return cellStyle;
    }

    protected SFont importFont(CellStyle poiCellStyle) {
        SFont font = null;
        short fontIndex = poiCellStyle.getFontIndex();
        if (this.importedFont.containsKey(fontIndex)) {
            font = this.importedFont.get(fontIndex);
        } else {
            Font poiFont = this.workbook.getFontAt(fontIndex);
            font = this.createZssFont(poiFont);
            this.importedFont.put(fontIndex, font);
        }
        return font;
    }

    protected SFont toZssFont(Font poiFont) {
        if (poiFont == null) {
            return null;
        }
        SFont font = null;
        short fontIndex = poiFont.getIndex();
        if (this.importedFont.containsKey(fontIndex)) {
            font = this.importedFont.get(fontIndex);
        } else {
            font = this.createZssFont(poiFont);
            this.importedFont.put(fontIndex, font);
        }
        return font;
    }

    protected SFont createZssFont(Font poiFont) {
        SFont font = this.book.createFont(true);
        font.setName(poiFont.getFontName());
        font.setBoldweight(PoiEnumConversion.toBoldweight(poiFont.getBoldweight()));
        font.setItalic(poiFont.getItalic());
        font.setStrikeout(poiFont.getStrikeout());
        font.setUnderline(PoiEnumConversion.toUnderline(poiFont.getUnderline()));
        font.setHeightPoints(poiFont.getFontHeightInPoints());
        font.setTypeOffset(PoiEnumConversion.toTypeOffset(poiFont.getTypeOffset()));
        font.setColor(this.book.createColor(BookHelper.getFontHTMLColor(this.workbook, poiFont)));
        return font;
    }

    protected ViewAnchor toViewAnchor(Sheet poiSheet, ClientAnchor clientAnchor) {
        int width = this.getAnchorWidthInPx(clientAnchor, poiSheet);
        int height = this.getAnchorHeightInPx(clientAnchor, poiSheet);
        ViewAnchor viewAnchor = new ViewAnchor(clientAnchor.getRow1(), clientAnchor.getCol1(), width, height);
        viewAnchor.setXOffset(this.getXoffsetInPixel(clientAnchor, poiSheet));
        viewAnchor.setYOffset(this.getYoffsetInPixel(clientAnchor, poiSheet));
        return viewAnchor;
    }

    protected abstract int getXoffsetInPixel(ClientAnchor var1, Sheet var2);

    protected abstract int getYoffsetInPixel(ClientAnchor var1, Sheet var2);

    protected void importPicture(List<Picture> poiPictures, Sheet poiSheet, SSheet sheet) {
        for (Picture poiPicture : poiPictures) {
            PictureData poiPicData = poiPicture.getPictureData();
            Integer picDataIx = this.importedPictureData.get(poiPicData);
            if (picDataIx != null) {
                sheet.addPicture(picDataIx, this.toViewAnchor(poiSheet, poiPicture.getClientAnchor()));
                continue;
            }
            SPicture.Format format = SPicture.Format.valueOfFileExtension(poiPicData.suggestFileExtension());
            if (format == null) continue;
            SPicture pic = sheet.addPicture(format, poiPicData.getData(), this.toViewAnchor(poiSheet, poiPicture.getClientAnchor()));
            this.importedPictureData.put(poiPicData, pic.getPictureData().getIndex());
        }
    }

    protected void importAutoFilter(Sheet poiSheet, SSheet sheet) {
        AutoFilter poiAutoFilter = poiSheet.getAutoFilter();
        if (poiAutoFilter != null) {
            CellRangeAddress filteringRange = poiAutoFilter.getRangeAddress();
            SAutoFilter autoFilter = sheet.createAutoFilter(new CellRegion(filteringRange.formatAsString()));
            int numberOfColumn = filteringRange.getLastColumn() - filteringRange.getFirstColumn() + 1;
            this.importAutoFilterColumns(poiAutoFilter, autoFilter, numberOfColumn);
        }
    }

    protected void importAutoFilterColumns(AutoFilter poiFilter, SAutoFilter zssFilter, int numberOfColumn) {
        HashMap<String, Object> extra = new HashMap<String, Object>();
        for (int i = 0; i < numberOfColumn; ++i) {
            FilterColumn poiColumn = poiFilter.getFilterColumn(i);
            if (poiColumn == null) continue;
            SAutoFilter.NFilterColumn destColumn = zssFilter.getFilterColumn(i, true);
            ColorFilter poiColorFilter = poiColumn.getColorFilter();
            SColorFilter destColorFilter = this.importColorFilter(poiColorFilter);
            extra.put("colorFilter", destColorFilter);
            CustomFilters poiCustomFilters = poiColumn.getCustomFilters();
            SCustomFilters destCustomFilters = this.importCustomFilters(poiCustomFilters);
            extra.put("customFilters", destCustomFilters);
            DynamicFilter poiDynamicFilter = poiColumn.getDynamicFilter();
            SDynamicFilter destDynamicFilter = this.importDynamicFilter(poiDynamicFilter);
            extra.put("dynamicFilter", destDynamicFilter);
            Top10Filter poiTop10Filter = poiColumn.getTop10Filter();
            STop10Filter destTop10Filter = this.importTop10Filter(poiTop10Filter);
            extra.put("top10Filter", destTop10Filter);
            destColumn.setProperties(PoiEnumConversion.toFilterOperator(poiColumn.getOperator()), poiColumn.getCriteria1(), poiColumn.getCriteria2(), poiColumn.isOn(), extra);
        }
    }

    protected abstract STop10Filter importTop10Filter(Top10Filter var1);

    protected abstract SDynamicFilter importDynamicFilter(DynamicFilter var1);

    protected abstract SCustomFilters importCustomFilters(CustomFilters var1);

    protected abstract SColorFilter importColorFilter(ColorFilter var1);

    protected Font getPoiFontFromRichText(Workbook book, Cell cell, RichTextString rstr, int run) {
        Font font;
        if (run < 0) {
            return null;
        }
        Object object = font = rstr instanceof HSSFRichTextString ? book.getFontAt(((HSSFRichTextString)rstr).getFontOfFormattingRun(run)) : ((XSSFRichTextString)rstr).getFontOfFormattingRun((XSSFWorkbook)book, run);
        if (font == null) {
            CellStyle style = cell.getCellStyle();
            short fontIndex = style != null ? style.getFontIndex() : (short)0;
            return book.getFontAt(fontIndex);
        }
        return font;
    }

    protected abstract void importSheetProtection(Sheet var1, SSheet var2);

    protected abstract void importTables(Sheet var1, SSheet var2);

    public void setImportCache(boolean b) {
        this._importCache = b;
    }

    protected boolean isImportCache() {
        return this._importCache;
    }

    protected boolean mustCalc(SCell cell) {
        FormulaExpression val = ((AbstractCellAdv)cell).getFormulaExpression();
        for (Ptg ptg : val.getPtgs()) {
            if (!(ptg instanceof FuncVarPtg) || ((FuncVarPtg)ptg).getFunctionIndex() != 148) continue;
            return true;
        }
        return false;
    }

    protected abstract void importConditionalFormatting(SSheet var1, Sheet var2);

    protected void importExtraStyles() {
    }

    protected void importTableStyles() {
    }
}

